/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.authentication.adaptive.intel;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.hc.core5.http.HttpEntityContainer;
import org.apache.hc.core5.http.HttpResponse;
import org.apereo.cas.authentication.adaptive.intel.BaseIPAddressIntelligenceService;
import org.apereo.cas.authentication.adaptive.intel.IPAddressIntelligenceResponse;
import org.apereo.cas.configuration.model.core.authentication.AdaptiveAuthenticationProperties;
import org.apereo.cas.multitenancy.TenantExtractor;
import org.apereo.cas.util.LoggingUtils;
import org.apereo.cas.util.http.HttpExecutionRequest;
import org.apereo.cas.util.http.HttpUtils;
import org.apereo.cas.util.serialization.JacksonObjectMapperFactory;
import org.apereo.cas.util.spring.SpringExpressionLanguageValueResolver;
import org.hjson.JsonValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.webflow.execution.RequestContext;

public class BlackDotIPAddressIntelligenceService
extends BaseIPAddressIntelligenceService {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(BlackDotIPAddressIntelligenceService.class);
    private static final ObjectMapper MAPPER = JacksonObjectMapperFactory.builder().defaultTypingEnabled(false).build().toObjectMapper();

    public BlackDotIPAddressIntelligenceService(TenantExtractor tenantExtractor, AdaptiveAuthenticationProperties adaptiveAuthenticationProperties) {
        super(tenantExtractor, adaptiveAuthenticationProperties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public IPAddressIntelligenceResponse examineInternal(RequestContext context, String clientIpAddress) {
        bannedResponse = IPAddressIntelligenceResponse.banned();
        response = null;
        properties = this.adaptiveAuthenticationProperties.getIpIntel().getBlackDot();
        resolvedUrl = SpringExpressionLanguageValueResolver.getInstance().resolve(properties.getUrl());
        builder = new StringBuilder(String.format(resolvedUrl, new Object[]{clientIpAddress}));
        builder.append("&format=json");
        if (StringUtils.isNotBlank((CharSequence)properties.getEmailAddress())) {
            builder.append("&contact=");
            builder.append(properties.getEmailAddress());
        }
        var9_9 = properties.getMode().toUpperCase(Locale.ENGLISH);
        var10_10 = -1;
        switch (var9_9.hashCode()) {
            case 300254581: {
                if (!var9_9.equals("DYNA_LIST")) break;
                var10_10 = 0;
                break;
            }
            case 709602033: {
                if (!var9_9.equals("DYNA_CHECK")) break;
                var10_10 = 1;
                break;
            }
        }
        switch (var10_10) {
            case 0: {
                v0 = "&flags=m";
                break;
            }
            case 1: {
                v0 = "&flags=b";
                break;
            }
            default: {
                v0 = "&flags=f";
            }
        }
        flags = v0;
        builder.append(flags);
        url = builder.toString();
        BlackDotIPAddressIntelligenceService.LOGGER.debug("Sending IP check request to [{}]", (Object)url);
        exec = HttpExecutionRequest.builder().method(HttpMethod.GET).url(url).maximumRetryAttempts(1).build();
        response = HttpUtils.execute((HttpExecutionRequest)exec);
        if (response == null || response.getCode() == HttpStatus.TOO_MANY_REQUESTS.value()) {
            BlackDotIPAddressIntelligenceService.LOGGER.error("Exceeded the number of allowed queries");
            var11_13 = bannedResponse;
        }
        ** GOTO lbl55
        {
            block32: {
                block26: {
                    block31: {
                        block29: {
                            block30: {
                                block27: {
                                    block28: {
                                        catch (Exception e) {
                                            LoggingUtils.error((Logger)BlackDotIPAddressIntelligenceService.LOGGER, (Throwable)e);
                                            HttpUtils.close(response);
                                            return bannedResponse;
                                        }
                                        catch (Throwable var18_26) {
                                            HttpUtils.close(response);
                                            throw var18_26;
                                        }
                                        HttpUtils.close((HttpResponse)response);
                                        return var11_13;
lbl55:
                                        // 1 sources

                                        content = ((HttpEntityContainer)response).getEntity().getContent();
                                        result = IOUtils.toString((InputStream)content, (Charset)StandardCharsets.UTF_8);
                                        BlackDotIPAddressIntelligenceService.LOGGER.debug("Received payload result after examining IP address [{}] as [{}]", (Object)clientIpAddress, (Object)result);
                                        json = (Map)BlackDotIPAddressIntelligenceService.MAPPER.readValue(JsonValue.readHjson((String)result).toString(), Map.class);
                                        status = json.getOrDefault("status", "error").toString();
                                        if (!"success".equalsIgnoreCase(status)) break block26;
                                        rank = Double.parseDouble(json.getOrDefault("result", 1).toString());
                                        if (rank != 1.0) break block27;
                                        var17_22 = bannedResponse;
                                        if (content == null) break block28;
                                        content.close();
                                    }
                                    HttpUtils.close((HttpResponse)response);
                                    return var17_22;
                                }
                                if (rank != 0.0) break block29;
                                var17_23 = IPAddressIntelligenceResponse.allowed();
                                if (content == null) break block30;
                                content.close();
                            }
                            HttpUtils.close((HttpResponse)response);
                            return var17_23;
                        }
                        var17_24 = IPAddressIntelligenceResponse.builder().score(rank).status(IPAddressIntelligenceResponse.IPAddressIntelligenceStatus.RANKED).build();
                        if (content == null) break block31;
                        content.close();
                    }
                    HttpUtils.close((HttpResponse)response);
                    return var17_24;
                }
                try {
                    message = json.getOrDefault("message", "Invalid IP address").toString();
                    BlackDotIPAddressIntelligenceService.LOGGER.error(message);
                    var16_25 = bannedResponse;
                    if (content == null) break block32;
                }
                catch (Throwable var12_16) {}
                {
                    if (content == null) throw var12_16;
                    try {
                        content.close();
                        throw var12_16;
                    }
                    catch (Throwable var13_18) {
                        var12_16.addSuppressed(var13_18);
                    }
                    throw var12_16;
                }
                content.close();
            }
            HttpUtils.close((HttpResponse)response);
            return var16_25;
        }
    }
}

