/*
 * Decompiled with CFR 0.152.
 */
package com.giffing.wicket.spring.boot.starter.app;

import com.giffing.wicket.spring.boot.context.extensions.WicketApplicationInitConfiguration;
import com.giffing.wicket.spring.boot.context.extensions.boot.actuator.WicketAutoConfig;
import com.giffing.wicket.spring.boot.context.extensions.boot.actuator.WicketEndpointRepository;
import com.giffing.wicket.spring.boot.context.scan.WicketHomePage;
import com.giffing.wicket.spring.boot.context.scan.WicketSignInPage;
import com.giffing.wicket.spring.boot.context.security.AuthenticatedWebSessionConfig;
import com.giffing.wicket.spring.boot.starter.app.WicketBootWebApplication;
import com.giffing.wicket.spring.boot.starter.app.classscanner.candidates.WicketClassCandidate;
import com.giffing.wicket.spring.boot.starter.app.classscanner.candidates.WicketClassCandidatesHolder;
import com.giffing.wicket.spring.boot.starter.configuration.extensions.core.settings.general.GeneralSettingsProperties;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.apache.wicket.Page;
import org.apache.wicket.RuntimeConfigurationType;
import org.apache.wicket.authroles.authentication.AbstractAuthenticatedWebSession;
import org.apache.wicket.authroles.authentication.AuthenticatedWebApplication;
import org.apache.wicket.markup.html.WebPage;
import org.apache.wicket.protocol.http.WebApplication;
import org.apache.wicket.spring.injection.annot.SpringComponentInjector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;

public class WicketBootSecuredWebApplication
extends AuthenticatedWebApplication
implements WicketBootWebApplication {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WicketBootSecuredWebApplication.class);
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private GeneralSettingsProperties generalSettingsProperties;
    @Autowired
    private List<WicketApplicationInitConfiguration> configurations = new ArrayList<WicketApplicationInitConfiguration>();
    @Autowired
    private WicketClassCandidatesHolder classCandidates;
    @Autowired
    private WicketEndpointRepository wicketEndpointRepository;

    protected void init() {
        super.init();
        this.getComponentInstantiationListeners().add((Object)new SpringComponentInjector((WebApplication)this, this.applicationContext));
        WicketAutoConfig.Builder builder = new WicketAutoConfig.Builder(this.getClass());
        this.wicketEndpointRepository.add(builder.withDetail("signInPages", this.classCandidates.getSignInPageCandidates()).withDetail("homePages", this.classCandidates.getHomePageCandidates()).build());
        for (WicketApplicationInitConfiguration configuration : this.configurations) {
            log.info("init-config: {}", (Object)configuration.getClass().getName());
            configuration.init((WebApplication)this);
        }
    }

    public RuntimeConfigurationType getConfigurationType() {
        return this.generalSettingsProperties.getConfigurationType();
    }

    protected Class<? extends AbstractAuthenticatedWebSession> getWebSessionClass() {
        return ((AuthenticatedWebSessionConfig)this.applicationContext.getBean(AuthenticatedWebSessionConfig.class)).getAuthenticatedWebSessionClass();
    }

    protected Class<? extends WebPage> getSignInPageClass() {
        if (this.classCandidates.getSignInPageCandidates().isEmpty()) {
            throw new IllegalStateException("Couldn't find sign in page - please annotate the sign in page with @" + WicketSignInPage.class.getName());
        }
        if (this.classCandidates.getSignInPageCandidates().size() > 1) {
            String message = "Multiple sign in pages found - please annotate exactly one class with @" + WicketSignInPage.class.getName();
            message = message + "\n";
            for (WicketClassCandidate<WebPage> classCandidate : this.classCandidates.getSignInPageCandidates()) {
                message = message + "\t" + String.valueOf(classCandidate.getCandidate()) + "\n";
            }
            throw new IllegalStateException(message);
        }
        return this.classCandidates.getSignInPageCandidates().iterator().next().getCandidate();
    }

    public Class<? extends Page> getHomePage() {
        if (this.classCandidates.getHomePageCandidates().isEmpty()) {
            throw new IllegalStateException("Couldn't find home page - please annotate the home page with @" + WicketHomePage.class.getName());
        }
        if (this.classCandidates.getHomePageCandidates().size() > 1) {
            String message = "Multiple home pages found - please annotate exactly one class with @" + WicketHomePage.class.getName();
            message = message + "\n";
            for (WicketClassCandidate<Page> classCandidate : this.classCandidates.getHomePageCandidates()) {
                message = message + "\t" + String.valueOf(classCandidate.getCandidate()) + "\n";
            }
            throw new IllegalStateException(message);
        }
        return this.classCandidates.getHomePageCandidates().iterator().next().getCandidate();
    }

    @Generated
    public WicketBootSecuredWebApplication() {
    }

    @Generated
    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    @Generated
    public GeneralSettingsProperties getGeneralSettingsProperties() {
        return this.generalSettingsProperties;
    }

    @Generated
    public List<WicketApplicationInitConfiguration> getConfigurations() {
        return this.configurations;
    }
}

