/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.wizards.any;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.syncope.client.console.wizards.any.AbstractAttrs;
import org.apache.syncope.client.console.wizards.any.AbstractAttrsWizardStep;
import org.apache.syncope.client.ui.commons.wicket.markup.html.bootstrap.tabs.Accordion;
import org.apache.syncope.client.ui.commons.wizards.AjaxWizard;
import org.apache.syncope.client.ui.commons.wizards.any.AnyWrapper;
import org.apache.syncope.client.ui.commons.wizards.any.UserWrapper;
import org.apache.syncope.common.lib.Attr;
import org.apache.syncope.common.lib.EntityTOUtils;
import org.apache.syncope.common.lib.to.AnyObjectTO;
import org.apache.syncope.common.lib.to.AttributableTO;
import org.apache.syncope.common.lib.to.GroupTO;
import org.apache.syncope.common.lib.to.GroupableRelatableTO;
import org.apache.syncope.common.lib.to.MembershipTO;
import org.apache.syncope.common.lib.to.PlainSchemaTO;
import org.apache.syncope.common.lib.to.RelationshipTO;
import org.apache.syncope.common.lib.to.UserTO;
import org.apache.syncope.common.lib.types.AttrSchemaType;
import org.apache.syncope.common.lib.types.SchemaType;
import org.apache.wicket.Component;
import org.apache.wicket.extensions.markup.html.tabs.AbstractTab;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.model.StringResourceModel;
import org.apache.wicket.model.util.ListModel;

public class PlainAttrs
extends AbstractAttrs<PlainSchemaTO> {
    private static final long serialVersionUID = 552437609667518888L;

    public <T extends AttributableTO> PlainAttrs(AnyWrapper<T> modelObject, AjaxWizard.Mode mode, List<String> anyTypeClasses, List<String> whichPlainAttrs) throws IllegalArgumentException {
        super(modelObject, mode, anyTypeClasses, whichPlainAttrs);
        UserTO userTO;
        AttributableTO attributableTO = modelObject.getInnerObject();
        if (attributableTO instanceof UserTO) {
            UserTO userTO2 = (UserTO)attributableTO;
            v0 = userTO2.getUsername();
        } else {
            attributableTO = modelObject.getInnerObject();
            if (attributableTO instanceof GroupTO) {
                GroupTO groupTO = (GroupTO)attributableTO;
                v0 = groupTO.getName();
            } else {
                attributableTO = modelObject.getInnerObject();
                if (attributableTO instanceof AnyObjectTO) {
                    AnyObjectTO anyObjectTO = (AnyObjectTO)attributableTO;
                    v0 = anyObjectTO.getName();
                } else {
                    v0 = this.fileKey = null;
                }
            }
        }
        if (modelObject instanceof UserWrapper) {
            UserWrapper uw = (UserWrapper)modelObject;
            userTO = uw.getPreviousUserTO();
        } else {
            userTO = null;
        }
        this.previousObject = userTO;
        this.setTitleModel((IModel)new ResourceModel("attributes.plain"));
        this.add(new Component[]{new Accordion("plainSchemas", List.of(new AbstractTab((IModel)new ResourceModel("attributes.accordion", "Plain Attributes")){
            private static final long serialVersionUID = 1037272333056449378L;

            public WebMarkupContainer getPanel(String panelId) {
                return new PlainSchemasOwn(panelId, PlainAttrs.this.schemas, (IModel<List<Attr>>)PlainAttrs.this.attrs);
            }
        }), (IModel)Model.of((Serializable)Integer.valueOf(0))).setOutputMarkupId(true)});
        this.add(new Component[]{new ListView<MembershipTO>("membershipsPlainSchemas", this.memberships){
            private static final long serialVersionUID = 6741044372185745296L;

            protected void populateItem(ListItem<MembershipTO> item) {
                final MembershipTO membershipTO = (MembershipTO)item.getModelObject();
                item.add(new Component[]{new Accordion("membershipPlainSchemas", List.of(new AbstractTab(this, (IModel)new StringResourceModel("attributes.membership.accordion", (Component)PlainAttrs.this, (IModel)Model.of((Serializable)membershipTO))){
                    private static final long serialVersionUID = 1037272333056449378L;
                    final /* synthetic */ 2 this$1;
                    {
                        this.this$1 = this$1;
                        super(title);
                    }

                    public WebMarkupContainer getPanel(String panelId) {
                        return new PlainSchemasAttributable(panelId, (Map)this.this$1.PlainAttrs.this.membershipSchemas.get(membershipTO.getGroupKey()), (IModel<AttributableTO>)new LoadableDetachableModel<AttributableTO>(this){
                            private static final long serialVersionUID = 526768546610546553L;
                            final /* synthetic */ 1 this$2;
                            {
                                this.this$2 = this$2;
                            }

                            protected AttributableTO load() {
                                return membershipTO;
                            }
                        });
                    }
                }), (IModel)Model.of((Serializable)Integer.valueOf(-1))).setOutputMarkupId(true)});
            }
        }});
        this.add(new Component[]{new ListView<RelationshipTO>("relationshipsPlainSchemas", this.relationships){
            private static final long serialVersionUID = 6741044372185745296L;

            protected void populateItem(ListItem<RelationshipTO> item) {
                final RelationshipTO relationshipTO = (RelationshipTO)item.getModelObject();
                item.add(new Component[]{new Accordion("relationshipPlainSchemas", List.of(new AbstractTab(this, (IModel)new StringResourceModel("attributes.relationship.accordion", (Component)PlainAttrs.this, (IModel)Model.of((Serializable)relationshipTO))){
                    private static final long serialVersionUID = 1037272333056449378L;
                    final /* synthetic */ 3 this$1;
                    {
                        this.this$1 = this$1;
                        super(title);
                    }

                    public WebMarkupContainer getPanel(String panelId) {
                        return new PlainSchemasAttributable(panelId, (Map)this.this$1.PlainAttrs.this.relationshipSchemas.get(Pair.of((Object)relationshipTO.getType(), (Object)relationshipTO.getOtherEndKey())), (IModel<AttributableTO>)new LoadableDetachableModel<AttributableTO>(this){
                            private static final long serialVersionUID = 526768546610546553L;
                            final /* synthetic */ 1 this$2;
                            {
                                this.this$2 = this$2;
                            }

                            protected AttributableTO load() {
                                return relationshipTO;
                            }
                        });
                    }
                }), (IModel)Model.of((Serializable)Integer.valueOf(-1))).setOutputMarkupId(true)});
            }
        }});
    }

    @Override
    protected SchemaType getSchemaType() {
        return SchemaType.PLAIN;
    }

    @Override
    protected boolean reoderSchemas() {
        return super.reoderSchemas() && this.mode != AjaxWizard.Mode.TEMPLATE;
    }

    @Override
    protected List<Attr> getAttrsFromTO() {
        return this.attributable.getPlainAttrs().stream().sorted(this.attrComparator).collect(Collectors.toList());
    }

    @Override
    protected List<Attr> getAttrsFromTO(MembershipTO membershipTO) {
        return membershipTO.getPlainAttrs().stream().sorted(this.attrComparator).collect(Collectors.toList());
    }

    @Override
    protected List<Attr> getAttrsFromTO(RelationshipTO relationshipTO) {
        return relationshipTO.getPlainAttrs().stream().sorted(this.attrComparator).collect(Collectors.toList());
    }

    @Override
    protected void setAttrs() {
        Map attrMap = EntityTOUtils.buildAttrMap((Collection)this.attributable.getPlainAttrs());
        List<Attr> plainAttrs = this.schemas.values().stream().map(schema -> {
            Attr attr = new Attr();
            attr.setSchema(schema.getKey());
            if (attrMap.get(schema.getKey()) == null || ((Attr)attrMap.get(schema.getKey())).getValues().isEmpty()) {
                if (schema.getType() != AttrSchemaType.Dropdown || !schema.isMultivalue()) {
                    attr.getValues().add("");
                }
            } else {
                attr = (Attr)attrMap.get(schema.getKey());
            }
            return attr;
        }).toList();
        this.attributable.getPlainAttrs().clear();
        this.attributable.getPlainAttrs().addAll(plainAttrs);
    }

    @Override
    protected void setAttrs(MembershipTO membershipTO) {
        Map attrMap = ((GroupableRelatableTO)GroupableRelatableTO.class.cast(this.attributable)).getMembership(membershipTO.getGroupKey()).map(gr -> EntityTOUtils.buildAttrMap((Collection)gr.getPlainAttrs())).orElseGet(HashMap::new);
        List<Attr> plainAttrs = ((Map)this.membershipSchemas.get(membershipTO.getGroupKey())).values().stream().map(schema -> {
            Attr attr = new Attr();
            attr.setSchema(schema.getKey());
            if (attrMap.get(schema.getKey()) == null || ((Attr)attrMap.get(schema.getKey())).getValues().isEmpty()) {
                if (schema.getType() != AttrSchemaType.Dropdown || !schema.isMultivalue()) {
                    attr.getValues().add("");
                }
            } else {
                attr.getValues().addAll(((Attr)attrMap.get(schema.getKey())).getValues());
            }
            return attr;
        }).toList();
        membershipTO.getPlainAttrs().clear();
        membershipTO.getPlainAttrs().addAll(plainAttrs);
    }

    @Override
    protected void setAttrs(RelationshipTO relationshipTO) {
        Map attrMap = ((GroupableRelatableTO)GroupableRelatableTO.class.cast(this.attributable)).getRelationship(relationshipTO.getType(), relationshipTO.getOtherEndKey()).map(gr -> EntityTOUtils.buildAttrMap((Collection)gr.getPlainAttrs())).orElseGet(HashMap::new);
        List<Attr> plainAttrs = ((Map)this.relationshipSchemas.get(Pair.of((Object)relationshipTO.getType(), (Object)relationshipTO.getOtherEndKey()))).values().stream().map(schema -> {
            Attr attr = new Attr();
            attr.setSchema(schema.getKey());
            if (attrMap.get(schema.getKey()) == null || ((Attr)attrMap.get(schema.getKey())).getValues().isEmpty()) {
                if (schema.getType() != AttrSchemaType.Dropdown || !schema.isMultivalue()) {
                    attr.getValues().add("");
                }
            } else {
                attr.getValues().addAll(((Attr)attrMap.get(schema.getKey())).getValues());
            }
            return attr;
        }).toList();
        relationshipTO.getPlainAttrs().clear();
        relationshipTO.getPlainAttrs().addAll(plainAttrs);
    }

    protected class PlainSchemasAttributable
    extends AbstractAttrsWizardStep.PlainSchemas<AttributableTO> {
        private static final long serialVersionUID = 456754923340249215L;

        public PlainSchemasAttributable(String id, final Map<String, PlainSchemaTO> schemas, IModel<AttributableTO> attributableTO) {
            super(id);
            this.add(new Component[]{new ListView<Attr>(this, "schemas", (IModel)new ListModel(((AttributableTO)attributableTO.getObject()).getPlainAttrs().stream().sorted(PlainAttrs.this.attrComparator).collect(Collectors.toList()))){
                private static final long serialVersionUID = 5306618783986001008L;
                final /* synthetic */ PlainSchemasAttributable this$1;
                {
                    this.this$1 = this$1;
                    super(id, model);
                }

                protected void populateItem(ListItem<Attr> item) {
                    PlainSchemaTO schema = (PlainSchemaTO)schemas.get(((Attr)item.getModelObject()).getSchema());
                    this.this$1.setPanel(schemas, item, schema == null ? false : schema.isReadonly());
                }
            }});
        }
    }

    protected class PlainSchemasOwn
    extends AbstractAttrsWizardStep.PlainSchemas<List<Attr>> {
        private static final long serialVersionUID = -4730563859116024676L;

        public PlainSchemasOwn(String id, final Map<String, PlainSchemaTO> schemas, IModel<List<Attr>> attrTOs) {
            super(id);
            this.add(new Component[]{new ListView<Attr>(this, "schemas", attrTOs){
                private static final long serialVersionUID = 9101744072914090143L;
                final /* synthetic */ PlainSchemasOwn this$1;
                {
                    this.this$1 = this$1;
                    super(id, model);
                }

                protected void populateItem(ListItem<Attr> item) {
                    PlainSchemaTO schema = (PlainSchemaTO)schemas.get(((Attr)item.getModelObject()).getSchema());
                    this.this$1.setPanel(schemas, item, schema == null ? false : schema.isReadonly());
                }
            }});
        }
    }
}

