/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.wizards.any;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.syncope.client.console.rest.GroupRestClient;
import org.apache.syncope.client.console.rest.RelationshipTypeRestClient;
import org.apache.syncope.client.console.wizards.any.AbstractAttrsWizardStep;
import org.apache.syncope.client.console.wizards.any.DerAttrs;
import org.apache.syncope.client.console.wizards.any.PlainAttrs;
import org.apache.syncope.client.ui.commons.wizards.AjaxWizard;
import org.apache.syncope.client.ui.commons.wizards.any.AnyWrapper;
import org.apache.syncope.common.lib.Attr;
import org.apache.syncope.common.lib.to.AnyTO;
import org.apache.syncope.common.lib.to.AnyTypeClassTO;
import org.apache.syncope.common.lib.to.AttributableTO;
import org.apache.syncope.common.lib.to.GroupTO;
import org.apache.syncope.common.lib.to.GroupableRelatableTO;
import org.apache.syncope.common.lib.to.MembershipTO;
import org.apache.syncope.common.lib.to.RelatableTO;
import org.apache.syncope.common.lib.to.RelationshipTO;
import org.apache.syncope.common.lib.to.RelationshipTypeTO;
import org.apache.syncope.common.lib.to.SchemaTO;
import org.apache.syncope.common.lib.to.TypeExtensionTO;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.OnDomReadyHeaderItem;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.util.ListModel;
import org.apache.wicket.spring.injection.annot.SpringBean;

public abstract class AbstractAttrs<S extends SchemaTO>
extends AbstractAttrsWizardStep<S> {
    private static final long serialVersionUID = -5387344116983102292L;
    @SpringBean
    protected GroupRestClient groupRestClient;
    @SpringBean
    protected RelationshipTypeRestClient relationshipTypeRestClient;
    protected final IModel<List<MembershipTO>> memberships;
    protected final IModel<List<RelationshipTO>> relationships;
    protected final Map<String, Map<String, S>> membershipSchemas = new LinkedHashMap<String, Map<String, S>>();
    protected final Map<Pair<String, String>, Map<String, S>> relationshipSchemas = new LinkedHashMap<Pair<String, String>, Map<String, S>>();

    public AbstractAttrs(AnyWrapper<?> modelObject, AjaxWizard.Mode mode, List<String> anyTypeClasses, List<String> whichAttrs) {
        super(modelObject.getInnerObject(), mode, anyTypeClasses, whichAttrs);
        this.memberships = new ListModel(List.of());
        this.relationships = new ListModel(List.of());
        this.setOutputMarkupId(true);
    }

    private List<MembershipTO> loadMemberships() {
        AttributableTO attributableTO = this.attributable;
        if (attributableTO instanceof GroupableRelatableTO) {
            GroupableRelatableTO anyTO = (GroupableRelatableTO)attributableTO;
            this.membershipSchemas.clear();
            ArrayList<MembershipTO> membs = new ArrayList<MembershipTO>();
            anyTO.getMemberships().forEach(memb -> {
                this.setSchemas(memb.getGroupKey(), this.anyTypeClassRestClient.list(this.getMembershipAuxClasses(memb.getGroupKey(), ((AnyTO)anyTO).getType())).stream().map(AnyTypeClassTO::getKey).collect(Collectors.toList()));
                this.setAttrs((MembershipTO)memb);
                if (this instanceof PlainAttrs && !memb.getPlainAttrs().isEmpty()) {
                    membs.add((MembershipTO)memb);
                } else if (this instanceof DerAttrs && !memb.getDerAttrs().isEmpty()) {
                    membs.add((MembershipTO)memb);
                }
            });
            return membs;
        }
        return List.of();
    }

    private List<RelationshipTO> loadRelationships() {
        AttributableTO attributableTO = this.attributable;
        if (attributableTO instanceof RelatableTO) {
            RelatableTO anyTO = (RelatableTO)attributableTO;
            this.relationshipSchemas.clear();
            ArrayList<RelationshipTO> rels = new ArrayList<RelationshipTO>();
            anyTO.getRelationships().forEach(rel -> {
                this.setSchemas((Pair<String, String>)Pair.of((Object)rel.getType(), (Object)rel.getOtherEndKey()), this.anyTypeClassRestClient.list(this.getRelationshipAuxClasses(rel.getType(), ((AnyTO)anyTO).getType())).stream().map(AnyTypeClassTO::getKey).collect(Collectors.toList()));
                this.setAttrs((RelationshipTO)rel);
                if (this instanceof PlainAttrs && !rel.getPlainAttrs().isEmpty()) {
                    rels.add((RelationshipTO)rel);
                } else if (this instanceof DerAttrs && !rel.getDerAttrs().isEmpty()) {
                    rels.add((RelationshipTO)rel);
                }
            });
            return rels;
        }
        return List.of();
    }

    private void setSchemas(String membership, List<String> anyTypeClasses) {
        Map<Object, Object> mscs;
        if (this.membershipSchemas.containsKey(membership)) {
            mscs = this.membershipSchemas.get(membership);
        } else {
            mscs = new LinkedHashMap();
            this.membershipSchemas.put(membership, mscs);
        }
        this.setSchemas(anyTypeClasses, mscs);
    }

    private void setSchemas(Pair<String, String> relationship, List<String> anyTypeClasses) {
        Map<Object, Object> mscs;
        if (this.relationshipSchemas.containsKey(relationship)) {
            mscs = this.relationshipSchemas.get(relationship);
        } else {
            mscs = new LinkedHashMap();
            this.relationshipSchemas.put(relationship, mscs);
        }
        this.setSchemas(anyTypeClasses, mscs);
    }

    protected List<String> getMembershipAuxClasses(String group, String anyType) {
        try {
            GroupTO groupTO = (GroupTO)this.groupRestClient.read(group);
            return groupTO.getTypeExtension(anyType).map(TypeExtensionTO::getAuxClasses).orElseGet(List::of);
        }
        catch (Exception e) {
            return List.of();
        }
    }

    protected List<String> getRelationshipAuxClasses(String relationshipType, String anyType) {
        try {
            RelationshipTypeTO typeTO = this.relationshipTypeRestClient.read(relationshipType);
            return typeTO.getTypeExtension(anyType).map(TypeExtensionTO::getAuxClasses).orElseGet(List::of);
        }
        catch (Exception e) {
            return List.of();
        }
    }

    protected abstract void setAttrs(MembershipTO var1);

    protected abstract void setAttrs(RelationshipTO var1);

    protected abstract List<Attr> getAttrsFromTO(MembershipTO var1);

    protected abstract List<Attr> getAttrsFromTO(RelationshipTO var1);

    @Override
    public void renderHead(IHeaderResponse response) {
        super.renderHead(response);
        if (CollectionUtils.isEmpty((Collection)((Collection)this.attrs.getObject())) && CollectionUtils.isEmpty((Collection)((Collection)this.memberships.getObject())) && CollectionUtils.isEmpty((Collection)((Collection)this.relationships.getObject()))) {
            response.render((HeaderItem)OnDomReadyHeaderItem.forScript((CharSequence)String.format("$('#emptyPlaceholder').append(\"%s\"); $('#attributes').hide();", this.getString("attribute.empty.list"))));
        }
    }

    @Override
    public boolean evaluate() {
        this.attrs.setObject(this.loadAttrs());
        this.memberships.setObject(this.loadMemberships());
        this.relationships.setObject(this.loadRelationships());
        return !((List)this.attrs.getObject()).isEmpty() || !((List)this.memberships.getObject()).isEmpty() || !((List)this.relationships.getObject()).isEmpty();
    }
}

