/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.spring.security;

import com.fasterxml.jackson.core.type.TypeReference;
import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.jca.JCAContext;
import com.nimbusds.jose.util.Base64URL;
import com.nimbusds.jwt.JWTClaimsSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.apache.syncope.common.lib.types.CipherAlgorithm;
import org.apache.syncope.core.persistence.api.EncryptorManager;
import org.apache.syncope.core.persistence.api.dao.AccessTokenDAO;
import org.apache.syncope.core.persistence.api.dao.UserDAO;
import org.apache.syncope.core.persistence.api.entity.AccessToken;
import org.apache.syncope.core.persistence.api.entity.user.User;
import org.apache.syncope.core.provisioning.api.serialization.POJOHelper;
import org.apache.syncope.core.spring.security.JWTSSOProvider;
import org.apache.syncope.core.spring.security.SecurityProperties;
import org.apache.syncope.core.spring.security.SyncopeGrantedAuthority;
import org.apache.syncope.core.spring.security.jws.AccessTokenJWSVerifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.AuthenticationCredentialsNotFoundException;
import org.springframework.transaction.annotation.Transactional;

public class SyncopeJWTSSOProvider
implements JWTSSOProvider {
    protected static final Logger LOG = LoggerFactory.getLogger(SyncopeJWTSSOProvider.class);
    protected final SecurityProperties securityProperties;
    protected final EncryptorManager encryptorManager;
    protected final AccessTokenJWSVerifier delegate;
    protected final UserDAO userDAO;
    protected final AccessTokenDAO accessTokenDAO;

    public SyncopeJWTSSOProvider(SecurityProperties securityProperties, EncryptorManager encryptorManager, AccessTokenJWSVerifier delegate, UserDAO userDAO, AccessTokenDAO accessTokenDAO) {
        this.securityProperties = securityProperties;
        this.encryptorManager = encryptorManager;
        this.delegate = delegate;
        this.userDAO = userDAO;
        this.accessTokenDAO = accessTokenDAO;
    }

    @Override
    public String getIssuer() {
        return this.securityProperties.getJwtIssuer();
    }

    public Set<JWSAlgorithm> supportedJWSAlgorithms() {
        return this.delegate.supportedJWSAlgorithms();
    }

    public JCAContext getJCAContext() {
        return this.delegate.getJCAContext();
    }

    public boolean verify(JWSHeader header, byte[] signingInput, Base64URL signature) throws JOSEException {
        return this.delegate.verify(header, signingInput, signature);
    }

    @Override
    @Transactional(readOnly=true)
    public Optional<JWTSSOProvider.ResolvedClaims> resolve(JWTClaimsSet jwtClaims) {
        AccessToken accessToken = (AccessToken)this.accessTokenDAO.findById(jwtClaims.getJWTID()).orElseThrow(() -> new AuthenticationCredentialsNotFoundException("Could not find an Access Token for JWT " + jwtClaims.getJWTID()));
        HashSet authorities = new HashSet();
        if (accessToken.getAuthorities() != null) {
            try {
                authorities.addAll((Collection)POJOHelper.deserialize((String)this.encryptorManager.getInstance().decode(accessToken.getAuthorities(), CipherAlgorithm.AES), (TypeReference)new TypeReference<Collection<? extends SyncopeGrantedAuthority>>(this){}));
            }
            catch (Throwable t) {
                LOG.error("Could not read stored authorities", t);
            }
        }
        return this.userDAO.findByUsername(jwtClaims.getSubject()).map(user -> new JWTSSOProvider.ResolvedClaims((User)user, authorities));
    }
}

