/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.clientapps;

import de.agilecoders.wicket.core.markup.html.bootstrap.dialog.Modal;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.SerializationUtils;
import org.apache.syncope.client.console.SyncopeConsoleSession;
import org.apache.syncope.client.console.audit.AuditHistoryModal;
import org.apache.syncope.client.console.clientapps.ClientAppPropertiesDirectoryPanel;
import org.apache.syncope.client.console.clientapps.UsernameAttributeProviderModalPanelBuilder;
import org.apache.syncope.client.console.commons.DirectoryDataProvider;
import org.apache.syncope.client.console.commons.SortableDataProviderComparator;
import org.apache.syncope.client.console.pages.BasePage;
import org.apache.syncope.client.console.panels.DirectoryPanel;
import org.apache.syncope.client.console.panels.ModalDirectoryPanel;
import org.apache.syncope.client.console.rest.AuditRestClient;
import org.apache.syncope.client.console.rest.ClientAppRestClient;
import org.apache.syncope.client.console.rest.PolicyRestClient;
import org.apache.syncope.client.console.rest.RealmRestClient;
import org.apache.syncope.client.console.wicket.extensions.markup.html.repeater.data.table.KeyPropertyColumn;
import org.apache.syncope.client.console.wicket.markup.html.bootstrap.dialog.BaseModal;
import org.apache.syncope.client.console.wicket.markup.html.form.ActionLink;
import org.apache.syncope.client.console.wicket.markup.html.form.ActionsPanel;
import org.apache.syncope.client.ui.commons.pages.BaseWebPage;
import org.apache.syncope.client.ui.commons.panels.ModalPanel;
import org.apache.syncope.client.ui.commons.rest.RestClient;
import org.apache.syncope.client.ui.commons.wizards.AjaxWizard;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.to.ClientAppTO;
import org.apache.syncope.common.lib.to.EntityTO;
import org.apache.syncope.common.lib.types.ClientAppType;
import org.apache.syncope.common.lib.types.OpEvent;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.event.Broadcast;
import org.apache.wicket.event.IEventSink;
import org.apache.wicket.extensions.markup.html.repeater.data.sort.SortOrder;
import org.apache.wicket.extensions.markup.html.repeater.data.table.IColumn;
import org.apache.wicket.extensions.markup.html.repeater.data.table.PropertyColumn;
import org.apache.wicket.extensions.markup.html.repeater.util.SortableDataProvider;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.StringResourceModel;
import org.apache.wicket.spring.injection.annot.SpringBean;

public abstract class ClientAppDirectoryPanel<T extends ClientAppTO>
extends DirectoryPanel<T, T, DirectoryDataProvider<T>, ClientAppRestClient> {
    private static final long serialVersionUID = 4100100988730985059L;
    @SpringBean
    protected PolicyRestClient policyRestClient;
    @SpringBean
    protected ClientAppRestClient clientAppRestClient;
    @SpringBean
    protected RealmRestClient realmRestClient;
    @SpringBean
    protected AuditRestClient auditRestClient;
    protected final ClientAppType type;
    protected final BaseModal<T> propertiesModal;
    protected final BaseModal<Serializable> historyModal;

    public ClientAppDirectoryPanel(String id, ClientAppRestClient restClient, ClientAppType type, PageReference pageRef) {
        super(id, (RestClient)restClient, pageRef, true);
        this.type = type;
        this.modal.addSubmitButton();
        this.modal.size(Modal.Size.Large);
        this.setWindowClosedReloadCallback(this.modal, true);
        this.setFooterVisibility(true);
        this.propertiesModal = new BaseModal<T>("outer"){
            private static final long serialVersionUID = 389935548143327858L;

            protected void onConfigure() {
                super.onConfigure();
                this.setFooterVisible(false);
            }
        };
        this.propertiesModal.size(Modal.Size.Large);
        this.setWindowClosedReloadCallback(this.propertiesModal);
        this.addOuterObject(new Component[]{this.propertiesModal});
        this.disableCheckBoxes();
        this.historyModal = new BaseModal("outer");
        this.historyModal.size(Modal.Size.Large);
        this.addOuterObject(new Component[]{this.historyModal});
    }

    protected List<IColumn<T, String>> getColumns() {
        ArrayList<IColumn<T, String>> columns = new ArrayList<IColumn<T, String>>();
        columns.add((IColumn<T, String>)new KeyPropertyColumn((IModel)new StringResourceModel("key", (Component)this), "key"));
        columns.add((IColumn<T, String>)new PropertyColumn((IModel)new StringResourceModel("name", (Component)this), (Object)"name", "name"));
        columns.add((IColumn<T, String>)new PropertyColumn((IModel)new StringResourceModel("clientAppId", (Component)this), (Object)"clientAppId", "clientAppId"));
        columns.add((IColumn<T, String>)new PropertyColumn((IModel)new StringResourceModel("evaluationOrder", (Component)this), (Object)"evaluationOrder", "evaluationOrder"));
        this.addCustomColumnFields(columns);
        return columns;
    }

    protected void addCustomColumnFields(List<IColumn<T, String>> columns) {
    }

    public ActionsPanel<T> getActions(final IModel<T> model) {
        ActionsPanel panel = super.getActions(model);
        panel.add(new ActionLink<T>(this){
            private static final long serialVersionUID = -3722207913631435501L;
            final /* synthetic */ ClientAppDirectoryPanel this$0;
            {
                this.this$0 = this$0;
            }

            public void onClick(AjaxRequestTarget target, ClientAppTO ignore) {
                this.this$0.send((IEventSink)this.this$0, Broadcast.EXACT, new AjaxWizard.EditItemActionEvent(((ClientAppRestClient)this.this$0.restClient).read(this.this$0.type, ((ClientAppTO)model.getObject()).getKey()), target));
            }
        }, ActionLink.ActionType.EDIT, "CLIENTAPP_CREATE");
        panel.add(new ActionLink<T>(this){
            private static final long serialVersionUID = -3722207913631435501L;
            final /* synthetic */ ClientAppDirectoryPanel this$0;
            {
                this.this$0 = this$0;
            }

            public void onClick(AjaxRequestTarget target, ClientAppTO ignore) {
                model.setObject(((ClientAppRestClient)this.this$0.restClient).read(this.this$0.type, ((ClientAppTO)model.getObject()).getKey()));
                this.this$0.modal.setContent(new UsernameAttributeProviderModalPanelBuilder<ClientAppTO>(this.this$0.type, (ClientAppTO)model.getObject(), this.this$0.modal, this.this$0.clientAppRestClient, this.this$0.pageRef).build(this.this$0.actualId, 1, AjaxWizard.Mode.EDIT));
                this.this$0.modal.header((IModel)new Model((Serializable)((Object)this.this$0.getString("usernameAttributeProviderConf.title", model))));
                this.this$0.modal.show(true);
                target.add(new Component[]{this.this$0.modal});
            }
        }, ActionLink.ActionType.COMPOSE, "CLIENTAPP_CREATE");
        panel.add(new ActionLink<T>(this){
            private static final long serialVersionUID = -3722207913631435501L;
            final /* synthetic */ ClientAppDirectoryPanel this$0;
            {
                this.this$0 = this$0;
            }

            public void onClick(AjaxRequestTarget target, ClientAppTO ignore) {
                model.setObject(((ClientAppRestClient)this.this$0.restClient).read(this.this$0.type, ((ClientAppTO)model.getObject()).getKey()));
                target.add(new Component[]{this.this$0.propertiesModal.setContent((ModalPanel)new ModalDirectoryPanel(this.this$0.propertiesModal, new ClientAppPropertiesDirectoryPanel("panel", (ClientAppRestClient)this.this$0.restClient, this.this$0.propertiesModal, this.this$0.type, model, this.this$0.pageRef), this.this$0.pageRef))});
                this.this$0.propertiesModal.header((IModel)new Model((Serializable)((Object)this.this$0.getString("properties.title", model))));
                this.this$0.propertiesModal.show(true);
            }
        }, ActionLink.ActionType.TYPE_EXTENSIONS, "CLIENTAPP_CREATE");
        panel.add(new ActionLink<T>(this){
            private static final long serialVersionUID = -5432034353017728756L;
            final /* synthetic */ ClientAppDirectoryPanel this$0;
            {
                this.this$0 = this$0;
            }

            public void onClick(AjaxRequestTarget target, ClientAppTO ignore) {
                model.setObject(((ClientAppRestClient)this.this$0.restClient).read(this.this$0.type, ((ClientAppTO)model.getObject()).getKey()));
                target.add(new Component[]{this.this$0.historyModal.setContent((ModalPanel)new AuditHistoryModal<T>(this, OpEvent.CategoryType.LOGIC, "ClientAppLogic", (ClientAppTO)model.getObject(), "CLIENTAPP_CREATE", this.this$0.auditRestClient){
                    private static final long serialVersionUID = -3712506022627033811L;
                    final /* synthetic */ 5 this$1;
                    {
                        this.this$1 = this$1;
                        super(type, category, (EntityTO)entity, auditRestoreEntitlement, restClient);
                    }

                    protected void restore(String json, AjaxRequestTarget target) {
                        try {
                            ClientAppTO updated = (ClientAppTO)MAPPER.readValue(json, ClientAppTO.class);
                            ((ClientAppRestClient)this.this$1.this$0.restClient).update(this.this$1.this$0.type, updated);
                            SyncopeConsoleSession.get().success((Serializable)((Object)this.getString("operation_succeeded")));
                        }
                        catch (Exception e) {
                            LOG.error("While restoring ClientApp {}", (Object)((ClientAppTO)model.getObject()).getKey(), (Object)e);
                            SyncopeConsoleSession.get().onException(e);
                        }
                        ((BasePage)this.this$1.this$0.pageRef.getPage()).getNotificationPanel().refresh((IPartialPageRequestHandler)target);
                    }
                })});
                this.this$0.historyModal.header((IModel)new Model((Serializable)((Object)this.this$0.getString("auditHistory.title", (IModel)new Model((Serializable)((ClientAppTO)model.getObject()))))));
                this.this$0.historyModal.show(true);
            }
        }, ActionLink.ActionType.VIEW_AUDIT_HISTORY, String.format("%s,%s", "CLIENTAPP_READ", "AUDIT_LIST"));
        panel.add(new ActionLink<T>(this){
            private static final long serialVersionUID = -3722207913631435501L;
            final /* synthetic */ ClientAppDirectoryPanel this$0;
            {
                this.this$0 = this$0;
            }

            public void onClick(AjaxRequestTarget target, ClientAppTO ignore) {
                ClientAppTO clone = (ClientAppTO)SerializationUtils.clone((Serializable)((ClientAppTO)model.getObject()));
                clone.setKey(null);
                clone.setClientAppId(null);
                this.this$0.send((IEventSink)this.this$0, Broadcast.EXACT, new AjaxWizard.EditItemActionEvent((Serializable)clone, target));
            }
        }, ActionLink.ActionType.CLONE, "CLIENTAPP_CREATE");
        panel.add(new ActionLink<T>(this){
            private static final long serialVersionUID = -3722207913631435501L;
            final /* synthetic */ ClientAppDirectoryPanel this$0;
            {
                this.this$0 = this$0;
            }

            public void onClick(AjaxRequestTarget target, ClientAppTO ignore) {
                ClientAppTO clientAppTO = (ClientAppTO)model.getObject();
                try {
                    ((ClientAppRestClient)this.this$0.restClient).delete(this.this$0.type, clientAppTO.getKey());
                    SyncopeConsoleSession.get().success((Serializable)((Object)this.this$0.getString("operation_succeeded")));
                    target.add(new Component[]{this.this$0.container});
                }
                catch (SyncopeClientException e) {
                    LOG.error("While deleting {}", (Object)clientAppTO.getKey(), (Object)e);
                    SyncopeConsoleSession.get().onException((Exception)((Object)e));
                }
                ((BaseWebPage)this.this$0.pageRef.getPage()).getNotificationPanel().refresh((IPartialPageRequestHandler)target);
            }
        }, ActionLink.ActionType.DELETE, "CLIENTAPP_DELETE", true);
        return panel;
    }

    protected Collection<ActionLink.ActionType> getBatches() {
        return List.of();
    }

    protected ClientAppDataProvider dataProvider() {
        return new ClientAppDataProvider(this.rows);
    }

    protected String paginatorRowsKey() {
        return "clientapp.paginator.rows";
    }

    protected class ClientAppDataProvider
    extends DirectoryDataProvider<T> {
        private static final long serialVersionUID = 4725679400450513556L;
        private final SortableDataProviderComparator<T> comparator;

        ClientAppDataProvider(int paginatorRows) {
            super(paginatorRows);
            this.setSort("name", SortOrder.ASCENDING);
            this.comparator = new SortableDataProviderComparator((SortableDataProvider)this);
        }

        public Iterator<T> iterator(long first, long count) {
            List list = ((ClientAppRestClient)ClientAppDirectoryPanel.this.restClient).list(ClientAppDirectoryPanel.this.type);
            list.sort(this.comparator);
            return list.subList((int)first, (int)first + (int)count).iterator();
        }

        public long size() {
            return ((ClientAppRestClient)ClientAppDirectoryPanel.this.restClient).list(ClientAppDirectoryPanel.this.type).size();
        }

        public IModel<T> model(T object) {
            return new CompoundPropertyModel(object);
        }
    }
}

