/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.dsl;

import java.util.Collections;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.reactivestreams.Publisher;
import org.springframework.aop.framework.Advised;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.integration.channel.DirectChannel;
import org.springframework.integration.channel.FluxMessageChannel;
import org.springframework.integration.channel.PublishSubscribeChannel;
import org.springframework.integration.config.ConsumerEndpointFactoryBean;
import org.springframework.integration.core.MessageSource;
import org.springframework.integration.dsl.ComponentsRegistration;
import org.springframework.integration.dsl.GatewayProxySpec;
import org.springframework.integration.dsl.IntegrationFlowBuilder;
import org.springframework.integration.dsl.IntegrationFlowDefinition;
import org.springframework.integration.dsl.MessageChannelSpec;
import org.springframework.integration.dsl.MessageProducerSpec;
import org.springframework.integration.dsl.MessageSourceSpec;
import org.springframework.integration.dsl.MessagingGatewaySpec;
import org.springframework.integration.dsl.SourcePollingChannelAdapterSpec;
import org.springframework.integration.dsl.support.FixedSubscriberChannelPrototype;
import org.springframework.integration.dsl.support.MessageChannelReference;
import org.springframework.integration.endpoint.AbstractMessageSource;
import org.springframework.integration.endpoint.MessageProducerSupport;
import org.springframework.integration.gateway.MessagingGatewaySupport;
import org.springframework.integration.handler.AbstractMessageProducingHandler;
import org.springframework.lang.Nullable;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.MessageHandler;
import org.springframework.util.Assert;

@FunctionalInterface
public interface IntegrationFlow {
    public void configure(IntegrationFlowDefinition<?> var1);

    @Nullable
    default public MessageChannel getInputChannel() {
        return null;
    }

    default public Map<Object, String> getIntegrationComponents() {
        return Collections.emptyMap();
    }

    public static IntegrationFlowBuilder from(String messageChannelName) {
        return IntegrationFlow.from(new MessageChannelReference(messageChannelName));
    }

    public static IntegrationFlowBuilder from(MessageChannelSpec<?, ?> messageChannelSpec) {
        Assert.notNull(messageChannelSpec, (String)"'messageChannelSpec' must not be null");
        return IntegrationFlow.from((MessageChannel)messageChannelSpec.getObject());
    }

    public static IntegrationFlowBuilder from(String messageChannelName, boolean fixedSubscriber) {
        return fixedSubscriber ? IntegrationFlow.from(new FixedSubscriberChannelPrototype(messageChannelName)) : IntegrationFlow.from(messageChannelName);
    }

    public static IntegrationFlowBuilder from(MessageChannel messageChannel) {
        return (IntegrationFlowBuilder)new IntegrationFlowBuilder().channel(messageChannel);
    }

    public static IntegrationFlowBuilder from(MessageSourceSpec<?, ? extends MessageSource<?>> messageSourceSpec) {
        return IntegrationFlow.from(messageSourceSpec, null);
    }

    public static IntegrationFlowBuilder from(MessageSourceSpec<?, ? extends MessageSource<?>> messageSourceSpec, @Nullable Consumer<SourcePollingChannelAdapterSpec> endpointConfigurer) {
        Assert.notNull(messageSourceSpec, (String)"'messageSourceSpec' must not be null");
        return IntegrationFlow.from((MessageSource)messageSourceSpec.getObject(), endpointConfigurer, IntegrationFlow.registerComponents(messageSourceSpec));
    }

    public static <T> IntegrationFlowBuilder fromSupplier(Supplier<T> messageSource) {
        return IntegrationFlow.fromSupplier(messageSource, null);
    }

    public static <T> IntegrationFlowBuilder fromSupplier(final Supplier<T> messageSource, @Nullable Consumer<SourcePollingChannelAdapterSpec> endpointConfigurer) {
        Assert.notNull(messageSource, (String)"'messageSource' must not be null");
        return IntegrationFlow.from(new AbstractMessageSource<Object>(){

            @Override
            protected Object doReceive() {
                return messageSource.get();
            }

            @Override
            public String getComponentType() {
                return "inbound-channel-adapter";
            }
        }, endpointConfigurer);
    }

    public static IntegrationFlowBuilder from(MessageSource<?> messageSource) {
        return IntegrationFlow.from(messageSource, null);
    }

    public static IntegrationFlowBuilder from(MessageSource<?> messageSource, @Nullable Consumer<SourcePollingChannelAdapterSpec> endpointConfigurer) {
        return IntegrationFlow.from(messageSource, endpointConfigurer, null);
    }

    private static IntegrationFlowBuilder from(MessageSource<?> messageSource, @Nullable Consumer<SourcePollingChannelAdapterSpec> endpointConfigurer, @Nullable IntegrationFlowBuilder integrationFlowBuilderArg) {
        IntegrationFlowBuilder integrationFlowBuilder = integrationFlowBuilderArg;
        SourcePollingChannelAdapterSpec spec = new SourcePollingChannelAdapterSpec(messageSource);
        if (endpointConfigurer != null) {
            endpointConfigurer.accept(spec);
        }
        if (integrationFlowBuilder == null) {
            integrationFlowBuilder = new IntegrationFlowBuilder();
        }
        return (IntegrationFlowBuilder)((IntegrationFlowBuilder)integrationFlowBuilder.addComponent(spec)).currentComponent(spec);
    }

    public static IntegrationFlowBuilder from(MessageProducerSpec<?, ?> messageProducerSpec) {
        return IntegrationFlow.from((MessageProducerSupport)messageProducerSpec.getObject(), IntegrationFlow.registerComponents(messageProducerSpec));
    }

    public static IntegrationFlowBuilder from(MessageProducerSupport messageProducer) {
        return IntegrationFlow.from(messageProducer, null);
    }

    private static IntegrationFlowBuilder from(MessageProducerSupport messageProducer, @Nullable IntegrationFlowBuilder integrationFlowBuilderArg) {
        IntegrationFlowBuilder integrationFlowBuilder = integrationFlowBuilderArg;
        MessageChannel outputChannel = messageProducer.getOutputChannel();
        if (outputChannel == null) {
            outputChannel = new DirectChannel();
            messageProducer.setOutputChannel(outputChannel);
        }
        if (integrationFlowBuilder == null) {
            integrationFlowBuilder = IntegrationFlow.from(outputChannel);
        } else {
            integrationFlowBuilder.channel(outputChannel);
        }
        return (IntegrationFlowBuilder)integrationFlowBuilder.addComponent(messageProducer);
    }

    public static IntegrationFlowBuilder from(MessagingGatewaySpec<?, ?> inboundGatewaySpec) {
        return IntegrationFlow.from((MessagingGatewaySupport)inboundGatewaySpec.getObject(), IntegrationFlow.registerComponents(inboundGatewaySpec));
    }

    public static IntegrationFlowBuilder from(MessagingGatewaySupport inboundGateway) {
        return IntegrationFlow.from(inboundGateway, null);
    }

    public static IntegrationFlowBuilder from(Class<?> serviceInterface) {
        return IntegrationFlow.from(serviceInterface, null);
    }

    public static IntegrationFlowBuilder from(Class<?> serviceInterface, @Nullable Consumer<GatewayProxySpec> endpointConfigurer) {
        GatewayProxySpec gatewayProxySpec = new GatewayProxySpec(serviceInterface);
        if (endpointConfigurer != null) {
            endpointConfigurer.accept(gatewayProxySpec);
        }
        return (IntegrationFlowBuilder)IntegrationFlow.from(gatewayProxySpec.getGatewayRequestChannel()).addComponent(gatewayProxySpec.getGatewayProxyFactoryBean());
    }

    public static IntegrationFlowBuilder from(Publisher<? extends Message<?>> publisher) {
        FluxMessageChannel reactiveChannel = new FluxMessageChannel();
        reactiveChannel.subscribeTo(publisher);
        return IntegrationFlow.from(reactiveChannel);
    }

    public static IntegrationFlowBuilder from(IntegrationFlow other) {
        Map<Object, String> integrationComponents = other.getIntegrationComponents();
        Assert.notEmpty(integrationComponents, () -> "The provided integration flow to compose from '" + String.valueOf(other) + "' must be declared as a bean in the application context");
        MessageHandler lastIntegrationComponentFromOther = integrationComponents.keySet().stream().reduce((prev, next) -> next).orElse(null);
        if (lastIntegrationComponentFromOther instanceof MessageChannel) {
            MessageChannel messageChannel = (MessageChannel)lastIntegrationComponentFromOther;
            return IntegrationFlow.from(messageChannel);
        }
        if (lastIntegrationComponentFromOther instanceof ConsumerEndpointFactoryBean) {
            ConsumerEndpointFactoryBean factoryBean = (ConsumerEndpointFactoryBean)lastIntegrationComponentFromOther;
            MessageHandler handler = factoryBean.getHandler();
            if ((handler = IntegrationFlow.extractProxyTarget(handler)) instanceof AbstractMessageProducingHandler) {
                AbstractMessageProducingHandler producingHandler = (AbstractMessageProducingHandler)handler;
                return IntegrationFlow.buildFlowFromOutputChannel(producingHandler);
            }
            lastIntegrationComponentFromOther = handler;
        }
        throw new BeanCreationException("The 'IntegrationFlow' to start from must end with a 'MessageChannel' or reply-producing endpoint to let the result from that flow to be processed in this instance. The provided flow ends with: " + String.valueOf(lastIntegrationComponentFromOther));
    }

    private static IntegrationFlowBuilder buildFlowFromOutputChannel(AbstractMessageProducingHandler handler) {
        MessageChannel outputChannel = handler.getOutputChannel();
        if (outputChannel == null) {
            outputChannel = new PublishSubscribeChannel();
            handler.setOutputChannel(outputChannel);
        }
        return IntegrationFlow.from(outputChannel);
    }

    private static IntegrationFlowBuilder from(MessagingGatewaySupport inboundGateway, @Nullable IntegrationFlowBuilder integrationFlowBuilderArg) {
        IntegrationFlowBuilder integrationFlowBuilder = integrationFlowBuilderArg;
        MessageChannel outputChannel = inboundGateway.getRequestChannel();
        if (outputChannel == null) {
            outputChannel = new DirectChannel();
            inboundGateway.setRequestChannel(outputChannel);
        }
        if (integrationFlowBuilder == null) {
            integrationFlowBuilder = IntegrationFlow.from(outputChannel);
        } else {
            integrationFlowBuilder.channel(outputChannel);
        }
        return (IntegrationFlowBuilder)integrationFlowBuilder.addComponent(inboundGateway);
    }

    @Nullable
    private static IntegrationFlowBuilder registerComponents(Object spec) {
        if (spec instanceof ComponentsRegistration) {
            ComponentsRegistration componentsRegistration = (ComponentsRegistration)spec;
            return (IntegrationFlowBuilder)new IntegrationFlowBuilder().addComponents(componentsRegistration.getComponentsToRegister());
        }
        return null;
    }

    @Nullable
    private static <T> T extractProxyTarget(@Nullable T target) {
        if (!(target instanceof Advised)) {
            return target;
        }
        Advised advised = (Advised)target;
        try {
            return (T)IntegrationFlow.extractProxyTarget(advised.getTargetSource().getTarget());
        }
        catch (Exception e) {
            throw new BeanCreationException("Could not extract target", (Throwable)e);
        }
    }
}

