/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.ext;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import org.ldaptive.AttributeModification;
import org.ldaptive.LdapAttribute;
import org.ldaptive.LdapEntry;

public class MergeRequest {
    private LdapEntry ldapEntry;
    private boolean deleteEntry;
    private String[] searchAttrs;
    private String[] includeAttrs;
    private String[] excludeAttrs;
    private boolean useReplace = true;
    private AttributeModificationsHandler[] attributeModificationsHandlers;

    public MergeRequest() {
    }

    public MergeRequest(LdapEntry entry) {
        this.setEntry(entry);
    }

    public MergeRequest(LdapEntry entry, boolean delete) {
        this.setEntry(entry);
        this.setDeleteEntry(delete);
    }

    public LdapEntry getEntry() {
        return this.ldapEntry;
    }

    public void setEntry(LdapEntry entry) {
        this.ldapEntry = entry;
    }

    public boolean getDeleteEntry() {
        return this.deleteEntry;
    }

    public void setDeleteEntry(boolean b) {
        this.deleteEntry = b;
    }

    public String[] getSearchAttributes() {
        return this.searchAttrs;
    }

    public void setSearchAttributes(String ... attrs) {
        this.searchAttrs = attrs;
    }

    public String[] getIncludeAttributes() {
        return this.includeAttrs;
    }

    public void setIncludeAttributes(String ... attrs) {
        this.includeAttrs = attrs;
    }

    public String[] getExcludeAttributes() {
        return this.excludeAttrs;
    }

    public void setExcludeAttributes(String ... attrs) {
        this.excludeAttrs = attrs;
    }

    public boolean isUseReplace() {
        return this.useReplace;
    }

    public void setUseReplace(boolean replace) {
        this.useReplace = replace;
    }

    public AttributeModificationsHandler[] getAttributeModificationsHandlers() {
        return this.attributeModificationsHandlers;
    }

    public void setAttributeModificationsHandlers(AttributeModificationsHandler ... handlers) {
        this.attributeModificationsHandlers = handlers;
    }

    public String toString() {
        return "[" + this.getClass().getName() + "@" + this.hashCode() + "::ldapEntry=" + String.valueOf(this.ldapEntry) + ", deleteEntry=" + this.deleteEntry + ", searchAttributes=" + Arrays.toString(this.searchAttrs) + ", includeAttributes=" + Arrays.toString(this.includeAttrs) + ", excludeAttributes=" + Arrays.toString(this.excludeAttrs) + ", useReplace=" + this.useReplace + ", attributeModificationProcessor=" + Arrays.toString(this.attributeModificationsHandlers) + "]";
    }

    private static <T> void divideList(List<T> list, int divisor, Consumer<List<T>> consumer) {
        for (int i = 0; i < list.size() / divisor; ++i) {
            int start = i * divisor;
            int end = (i + 1) * divisor;
            consumer.accept(list.subList(start, end > list.size() ? list.size() : end));
        }
    }

    public static class BatchHandler
    implements AttributeModificationsHandler {
        private final int batchSize;

        public BatchHandler(int size) {
            this.batchSize = size;
        }

        @Override
        public List<List<AttributeModification>> apply(List<List<AttributeModification>> modifications) {
            ArrayList<List<AttributeModification>> batchModifications = new ArrayList<List<AttributeModification>>(modifications.size());
            for (List<AttributeModification> mods : modifications) {
                if (mods.size() > this.batchSize) {
                    MergeRequest.divideList(mods, this.batchSize, batchModifications::add);
                    continue;
                }
                batchModifications.add(mods);
            }
            return batchModifications;
        }
    }

    public static class MaxSizeAttributeValueHandler
    implements AttributeModificationsHandler {
        private final int maxSize;

        public MaxSizeAttributeValueHandler(int size) {
            this.maxSize = size;
        }

        @Override
        public List<List<AttributeModification>> apply(List<List<AttributeModification>> modifications) {
            ArrayList<List<AttributeModification>> attrValuesModifications = new ArrayList<List<AttributeModification>>(new ArrayList());
            for (List<AttributeModification> mods : modifications) {
                ArrayList<AttributeModification> attrMods = new ArrayList<AttributeModification>(mods.size());
                for (AttributeModification am : mods) {
                    if (am.getAttribute().size() > this.maxSize) {
                        MergeRequest.divideList(new ArrayList<byte[]>(am.getAttribute().getBinaryValues()), this.maxSize, values -> attrMods.add(new AttributeModification(am.getOperation(), LdapAttribute.builder().name(am.getAttribute().getName()).binaryValues((Collection<byte[]>)values).build())));
                        continue;
                    }
                    attrMods.add(am);
                }
                attrValuesModifications.add(attrMods);
            }
            return attrValuesModifications;
        }
    }

    public static interface AttributeModificationsHandler
    extends Function<List<List<AttributeModification>>, List<List<AttributeModification>>> {
    }
}

