/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Collections;
import java.util.Properties;
import java.util.concurrent.Future;
import kafka.log.LogManager;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig$;
import kafka.server.QuorumTestHarness;
import kafka.server.QuotaType;
import kafka.utils.CoreUtils$;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.message.BrokerRegistrationRequestData;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.kafka.controller.ControllerRequestContextUtil;
import org.apache.kafka.server.common.Features;
import org.apache.kafka.server.common.KRaftVersion;
import org.apache.kafka.server.common.MetadataVersion;
import org.apache.kafka.server.common.TransactionVersion;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.math.Numeric;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Using;
import scala.util.Using$;

@ScalaSignature(bytes="\u0006\u0005\u0005]g\u0001B\u000e\u001d\u0001\u0005BQA\n\u0001\u0005\u0002\u001dBq!\u000b\u0001C\u0002\u0013\u0005!\u0006\u0003\u00045\u0001\u0001\u0006Ia\u000b\u0005\bk\u0001\u0011\r\u0011\"\u00017\u0011\u0019!\u0005\u0001)A\u0005o!IQ\t\u0001a\u0001\u0002\u0004%\tA\u0012\u0005\n-\u0002\u0001\r\u00111A\u0005\u0002]C\u0011\"\u0018\u0001A\u0002\u0003\u0005\u000b\u0015B$\t\u000fy\u0003!\u0019!C\u0001?\"1\u0001\u000e\u0001Q\u0001\n\u0001D\u0011\"\u001b\u0001A\u0002\u0003\u0007I\u0011\u00016\t\u0013I\u0004\u0001\u0019!a\u0001\n\u0003\u0019\b\"C;\u0001\u0001\u0004\u0005\t\u0015)\u0003l\u0011\u00151\b\u0001\"\u0011x\u0011\u001d\t9\u0001\u0001C\u0001\u0003\u0013Aq!!\u0012\u0001\t\u0003\t9\u0005C\u0004\u0002R\u0001!\t!a\u0015\t\u000f\u0005}\u0003\u0001\"\u0001\u0002b!9\u0011Q\u000f\u0001\u0005\u0002\u0005]\u0004bBAA\u0001\u0011\u0005\u00111\u0011\u0005\b\u0003\u001b\u0003A\u0011BAH\u0011\u001d\ti\n\u0001C\u0005\u0003?Cq!!*\u0001\t\u0003\t9\u000bC\u0004\u00020\u0002!I!!-\t\u000f\u0005\u0015\u0007\u0001\"\u0003\u0002H\"9\u0011\u0011\u001b\u0001\u0005\n\u0005M'!\u0006*fa2L7-\u0019;j_:\fVo\u001c;bgR+7\u000f\u001e\u0006\u0003;y\taa]3sm\u0016\u0014(\"A\u0010\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001A\t\t\u0003G\u0011j\u0011\u0001H\u0005\u0003Kq\u0011\u0011#U;peVlG+Z:u\u0011\u0006\u0014h.Z:t\u0003\u0019a\u0014N\\5u}Q\t\u0001\u0006\u0005\u0002$\u0001\u0005AQn]42aAZ%)F\u0001,!\ras&M\u0007\u0002[)\ta&A\u0003tG\u0006d\u0017-\u0003\u00021[\t)\u0011I\u001d:bsB\u0011AFM\u0005\u0003g5\u0012AAQ=uK\u0006IQn]42aAZ%\tI\u0001\rY&\u001cH/\u001a8fe:\u000bW.Z\u000b\u0002oA\u0011\u0001HQ\u0007\u0002s)\u0011!hO\u0001\b]\u0016$xo\u001c:l\u0015\taT(\u0001\u0004d_6lwN\u001c\u0006\u0003?yR!a\u0010!\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\t\u0015aA8sO&\u00111)\u000f\u0002\r\u0019&\u001cH/\u001a8fe:\u000bW.Z\u0001\u000eY&\u001cH/\u001a8fe:\u000bW.\u001a\u0011\u0002\u000f\t\u0014xn[3sgV\tq\tE\u0002I!Ns!!\u0013(\u000f\u0005)kU\"A&\u000b\u00051\u0003\u0013A\u0002\u001fs_>$h(C\u0001/\u0013\tyU&A\u0004qC\u000e\\\u0017mZ3\n\u0005E\u0013&aA*fc*\u0011q*\f\t\u0003GQK!!\u0016\u000f\u0003\u0017-\u000bgm[1Ce>\\WM]\u0001\fEJ|7.\u001a:t?\u0012*\u0017\u000f\u0006\u0002Y7B\u0011A&W\u0005\u000356\u0012A!\u00168ji\"9AlBA\u0001\u0002\u00049\u0015a\u0001=%c\u0005A!M]8lKJ\u001c\b%A\u0003u_BL7-F\u0001a!\t\tg-D\u0001c\u0015\t\u0019G-\u0001\u0003mC:<'\"A3\u0002\t)\fg/Y\u0005\u0003O\n\u0014aa\u0015;sS:<\u0017A\u0002;pa&\u001c\u0007%\u0001\u0005qe>$WoY3s+\u0005Y\u0007\u0003\u00027qW-j\u0011!\u001c\u0006\u0003S:T!a\\\u001f\u0002\u000f\rd\u0017.\u001a8ug&\u0011\u0011/\u001c\u0002\u000e\u0017\u000647.\u0019)s_\u0012,8-\u001a:\u0002\u0019A\u0014x\u000eZ;dKJ|F%Z9\u0015\u0005a#\bb\u0002/\r\u0003\u0003\u0005\ra[\u0001\naJ|G-^2fe\u0002\n\u0001\u0002^3be\u0012{wO\u001c\u000b\u00021\"\u0012a\"\u001f\t\u0004u\u0006\rQ\"A>\u000b\u0005ql\u0018aA1qS*\u0011ap`\u0001\bUV\u0004\u0018\u000e^3s\u0015\r\t\t\u0001Q\u0001\u0006UVt\u0017\u000e^\u0005\u0004\u0003\u000bY(!C!gi\u0016\u0014X)Y2i\u0003-\u001a\bn\\;mI\n{w\u000e^:ue\u0006\u0004Hk^8Ce>\\WM]:XSRDG*Z1eKJ$\u0006N]8ui2,Gc\u0001-\u0002\f!9\u0011QB\bA\u0002\u0005=\u0011AB9v_J,X\u000e\u0005\u0003\u0002\u0012\u0005ea\u0002BA\n\u0003+\u0001\"AS\u0017\n\u0007\u0005]Q&\u0001\u0004Qe\u0016$WMZ\u0005\u0004O\u0006m!bAA\f[!\u001aq\"a\b\u0011\t\u0005\u0005\u0012qE\u0007\u0003\u0003GQ1!!\n~\u0003\u0019\u0001\u0018M]1ng&!\u0011\u0011FA\u0012\u0005E\u0001\u0016M]1nKR,'/\u001b>fIR+7\u000f\u001e\u0015\b\u001f\u00055\u0012\u0011HA\u001e!\u0011\ty#!\u000e\u000e\u0005\u0005E\"\u0002BA\u001a\u0003G\t\u0001\u0002\u001d:pm&$WM]\u0005\u0005\u0003o\t\tDA\u0006WC2,XmU8ve\u000e,\u0017aB:ue&twm\u001d\u0017\u0005\u0003{\t\t%\t\u0002\u0002@\u0005\u0011!p[\u0011\u0003\u0003\u0007\nQa\u001b:bMR\fQf\u001d5pk2$'i\\8ugR\u0014\u0018\r\u001d+x_\n\u0013xn[3sg^KG\u000f\u001b$pY2|w/\u001a:UQJ|G\u000f\u001e7f)\rA\u0016\u0011\n\u0005\b\u0003\u001b\u0001\u0002\u0019AA\bQ\r\u0001\u0012q\u0004\u0015\b!\u00055\u0012\u0011HA(Y\u0011\ti$!\u0011\u0002mMDw.\u001e7e\u001b\u0006$8\r[)v_R\f'+\u001a9mS\u000e\fG/\u001b8h)\"\u0014x.^4i\u0003:\f5/_7nKR\u0014\u0018n\u0019+pa>dwnZ=\u0015\u0007a\u000b)\u0006C\u0004\u0002XE\u0001\r!!\u0017\u0002\u001d1,\u0017\rZ3s)\"\u0014x\u000e\u001e;mKB\u0019A&a\u0017\n\u0007\u0005uSFA\u0004C_>dW-\u00198\u0002\u0005Q\u0004H\u0003BA2\u0003W\u0002B!!\u001a\u0002h5\t1(C\u0002\u0002jm\u0012a\u0002V8qS\u000e\u0004\u0016M\u001d;ji&|g\u000eC\u0004\u0002nI\u0001\r!a\u001c\u0002\u0013A\f'\u000f^5uS>t\u0007c\u0001\u0017\u0002r%\u0019\u00111O\u0017\u0003\u0007%sG/A\rtQ>,H\u000e\u001a+ie>$H\u000f\\3PY\u0012\u001cVmZ7f]R\u001cHc\u0001-\u0002z!9\u0011QB\nA\u0002\u0005=\u0001fA\n\u0002 !:1#!\f\u0002:\u0005}D\u0006BA\u001f\u0003\u0003\nq!\u00193e\t\u0006$\u0018\rF\u0003Y\u0003\u000b\u000bI\tC\u0004\u0002\bR\u0001\r!a\u001c\u0002\u00115\u001cxmQ8v]RDa!a#\u0015\u0001\u0004Y\u0013aA7tO\u0006)r/Y5u\r>\u0014xJ\u001a4tKR\u001cHk\\'bi\u000eDGc\u0002-\u0002\u0012\u0006U\u0015\u0011\u0014\u0005\b\u0003'+\u0002\u0019AA8\u0003\u0019ygMZ:fi\"9\u0011qS\u000bA\u0002\u0005=\u0014a\u00039beRLG/[8o\u0013\u0012Dq!a'\u0016\u0001\u0004\ty'\u0001\u0005ce>\\WM]%e\u0003%\u0011'o\\6fe\u001a{'\u000fF\u0002T\u0003CCq!a)\u0017\u0001\u0004\ty'\u0001\u0002jI\u0006i1M]3bi\u0016\u0014%o\\6feN$2\u0001WAU\u0011\u001d\tYk\u0006a\u0001\u0003[\u000b\u0011B\u0019:pW\u0016\u0014\u0018\nZ:\u0011\t!\u0003\u0016qN\u0001\u0007CZ\u0014\u0016\r^3\u0015\r\u0005M\u0016\u0011XAb!\ra\u0013QW\u0005\u0004\u0003ok#A\u0002#pk\ndW\rC\u0004\u0002<b\u0001\r!!0\u0002\u001fI,\u0007\u000f\\5dCRLwN\u001c+za\u0016\u00042aIA`\u0013\r\t\t\r\b\u0002\n#V|G/\u0019+za\u0016Da!\u0012\rA\u0002\u00055\u0016\u0001D7fCN,(/\u001a3SCR,GCBAZ\u0003\u0013\fi\r\u0003\u0004\u0002Lf\u0001\raU\u0001\u0007EJ|7.\u001a:\t\u000f\u0005=\u0017\u00041\u0001\u0002>\u00069!/\u001a9UsB,\u0017A\u0004:fO&\u001cH/\u001a:Ce>\\WM\u001d\u000b\u00041\u0006U\u0007bBAR5\u0001\u0007\u0011q\u000e")
public class ReplicationQuotasTest
extends QuorumTestHarness {
    private final byte[] msg100KB = new byte[100000];
    private final ListenerName listenerName = ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT);
    private scala.collection.immutable.Seq<KafkaBroker> brokers;
    private final String topic;
    private KafkaProducer<byte[], byte[]> producer;

    public byte[] msg100KB() {
        return this.msg100KB;
    }

    public ListenerName listenerName() {
        return this.listenerName;
    }

    public scala.collection.immutable.Seq<KafkaBroker> brokers() {
        return this.brokers;
    }

    public void brokers_$eq(scala.collection.immutable.Seq<KafkaBroker> x$1) {
        this.brokers = x$1;
    }

    public String topic() {
        return this.topic;
    }

    public KafkaProducer<byte[], byte[]> producer() {
        return this.producer;
    }

    public void producer_$eq(KafkaProducer<byte[], byte[]> x$1) {
        this.producer = x$1;
    }

    @Override
    @AfterEach
    public void tearDown() {
        this.producer().close();
        TestUtils$.MODULE$.shutdownServers(this.brokers(), true);
        super.tearDown();
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void shouldBootstrapTwoBrokersWithLeaderThrottle(String quorum) {
        this.shouldMatchQuotaReplicatingThroughAnAsymmetricTopology(true);
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void shouldBootstrapTwoBrokersWithFollowerThrottle(String quorum) {
        this.shouldMatchQuotaReplicatingThroughAnAsymmetricTopology(false);
    }

    public void shouldMatchQuotaReplicatingThroughAnAsymmetricTopology(boolean leaderThrottle) {
        this.brokers_$eq((scala.collection.immutable.Seq<KafkaBroker>)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(100), 105).map((Function1 & Serializable)id -> this.createBroker(KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(BoxesRunTime.unboxToInt((Object)id), this.zkConnectOrNull(), true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false)), this.createBroker$default$2(), this.createBroker$default$3(), this.createBroker$default$4())));
        scala.collection.immutable.Map assignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{100, 106}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{101, 106}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{102, 106}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)3)), (Object)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{103, 107}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)4)), (Object)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{104, 107}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)5)), (Object)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{105, 107}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)6)), (Object)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{100, 106}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)7)), (Object)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{101, 107})))}));
        byte[] msg = this.msg100KB();
        int msgCount = 100;
        int expectedDuration = 10;
        LongRef throttle = LongRef.create((long)(msgCount * msg.length / expectedDuration));
        if (!leaderThrottle) {
            throttle.elem *= 3L;
        }
        Using$.MODULE$.resource((Object)TestUtils$.MODULE$.createAdminClient(this.brokers(), this.listenerName(), new Properties()), (Function1 & Serializable)admin -> {
            if (this.isKRaftTest()) {
                RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(106), 107).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)id -> this.registerBroker(id));
            }
            admin.createTopics((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new NewTopic(this.topic(), CollectionConverters$.MODULE$.MapHasAsJava((Map)assignment.map((Function1 & Serializable)a -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)a._1$mcI$sp())), (Object)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)((IterableOnceOps)((IterableOps)a._2()).map((Function1 & Serializable)x$3 -> ReplicationQuotasTest.$anonfun$shouldMatchQuotaReplicatingThroughAnAsymmetricTopology$5(BoxesRunTime.unboxToInt((Object)x$3)))).toList()).asJava()))).asJava()), (List)Nil$.MODULE$)).asJava()).all().get();
            RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(100), 107).foreach((Function1 & Serializable)brokerId -> ReplicationQuotasTest.$anonfun$shouldMatchQuotaReplicatingThroughAnAsymmetricTopology$6(this, throttle, BoxesRunTime.unboxToInt((Object)brokerId)));
            ConfigEntry configEntry = leaderThrottle ? new ConfigEntry("leader.replication.throttled.replicas", "0:100,1:101,2:102,3:103,4:104,5:105") : new ConfigEntry("follower.replication.throttled.replicas", "0:106,1:106,2:106,3:107,4:107,5:107");
            return (Void)admin.incrementalAlterConfigs(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new ConfigResource(ConfigResource.Type.TOPIC, this.topic())), (Object)CollectionConverters$.MODULE$.IterableHasAsJava((Iterable)new .colon.colon((Object)new AlterConfigOp(configEntry, AlterConfigOp.OpType.SET), (List)Nil$.MODULE$)).asJavaCollection())}))).asJava()).all().get();
        }, (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
        this.producer_$eq(TestUtils$.MODULE$.createProducer(TestUtils$.MODULE$.plaintextBootstrapServers(this.brokers()), 1, 60000L, 0x100000L, Integer.MAX_VALUE, 30000, 0, 16384, "none", 20000, SecurityProtocol.PLAINTEXT, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, new ByteArraySerializer(), new ByteArraySerializer(), false));
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), msgCount).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$4 -> RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 7).foreach((Function1 & Serializable)partition -> ReplicationQuotasTest.$anonfun$shouldMatchQuotaReplicatingThroughAnAsymmetricTopology$8(this, msg, BoxesRunTime.unboxToInt((Object)partition))));
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 5).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)id -> this.waitForOffsetsToMatch(msgCount, id, 100 + id));
        this.waitForOffsetsToMatch(msgCount, 6, 100);
        this.waitForOffsetsToMatch(msgCount, 7, 101);
        long start = System.currentTimeMillis();
        this.createBrokers((scala.collection.immutable.Seq<Object>)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(106), 107));
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(106), 107).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)brokerId -> Assertions.assertEquals((long)throttle$1.elem, (long)this.brokerFor(brokerId).quotaManagers().follower().upperBound()));
        if (!leaderThrottle) {
            RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 2).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)partition -> Assertions.assertTrue((boolean)this.brokerFor(106).quotaManagers().follower().isThrottled(this.tp(partition))));
            RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(3), 5).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)partition -> Assertions.assertTrue((boolean)this.brokerFor(107).quotaManagers().follower().isThrottled(this.tp(partition))));
        }
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(6), 7).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)id -> this.waitForOffsetsToMatch(msgCount, id, 100 + id));
        long unthrottledTook = System.currentTimeMillis() - start;
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 2).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)id -> this.waitForOffsetsToMatch(msgCount, id, 106));
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(3), 5).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)id -> this.waitForOffsetsToMatch(msgCount, id, 107));
        long throttledTook = System.currentTimeMillis() - start;
        double throttledLowerBound = (double)(expectedDuration * 1000) * 0.9;
        int throttledUpperBound = expectedDuration * 1000 * 3;
        Assertions.assertTrue(((double)unthrottledTook < throttledLowerBound ? 1 : 0) != 0, (String)new StringBuilder(12).append("Expected ").append(unthrottledTook).append(" < ").append(throttledLowerBound).toString());
        Assertions.assertTrue(((double)throttledTook > throttledLowerBound ? 1 : 0) != 0, (String)new StringBuilder(12).append("Expected ").append(throttledTook).append(" > ").append(throttledLowerBound).toString());
        Assertions.assertTrue((throttledTook < (long)throttledUpperBound ? 1 : 0) != 0, (String)new StringBuilder(12).append("Expected ").append(throttledTook).append(" < ").append(throttledUpperBound).toString());
        double rateUpperBound = (double)throttle.elem * 1.1;
        double rateLowerBound = (double)throttle.elem * 0.5;
        double rate = leaderThrottle ? this.avRate((QuotaType)QuotaType.LeaderReplication$.MODULE$, (scala.collection.immutable.Seq<Object>)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(100), 105)) : this.avRate((QuotaType)QuotaType.FollowerReplication$.MODULE$, (scala.collection.immutable.Seq<Object>)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(106), 107));
        Assertions.assertTrue((rate < rateUpperBound ? 1 : 0) != 0, (String)new StringBuilder(12).append("Expected ").append(rate).append(" < ").append(rateUpperBound).toString());
        Assertions.assertTrue((rate > rateLowerBound ? 1 : 0) != 0, (String)new StringBuilder(12).append("Expected ").append(rate).append(" > ").append(rateLowerBound).toString());
    }

    public TopicPartition tp(int partition) {
        return new TopicPartition(this.topic(), partition);
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void shouldThrottleOldSegments(String quorum) {
        Properties config = TestUtils$.MODULE$.createBrokerConfig(100, this.zkConnectOrNull(), true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false);
        config.put("log.segment.bytes", Integer.toString(0x100000));
        this.brokers_$eq((scala.collection.immutable.Seq<KafkaBroker>)new .colon.colon((Object)this.createBroker(KafkaConfig$.MODULE$.fromProps(config), this.createBroker$default$2(), this.createBroker$default$3(), this.createBroker$default$4()), (List)Nil$.MODULE$));
        byte[] msg = this.msg100KB();
        int msgCount = 200;
        int expectedDuration = 4;
        long throttle = msg.length * msgCount / expectedDuration;
        Using$.MODULE$.resource((Object)TestUtils$.MODULE$.createAdminClient(this.brokers(), this.listenerName(), new Properties()), (Function1 & Serializable)admin -> {
            if (this.isKRaftTest()) {
                this.registerBroker(101);
            }
            admin.createTopics((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new NewTopic(this.topic(), Collections.singletonMap(Predef$.MODULE$.int2Integer(0), CollectionConverters$.MODULE$.SeqHasAsJava((Seq)((List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{100, 101}))).map((Function1 & Serializable)x$5 -> ReplicationQuotasTest.$anonfun$shouldThrottleOldSegments$2(BoxesRunTime.unboxToInt((Object)x$5)))).asJava())), (List)Nil$.MODULE$)).asJava()).all().get();
            java.util.Map configs = CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new ConfigResource(ConfigResource.Type.BROKER, "100")), (Object)CollectionConverters$.MODULE$.IterableHasAsJava((Iterable)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry("leader.replication.throttled.rate", Long.toString(throttle)), AlterConfigOp.OpType.SET), (List)Nil$.MODULE$)).asJavaCollection()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new ConfigResource(ConfigResource.Type.TOPIC, this.topic())), (Object)CollectionConverters$.MODULE$.IterableHasAsJava((Iterable)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry("leader.replication.throttled.replicas", "0:100"), AlterConfigOp.OpType.SET), (List)Nil$.MODULE$)).asJavaCollection())}))).asJava();
            return (Void)admin.incrementalAlterConfigs(configs).all().get();
        }, (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
        this.addData(msgCount, msg);
        this.debug((Function0<String>)(Function0 & Serializable)() -> "Starting new broker");
        this.brokers_$eq((scala.collection.immutable.Seq<KafkaBroker>)((scala.collection.immutable.Seq)this.brokers().$colon$plus((Object)this.createBroker(KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(101, this.zkConnectOrNull(), true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false)), this.createBroker$default$2(), this.createBroker$default$3(), this.createBroker$default$4()))));
        long start = System.currentTimeMillis();
        this.waitForOffsetsToMatch(msgCount, 0, 101);
        long throttledTook = System.currentTimeMillis() - start;
        Assertions.assertTrue(((double)throttledTook > (double)(expectedDuration * 1000) * 0.9 ? 1 : 0) != 0, (String)new StringBuilder(42).append("Throttled replication of ").append(throttledTook).append("ms should be > ").append((double)(expectedDuration * 1000) * 0.9).append("ms").toString());
        Assertions.assertTrue(((double)throttledTook < (double)(expectedDuration * 1000) * 1.5 ? 1 : 0) != 0, (String)new StringBuilder(42).append("Throttled replication of ").append(throttledTook).append("ms should be < ").append(expectedDuration * 1500).append("ms").toString());
    }

    public void addData(int msgCount, byte[] msg) {
        this.producer_$eq(TestUtils$.MODULE$.createProducer(TestUtils$.MODULE$.plaintextBootstrapServers(this.brokers()), 0, 60000L, 0x100000L, Integer.MAX_VALUE, 30000, 0, 16384, "none", 20000, SecurityProtocol.PLAINTEXT, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, new ByteArraySerializer(), new ByteArraySerializer(), false));
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), msgCount).map((Function1 & Serializable)x$6 -> ReplicationQuotasTest.$anonfun$addData$1(this, msg, BoxesRunTime.unboxToInt((Object)x$6))).foreach((Function1 & Serializable)x$7 -> (RecordMetadata)x$7.get());
        this.waitForOffsetsToMatch(msgCount, 0, 100);
    }

    /*
     * WARNING - void declaration
     */
    private void waitForOffsetsToMatch(int offset, int partitionId, int brokerId) {
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 60000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ReplicationQuotasTest.$anonfun$waitForOffsetsToMatch$1(this, offset, brokerId, partitionId)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ReplicationQuotasTest.$anonfun$waitForOffsetsToMatch$4(partitionId, brokerId));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    private KafkaBroker brokerFor(int id) {
        return (KafkaBroker)((IterableOps)this.brokers().filter((Function1 & Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)ReplicationQuotasTest.$anonfun$brokerFor$1(id, x$9)))).head();
    }

    public void createBrokers(scala.collection.immutable.Seq<Object> brokerIds) {
        brokerIds.foreach((Function1)(JFunction1.mcVI.sp & Serializable)id -> this.brokers_$eq((scala.collection.immutable.Seq<KafkaBroker>)((scala.collection.immutable.Seq)this.brokers().$colon$plus((Object)this.createBroker(KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(id, this.zkConnectOrNull(), true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false)), this.createBroker$default$2(), this.createBroker$default$3(), this.createBroker$default$4())))));
    }

    private double avRate(QuotaType replicationType, scala.collection.immutable.Seq<Object> brokers) {
        return BoxesRunTime.unboxToDouble((Object)((IterableOnceOps)((IterableOps)brokers.map((Function1 & Serializable)id -> this.brokerFor(BoxesRunTime.unboxToInt((Object)id)))).map((Function1 & Serializable)x$10 -> BoxesRunTime.boxToDouble((double)this.measuredRate(x$10, replicationType)))).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$)) / (double)brokers.length();
    }

    private double measuredRate(KafkaBroker broker, QuotaType repType) {
        MetricName metricName = broker.metrics().metricName("byte-rate", repType.toString());
        return BoxesRunTime.unboxToDouble((Object)((KafkaMetric)CollectionConverters$.MODULE$.MapHasAsScala(broker.metrics().metrics()).asScala().apply((Object)metricName)).metricValue());
    }

    private void registerBroker(int id) {
        BrokerRegistrationRequestData.ListenerCollection listeners = new BrokerRegistrationRequestData.ListenerCollection();
        listeners.add((ImplicitLinkedHashCollection.Element)new BrokerRegistrationRequestData.Listener().setName(SecurityProtocol.PLAINTEXT.name).setHost("localhost").setPort(9092 + id));
        BrokerRegistrationRequestData.FeatureCollection features = new BrokerRegistrationRequestData.FeatureCollection();
        features.add((ImplicitLinkedHashCollection.Element)new BrokerRegistrationRequestData.Feature().setName("kraft.version").setMinSupportedVersion(KRaftVersion.KRAFT_VERSION_0.featureLevel()).setMaxSupportedVersion(Features.KRAFT_VERSION.latestTesting()));
        features.add((ImplicitLinkedHashCollection.Element)new BrokerRegistrationRequestData.Feature().setName("metadata.version").setMinSupportedVersion(MetadataVersion.IBP_3_9_IV0.featureLevel()).setMaxSupportedVersion(MetadataVersion.latestTesting().featureLevel()));
        features.add((ImplicitLinkedHashCollection.Element)new BrokerRegistrationRequestData.Feature().setName("transaction.version").setMinSupportedVersion(TransactionVersion.TV_0.featureLevel()).setMaxSupportedVersion(Features.TRANSACTION_VERSION.latestTesting()));
        this.controllerServer().controller().registerBroker(ControllerRequestContextUtil.ANONYMOUS_CONTEXT, new BrokerRegistrationRequestData().setBrokerId(id).setClusterId(this.controllerServer().clusterId()).setIncarnationId(Uuid.randomUuid()).setListeners(listeners).setLogDirs(Collections.singletonList(Uuid.fromString((String)new StringBuilder(17).append("TESTBROKER").append(Integer.toString(100000 + id).substring(1)).append("DIRAAAA").toString()))).setFeatures(features)).get();
    }

    public static final /* synthetic */ Integer $anonfun$shouldMatchQuotaReplicatingThroughAnAsymmetricTopology$5(int x$3) {
        return BoxesRunTime.boxToInteger((int)x$3);
    }

    public static final /* synthetic */ Object $anonfun$shouldMatchQuotaReplicatingThroughAnAsymmetricTopology$6(ReplicationQuotasTest $this, LongRef throttle$1, int brokerId) {
        if ($this.isKRaftTest()) {
            AbstractMap.SimpleImmutableEntry<AlterConfigOp.OpType, String> entry = new AbstractMap.SimpleImmutableEntry<AlterConfigOp.OpType, String>(AlterConfigOp.OpType.SET, Long.toString(throttle$1.elem));
            return $this.controllerServer().controller().incrementalAlterConfigs(ControllerRequestContextUtil.ANONYMOUS_CONTEXT, CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new ConfigResource(ConfigResource.Type.BROKER, String.valueOf(brokerId))), (Object)CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"leader.replication.throttled.rate"), entry), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"follower.replication.throttled.rate"), entry)}))).asJava())}))).asJava(), false).get();
        }
        $this.adminZkClient().changeBrokerConfig((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{brokerId})), CoreUtils$.MODULE$.propsWith((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"leader.replication.throttled.rate", (Object)Long.toString(throttle$1.elem)), new Tuple2((Object)"follower.replication.throttled.rate", (Object)Long.toString(throttle$1.elem))})));
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Future $anonfun$shouldMatchQuotaReplicatingThroughAnAsymmetricTopology$8(ReplicationQuotasTest $this, byte[] msg$1, int partition) {
        return $this.producer().send(new ProducerRecord($this.topic(), Predef$.MODULE$.int2Integer(partition), null, (Object)msg$1));
    }

    public static final /* synthetic */ Integer $anonfun$shouldThrottleOldSegments$2(int x$5) {
        return BoxesRunTime.boxToInteger((int)x$5);
    }

    public static final /* synthetic */ Future $anonfun$addData$1(ReplicationQuotasTest $this, byte[] msg$2, int x$6) {
        return $this.producer().send(new ProducerRecord($this.topic(), (Object)msg$2));
    }

    public static final /* synthetic */ boolean $anonfun$waitForOffsetsToMatch$1(ReplicationQuotasTest $this, int offset$1, int brokerId$1, int partitionId$1) {
        LogManager qual$1 = $this.brokerFor(brokerId$1).logManager();
        TopicPartition x$1 = new TopicPartition($this.topic(), partitionId$1);
        boolean x$2 = qual$1.getLog$default$2();
        return BoxesRunTime.equals((Object)BoxesRunTime.boxToInteger((int)offset$1), (Object)qual$1.getLog(x$1, x$2).map((Function1 & Serializable)x$8 -> BoxesRunTime.boxToLong((long)x$8.logEndOffset())).getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> 0));
    }

    public static final /* synthetic */ String $anonfun$waitForOffsetsToMatch$4(int partitionId$1, int brokerId$1) {
        return new StringBuilder(47).append("Offsets did not match for partition ").append(partitionId$1).append(" on broker ").append(brokerId$1).toString();
    }

    public static final /* synthetic */ boolean $anonfun$brokerFor$1(int id$1, KafkaBroker x$9) {
        return x$9.config().brokerId() == id$1;
    }

    public ReplicationQuotasTest() {
        this.topic = "topic1";
    }
}

