/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.dispatcher.multipart;

import jakarta.servlet.http.HttpServletRequest;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.fileupload2.core.DiskFileItem;
import org.apache.commons.fileupload2.core.RequestContext;
import org.apache.commons.fileupload2.jakarta.servlet6.JakartaServletDiskFileUpload;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.struts2.dispatcher.LocalizedMessage;
import org.apache.struts2.dispatcher.multipart.AbstractMultiPartRequest;
import org.apache.struts2.dispatcher.multipart.StrutsUploadedFile;
import org.apache.struts2.dispatcher.multipart.UploadedFile;

public class JakartaMultiPartRequest
extends AbstractMultiPartRequest {
    private static final Logger LOG = LogManager.getLogger(JakartaMultiPartRequest.class);
    private final List<DiskFileItem> diskFileItems = new ArrayList<DiskFileItem>();
    private final List<File> temporaryFiles = new ArrayList<File>();

    @Override
    protected void processUpload(HttpServletRequest request, String saveDir) throws IOException {
        Charset charset = this.readCharsetEncoding(request);
        JakartaServletDiskFileUpload servletFileUpload = this.prepareServletFileUpload(charset, Path.of(saveDir, new String[0]));
        RequestContext requestContext = this.createRequestContext(request);
        for (DiskFileItem item : servletFileUpload.parseRequest(requestContext)) {
            this.diskFileItems.add(item);
            LOG.debug(() -> "Processing a form field: " + StringUtils.normalizeSpace((String)item.getFieldName()));
            if (item.isFormField()) {
                this.processNormalFormField(item, charset);
                continue;
            }
            LOG.debug(() -> "Processing a file: " + StringUtils.normalizeSpace((String)item.getFieldName()));
            this.processFileField(item, saveDir);
        }
    }

    protected void processNormalFormField(DiskFileItem item, Charset charset) throws IOException {
        LOG.debug("Item: {} is a normal form field", (Object)StringUtils.normalizeSpace((String)item.getName()));
        String fieldName = item.getFieldName();
        if (fieldName == null) {
            LOG.warn("Form field has null fieldName, skipping");
            return;
        }
        List values = this.parameters.computeIfAbsent(fieldName, k -> new ArrayList());
        String fieldValue = item.getString(charset);
        if (this.exceedsMaxStringLength(fieldName, fieldValue)) {
            return;
        }
        if (item.getSize() == 0L) {
            values.add("");
        } else {
            values.add(fieldValue);
        }
        this.parameters.put(fieldName, values);
    }

    protected void processFileField(DiskFileItem item, String saveDir) {
        List values;
        String fieldName;
        block14: {
            if (item.getName() == null || item.getName().trim().isEmpty()) {
                LOG.debug(() -> "No file has been uploaded for the field: " + StringUtils.normalizeSpace((String)item.getFieldName()));
                return;
            }
            fieldName = item.getFieldName();
            if (fieldName == null) {
                LOG.warn("File field has null fieldName, skipping");
                return;
            }
            if (this.rejectEmptyFile(item.getSize(), item.getName(), fieldName)) {
                return;
            }
            values = this.uploadedFiles.computeIfAbsent(fieldName, k -> new ArrayList());
            if (item.isInMemory()) {
                LOG.debug(() -> "Creating temporary file representing in-memory uploaded item: " + StringUtils.normalizeSpace((String)item.getFieldName()));
                try {
                    File tempFile = this.createTemporaryFile(item.getName(), Path.of(saveDir, new String[0]));
                    this.temporaryFiles.add(tempFile);
                    try (FileOutputStream fos = new FileOutputStream(tempFile);){
                        fos.write(item.get());
                    }
                    UploadedFile uploadedFile = StrutsUploadedFile.Builder.create(tempFile).withOriginalName(item.getName()).withContentType(item.getContentType()).withInputName(item.getFieldName()).build();
                    values.add(uploadedFile);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Created temporary file for in-memory uploaded item: {} at {}", (Object)StringUtils.normalizeSpace((String)item.getName()), (Object)tempFile.getAbsolutePath());
                    }
                    break block14;
                }
                catch (IOException e) {
                    LOG.warn("Failed to create temporary file for in-memory uploaded item: {}", (Object)StringUtils.normalizeSpace((String)item.getName()), (Object)e);
                    LocalizedMessage errorMessage = this.buildErrorMessage(e.getClass(), e.getMessage(), new Object[]{item.getName()});
                    if (!this.errors.contains(errorMessage)) {
                        this.errors.add(errorMessage);
                    }
                    break block14;
                }
            }
            UploadedFile uploadedFile = StrutsUploadedFile.Builder.create(item.getPath().toFile()).withOriginalName(item.getName()).withContentType(item.getContentType()).withInputName(item.getFieldName()).build();
            values.add(uploadedFile);
        }
        this.uploadedFiles.put(fieldName, values);
    }

    protected void cleanUpDiskFileItems() {
        LOG.debug("Clean up all DiskFileItem instances (both form fields and file uploads");
        for (DiskFileItem item : this.diskFileItems) {
            try {
                if (item.isInMemory()) {
                    LOG.debug(() -> "Cleaning up in-memory item: " + StringUtils.normalizeSpace((String)item.getFieldName()));
                    continue;
                }
                Path itemPath = item.getPath();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Cleaning up disk item: {} at {}", (Object)StringUtils.normalizeSpace((String)item.getFieldName()), (Object)itemPath);
                }
                this.deleteFile(itemPath);
            }
            catch (Exception e) {
                LOG.warn("Error cleaning up DiskFileItem: {}", (Object)StringUtils.normalizeSpace((String)item.getFieldName()), (Object)e);
            }
        }
    }

    protected void cleanUpTemporaryFiles() {
        LOG.debug("Cleaning up {} temporary files created for in-memory uploads", (Object)this.temporaryFiles.size());
        for (File tempFile : this.temporaryFiles) {
            this.deleteFile(tempFile.toPath());
        }
    }

    @Override
    public void cleanUp() {
        super.cleanUp();
        try {
            this.cleanUpDiskFileItems();
            this.cleanUpTemporaryFiles();
        }
        finally {
            this.diskFileItems.clear();
            this.temporaryFiles.clear();
        }
    }
}

