/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.interceptor.csp;

import org.apache.struts2.interceptor.csp.CspNonceSource;
import org.apache.struts2.util.ValueStack;

public interface CspNonceReader {
    public NonceValue readNonceValue(ValueStack var1);

    public static class NonceValue {
        private final String nonceValue;
        private final CspNonceSource source;

        private NonceValue(String nonceValue, CspNonceSource source) {
            this.nonceValue = nonceValue;
            this.source = source;
        }

        public static NonceValue ofSession(String nonceValue) {
            return new NonceValue(nonceValue, CspNonceSource.SESSION);
        }

        public static NonceValue ofRequest(String nonceValue) {
            return new NonceValue(nonceValue, CspNonceSource.REQUEST);
        }

        public static NonceValue ofNullSession() {
            return new NonceValue(null, CspNonceSource.SESSION);
        }

        public static NonceValue ofNullRequest() {
            return new NonceValue(null, CspNonceSource.REQUEST);
        }

        public boolean isNonceValueSet() {
            return this.nonceValue != null;
        }

        public String getNonceValue() {
            return this.nonceValue;
        }

        public CspNonceSource getSource() {
            return this.source;
        }

        public String toString() {
            String displayNonce = this.nonceValue != null && this.nonceValue.length() >= 4 ? String.format("nonceValue='%s**********'", this.nonceValue.substring(0, 4)) : (this.nonceValue != null ? String.format("nonceValue='%s**********'", this.nonceValue) : "nonceValue='<null>'");
            return "NonceValue{" + displayNonce + ", source=" + String.valueOf((Object)this.source) + "}";
        }
    }
}

