/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.jasperreports.engine.JRGenericPrintElement;
import net.sf.jasperreports.engine.JRPrintHyperlink;
import net.sf.jasperreports.engine.JRPrintHyperlinkParameter;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.export.JRHyperlinkProducer;
import net.sf.jasperreports.engine.util.HyperlinkData;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class HyperlinkUtil {
    private static final Log log = LogFactory.getLog(HyperlinkUtil.class);
    protected static final Pattern LINK_PATTERN = Pattern.compile("\\{(link\\-[\\-\\w]+)\\}");
    protected static final int LINK_PARAM_NAME_GROUP = 1;

    public static Boolean getIgnoreHyperlink(String propName, JRPrintHyperlink link) {
        if (link != null) {
            List<JRPrintHyperlinkParameter> parameters;
            Boolean hyperlinkVisible = null;
            if (link.getHyperlinkParameters() != null && (parameters = link.getHyperlinkParameters().getParameters()) != null) {
                for (int i = 0; i < parameters.size(); ++i) {
                    JRPrintHyperlinkParameter parameter = parameters.get(i);
                    if (!propName.equals(parameter.getName())) continue;
                    hyperlinkVisible = (Boolean)parameter.getValue();
                    break;
                }
            }
            return hyperlinkVisible;
        }
        return null;
    }

    public static String makeLinkParameterName(JRPrintHyperlink hyperlink) {
        return "link-" + System.identityHashCode(hyperlink);
    }

    public static String makeLinkPlaceholder(JRPrintHyperlink hyperlink) {
        String id = HyperlinkUtil.makeLinkParameterName(hyperlink);
        return HyperlinkUtil.makeLinkPlaceholder(id);
    }

    public static String makeLinkPlaceholder(String linkId) {
        return "{" + linkId + "}";
    }

    public static String resolveLinks(String text, JRGenericPrintElement element, JRHyperlinkProducer linkProducer, boolean prepareForSerialization) {
        Matcher matcher = LINK_PATTERN.matcher(text);
        StringBuffer xml = new StringBuffer();
        ArrayList<HyperlinkData> hyperlinksData = new ArrayList<HyperlinkData>();
        while (matcher.find()) {
            String replacement;
            String paramName = matcher.group(1);
            JRPrintHyperlink hyperlink = (JRPrintHyperlink)element.getParameterValue(paramName);
            if (hyperlink == null) {
                if (log.isWarnEnabled()) {
                    log.warn((Object)("Hyperlink parameter " + paramName + " not found in element"));
                }
                replacement = null;
            } else {
                replacement = linkProducer.getHyperlink(hyperlink);
                if (prepareForSerialization) {
                    String id = String.valueOf(hyperlink.hashCode() & Integer.MAX_VALUE);
                    HyperlinkData hyperlinkData = new HyperlinkData();
                    hyperlinkData.setId(id);
                    hyperlinkData.setHref(replacement);
                    hyperlinkData.setHyperlink(hyperlink);
                    hyperlinkData.setSelector("._jrHyperLink." + hyperlink.getLinkType());
                    replacement = "jrhl-" + id + ";" + hyperlink.getLinkType();
                    hyperlinksData.add(hyperlinkData);
                }
            }
            if (replacement == null) {
                replacement = "";
            } else {
                try {
                    if (!prepareForSerialization) {
                        replacement = URLEncoder.encode(replacement, "UTF-8");
                    }
                }
                catch (UnsupportedEncodingException e) {
                    throw new JRRuntimeException(e);
                }
            }
            matcher.appendReplacement(xml, replacement);
        }
        matcher.appendTail(xml);
        if (hyperlinksData.size() > 0) {
            element.setParameterValue("hyperlinksData", hyperlinksData);
        }
        return xml.toString();
    }

    private HyperlinkUtil() {
    }
}

