/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.design;

import java.util.List;
import java.util.Map;
import net.sf.jasperreports.compilers.ReportSourceCompilation;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRExpressionCollector;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRParameter;
import net.sf.jasperreports.engine.JRVariable;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.util.DigestUtils;

public class JRSourceCompileTask {
    private JasperDesign jasperDesign;
    private String unitName;
    private JRExpressionCollector expressionCollector;
    private Map<String, ? extends JRParameter> parametersMap;
    private Map<String, JRField> fieldsMap;
    private Map<String, JRVariable> variablesMap;
    private JRVariable[] variables;
    private List<JRExpression> expressions;
    private boolean onlyDefaultEvaluation;
    private String compileName;

    protected JRSourceCompileTask(JasperDesign jasperDesign, String unitName, JRExpressionCollector expressionCollector, List<JRExpression> expressions, Map<String, ? extends JRParameter> parametersMap, Map<String, JRField> fieldsMap, Map<String, JRVariable> variablesMap, JRVariable[] variables, boolean onlyDefaultEvaluation) {
        this.jasperDesign = jasperDesign;
        this.unitName = unitName;
        this.expressionCollector = expressionCollector;
        this.parametersMap = parametersMap;
        this.fieldsMap = fieldsMap;
        this.variablesMap = variablesMap;
        this.variables = variables;
        this.expressions = expressions;
        this.onlyDefaultEvaluation = onlyDefaultEvaluation;
        this.compileName = this.computeCompileName();
    }

    public JRSourceCompileTask(JasperDesign jasperDesign, String unitName, JRExpressionCollector expressionCollector, ReportSourceCompilation<?> sourceCompilation, boolean onlyDefaultEvaluation) {
        this(jasperDesign, unitName, expressionCollector, sourceCompilation.getExpressions(), sourceCompilation.getParameters(), sourceCompilation.getFields(), sourceCompilation.getVariables(), sourceCompilation.getVariablesArray(), onlyDefaultEvaluation);
    }

    private String computeCompileName() {
        StringBuilder sourceText = new StringBuilder();
        if (this.parametersMap != null) {
            for (JRParameter jRParameter : this.parametersMap.values()) {
                sourceText.append("p;");
                sourceText.append(jRParameter.getName());
                sourceText.append(";");
                sourceText.append(jRParameter.getValueClassName());
                sourceText.append(";");
            }
        }
        if (this.fieldsMap != null) {
            for (JRField jRField : this.fieldsMap.values()) {
                sourceText.append("f;");
                sourceText.append(jRField.getName());
                sourceText.append(";");
                sourceText.append(jRField.getValueClassName());
                sourceText.append(";");
            }
        }
        if (this.variables != null) {
            for (JRVariable variable : this.variables) {
                sourceText.append("v;");
                sourceText.append(variable.getName());
                sourceText.append(";");
                sourceText.append(variable.getValueClassName());
                sourceText.append(";");
            }
        }
        if (this.expressions != null) {
            for (JRExpression jRExpression : this.expressions) {
                sourceText.append("e;");
                sourceText.append(this.expressionCollector.getExpressionId(jRExpression));
                sourceText.append(";");
                sourceText.append(jRExpression.getText());
                sourceText.append(";");
            }
        }
        sourceText.append("onlyDefaultEvaluation;");
        sourceText.append(this.onlyDefaultEvaluation);
        String hash = DigestUtils.instance().sha256(sourceText.toString());
        return this.unitName + "_" + hash;
    }

    public List<JRExpression> getExpressions() {
        return this.expressions;
    }

    public Map<String, JRField> getFieldsMap() {
        return this.fieldsMap;
    }

    public JasperDesign getJasperDesign() {
        return this.jasperDesign;
    }

    public String[] getImports() {
        return this.jasperDesign.getImports();
    }

    public boolean isOnlyDefaultEvaluation() {
        return this.onlyDefaultEvaluation;
    }

    public Map<String, ? extends JRParameter> getParametersMap() {
        return this.parametersMap;
    }

    public String getUnitName() {
        return this.unitName;
    }

    public String getCompileName() {
        return this.compileName;
    }

    public JRVariable[] getVariables() {
        return this.variables;
    }

    public Map<String, JRVariable> getVariablesMap() {
        return this.variablesMap;
    }

    public Integer getExpressionId(JRExpression expression) {
        return this.expressionCollector.getExpressionId(expression);
    }

    public JRExpression getExpression(int expressionId) {
        return this.expressionCollector.getExpression(expressionId);
    }

    public JasperReportsContext getJasperReportsContext() {
        return this.expressionCollector.getJasperReportsContext();
    }
}

