/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tiles.api.access;

import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.tiles.api.NoSuchContainerException;
import org.apache.tiles.api.TilesContainer;
import org.apache.tiles.request.ApplicationContext;
import org.apache.tiles.request.Request;

public final class TilesAccess {
    private static final Logger LOG = LogManager.getLogger(TilesAccess.class);
    public static final String CURRENT_CONTAINER_ATTRIBUTE_NAME = "org.apache.tiles.servlet.context.ServletTilesRequestContext.CURRENT_CONTAINER_KEY";
    public static final String CONTAINER_ATTRIBUTE = "org.apache.tiles.CONTAINER";

    private TilesAccess() {
    }

    public static void setContainer(ApplicationContext context, TilesContainer container, String key) {
        if (key == null) {
            key = CONTAINER_ATTRIBUTE;
        }
        if (container == null) {
            LOG.info("Removing TilesContext for context: {}", (Object)context.getClass().getName());
            context.getApplicationScope().remove(key);
        } else {
            LOG.info("Publishing TilesContext for context: {}", (Object)context.getClass().getName());
            context.getApplicationScope().put(key, container);
        }
    }

    public static TilesContainer getContainer(ApplicationContext context) {
        return TilesAccess.getContainer(context, CONTAINER_ATTRIBUTE);
    }

    public static TilesContainer getContainer(ApplicationContext context, String key) {
        if (key == null) {
            key = CONTAINER_ATTRIBUTE;
        }
        return (TilesContainer)context.getApplicationScope().get(key);
    }

    public static void setCurrentContainer(Request request, String key) {
        ApplicationContext applicationContext = request.getApplicationContext();
        TilesContainer container = TilesAccess.getContainer(applicationContext, key);
        if (container == null) {
            throw new NoSuchContainerException("The container with the key '" + key + "' cannot be found");
        }
        request.getContext("request").put(CURRENT_CONTAINER_ATTRIBUTE_NAME, container);
    }

    public static void setCurrentContainer(Request request, TilesContainer container) {
        if (container == null) {
            throw new NullPointerException("The container cannot be null");
        }
        request.getContext("request").put(CURRENT_CONTAINER_ATTRIBUTE_NAME, container);
    }

    public static TilesContainer getCurrentContainer(Request request) {
        ApplicationContext context = request.getApplicationContext();
        Map<String, Object> requestScope = request.getContext("request");
        TilesContainer container = (TilesContainer)requestScope.get(CURRENT_CONTAINER_ATTRIBUTE_NAME);
        if (container == null) {
            container = TilesAccess.getContainer(context);
            requestScope.put(CURRENT_CONTAINER_ATTRIBUTE_NAME, container);
        }
        return container;
    }
}

