/**
 * Licensed to the Apache Software Foundation (ASF) under one or more contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.  The ASF licenses this file to you under the Apache License, Version
 * 2.0 (the "License"); you may not use this file except in compliance with the License.  You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package org.apache.storm.trident.topology;

import org.apache.storm.trident.spout.IBatchID;


public class TransactionAttempt implements IBatchID {
    Long txid;
    int attemptId;


    // for kryo compatibility
    public TransactionAttempt() {

    }

    public TransactionAttempt(Long txid, int attemptId) {
        this.txid = txid;
        this.attemptId = attemptId;
    }

    public Long getTransactionId() {
        return txid;
    }

    @Override
    public Object getId() {
        return txid;
    }

    @Override
    public int getAttemptId() {
        return attemptId;
    }

    @Override
    public int hashCode() {
        return txid.hashCode();
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof TransactionAttempt)) {
            return false;
        }
        TransactionAttempt other = (TransactionAttempt) o;
        return txid.equals(other.txid) && attemptId == other.attemptId;
    }

    @Override
    public String toString() {
        return "" + txid + ":" + attemptId;
    }
}
