/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.blob.datastore;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.lang3.StringUtils;
import org.apache.jackrabbit.core.data.DataIdentifier;
import org.apache.jackrabbit.core.data.DataRecord;
import org.apache.jackrabbit.core.data.DataStoreException;
import org.apache.jackrabbit.core.data.LazyFileInputStream;
import org.apache.jackrabbit.oak.commons.conditions.Validate;
import org.apache.jackrabbit.oak.commons.io.FileTreeTraverser;
import org.apache.jackrabbit.oak.spi.blob.AbstractDataRecord;
import org.apache.jackrabbit.oak.spi.blob.AbstractSharedBackend;
import org.apache.jackrabbit.util.TransientFileFactory;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FSBackend
extends AbstractSharedBackend {
    private static final Logger LOG = LoggerFactory.getLogger(FSBackend.class);
    public static final String FS_BACKEND_PATH = "fsBackendPath";
    private static final int ACCESS_TIME_RESOLUTION = 2000;
    private Properties properties;
    private String fsPath;
    private File fsPathDir;

    @Override
    public void init() throws DataStoreException {
        boolean created;
        this.fsPath = this.properties.getProperty(FS_BACKEND_PATH);
        if (this.fsPath == null || "".equals(this.fsPath)) {
            throw new DataStoreException("Could not initialize FSBackend from " + String.valueOf(this.properties) + ". [fsBackendPath] property not found.");
        }
        this.fsPath = FilenameUtils.normalizeNoEndSeparator((String)this.fsPath);
        this.fsPathDir = new File(this.fsPath);
        if (this.fsPathDir.exists() && this.fsPathDir.isFile()) {
            throw new DataStoreException("Can not create a directory because a file exists with the same name: " + this.fsPath);
        }
        if (!this.fsPathDir.exists() && !(created = this.fsPathDir.mkdirs())) {
            throw new DataStoreException("Could not create directory: " + this.fsPathDir.getAbsolutePath());
        }
    }

    @Override
    public InputStream read(DataIdentifier identifier) throws DataStoreException {
        File file = FSBackend.getFile(identifier, this.fsPathDir);
        try {
            return new LazyFileInputStream(file);
        }
        catch (IOException e) {
            throw new DataStoreException("Error opening input stream of " + file.getAbsolutePath(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(DataIdentifier identifier, File file) throws DataStoreException {
        TransientFileFactory fileFactory = TransientFileFactory.getInstance();
        File tmpFile = null;
        File dest = FSBackend.getFile(identifier, this.fsPathDir);
        if (dest.exists()) {
            long now = System.currentTimeMillis();
            if (FSBackend.getLastModified(dest) < now + 2000L) {
                FSBackend.setLastModified(dest, now + 2000L);
            }
        } else {
            try {
                tmpFile = fileFactory.createTransientFile("fsbackend", null, this.fsPathDir);
                FileUtils.copyFile((File)file, (File)tmpFile);
                File parent = dest.getParentFile();
                parent.mkdirs();
                FSBackend fSBackend = this;
                synchronized (fSBackend) {
                    if (!tmpFile.renameTo(dest)) {
                        throw new IOException("Can not rename " + tmpFile.getAbsolutePath() + " to " + dest.getAbsolutePath() + " (media read only?)");
                    }
                    tmpFile = null;
                }
            }
            catch (IOException e) {
                throw new DataStoreException("Could not add record", e);
            }
            finally {
                if (tmpFile != null) {
                    tmpFile.delete();
                }
            }
        }
    }

    @Override
    public DataRecord getRecord(DataIdentifier identifier) throws DataStoreException {
        long start = System.currentTimeMillis();
        File file = FSBackend.getFile(identifier, this.fsPathDir);
        if (!file.exists() || !file.isFile()) {
            LOG.info("getRecord:Identifier [{}] not found. Took [{}] ms.", (Object)identifier, (Object)(System.currentTimeMillis() - start));
            throw new DataStoreException("Identifier [" + String.valueOf(identifier) + "] not found.");
        }
        return new FSBackendDataRecord(this, identifier, file);
    }

    @Override
    public Iterator<DataIdentifier> getAllIdentifiers() throws DataStoreException {
        return FileTreeTraverser.depthFirstPostOrder(this.fsPathDir).filter(file -> file.isFile() && !FilenameUtils.normalizeNoEndSeparator((String)file.getParent()).equals(this.fsPath)).map(file -> new DataIdentifier(file.getName())).iterator();
    }

    @Override
    public boolean exists(DataIdentifier identifier) throws DataStoreException {
        File file = FSBackend.getFile(identifier, this.fsPathDir);
        return file.exists() && file.isFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteRecord(DataIdentifier identifier) throws DataStoreException {
        File file = FSBackend.getFile(identifier, this.fsPathDir);
        FSBackend fSBackend = this;
        synchronized (fSBackend) {
            if (file.exists()) {
                if (file.delete()) {
                    this.deleteEmptyParentDirs(file);
                } else {
                    LOG.warn("Failed to delete file " + file.getAbsolutePath());
                }
            }
        }
    }

    @Override
    public void addMetadataRecord(InputStream input, String name) throws DataStoreException {
        Validate.checkArgument(input != null, "input should not be null");
        Validate.checkArgument(!StringUtils.isEmpty((CharSequence)name), "name should not be empty");
        try {
            File file = new File(this.fsPathDir, name);
            try (InputStream inputStream = input;
                 FileOutputStream os = new FileOutputStream(file);){
                IOUtils.copyLarge((InputStream)input, (OutputStream)os);
            }
        }
        catch (IOException e) {
            LOG.error("Exception while adding metadata record with name {}, {}", new Object[]{name, e});
            throw new DataStoreException("Could not add root record", e);
        }
    }

    @Override
    public void addMetadataRecord(File input, String name) throws DataStoreException {
        Validate.checkArgument(input != null, "input should not be null");
        Validate.checkArgument(!StringUtils.isEmpty((CharSequence)name), "name should not be empty");
        try {
            File file = new File(this.fsPathDir, name);
            FileUtils.copyFile((File)input, (File)file);
        }
        catch (IOException e) {
            LOG.error("Exception while adding metadata record file {} with name {}, {}", new Object[]{input, name, e});
            throw new DataStoreException("Could not add root record", e);
        }
    }

    @Override
    public DataRecord getMetadataRecord(String name) {
        Validate.checkArgument(!StringUtils.isEmpty((CharSequence)name), "name should not be empty");
        for (File file : FileFilterUtils.filter((IOFileFilter)FileFilterUtils.nameFileFilter((String)name), (File[])this.fsPathDir.listFiles())) {
            if (file.isDirectory()) continue;
            return new FSBackendDataRecord(this, new DataIdentifier(file.getName()), file);
        }
        return null;
    }

    @Override
    public List<DataRecord> getAllMetadataRecords(String prefix) {
        Validate.checkArgument(null != prefix, "prefix should not be null");
        ArrayList<DataRecord> rootRecords = new ArrayList<DataRecord>();
        for (File file : FileFilterUtils.filterList((IOFileFilter)FileFilterUtils.prefixFileFilter((String)prefix), (File[])this.fsPathDir.listFiles())) {
            if (file.isDirectory()) continue;
            rootRecords.add(new FSBackendDataRecord(this, new DataIdentifier(file.getName()), file));
        }
        return rootRecords;
    }

    @Override
    public boolean deleteMetadataRecord(String name) {
        Validate.checkArgument(!StringUtils.isEmpty((CharSequence)name), "name should not be empty");
        for (File file : FileFilterUtils.filterList((IOFileFilter)FileFilterUtils.nameFileFilter((String)name), (File[])this.fsPathDir.listFiles())) {
            if (file.isDirectory()) continue;
            if (!file.delete()) {
                LOG.warn("Failed to delete root record {} ", new Object[]{file.getAbsolutePath()});
                continue;
            }
            return true;
        }
        return false;
    }

    @Override
    public void deleteAllMetadataRecords(String prefix) {
        Validate.checkArgument(null != prefix, "prefix should not be empty");
        for (File file : FileFilterUtils.filterList((IOFileFilter)FileFilterUtils.prefixFileFilter((String)prefix), (File[])this.fsPathDir.listFiles())) {
            if (file.isDirectory() || file.delete()) continue;
            LOG.warn("Failed to delete root record {} ", new Object[]{file.getAbsolutePath()});
        }
    }

    @Override
    public boolean metadataRecordExists(String name) {
        for (File file : FileFilterUtils.filterList((IOFileFilter)FileFilterUtils.nameFileFilter((String)name), (File[])this.fsPathDir.listFiles())) {
            if (file.isDirectory()) continue;
            if (!file.exists()) {
                LOG.debug("File does not exist {} ", new Object[]{file.getAbsolutePath()});
                continue;
            }
            return true;
        }
        return false;
    }

    @Override
    public Iterator<DataRecord> getAllRecords() {
        FSBackend backend = this;
        return FileTreeTraverser.depthFirstPostOrder(this.fsPathDir).filter(file -> file.isFile() && !FilenameUtils.normalizeNoEndSeparator((String)file.getParent()).equals(this.fsPath)).map(file -> new FSBackendDataRecord(backend, new DataIdentifier(file.getName()), (File)file)).iterator();
    }

    @Override
    public void close() throws DataStoreException {
    }

    @Override
    public byte[] getOrCreateReferenceKey() throws DataStoreException {
        File file = new File(this.fsPathDir, "reference.key");
        try {
            if (file.exists()) {
                return FileUtils.readFileToByteArray((File)file);
            }
            byte[] key = super.getOrCreateReferenceKey();
            FileUtils.writeByteArrayToFile((File)file, (byte[])key);
            return key;
        }
        catch (IOException e) {
            throw new DataStoreException("Unable to access reference key file " + file.getPath(), e);
        }
    }

    private static File getFile(DataIdentifier identifier, File root) {
        String string = identifier.toString();
        File file = root;
        file = new File(file, string.substring(0, 2));
        file = new File(file, string.substring(2, 4));
        file = new File(file, string.substring(4, 6));
        return new File(file, string);
    }

    private static long getLastModified(File file) throws DataStoreException {
        long lastModified = file.lastModified();
        if (lastModified == 0L) {
            throw new DataStoreException("Failed to read record modified date: " + file.getAbsolutePath());
        }
        return lastModified;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setLastModified(File file, long time) throws DataStoreException {
        if (!file.setLastModified(time)) {
            if (!file.canWrite()) {
                return;
            }
            try (RandomAccessFile r = new RandomAccessFile(file, "rw");){
                r.setLength(r.length());
            }
            catch (IOException e) {
                throw new DataStoreException("An IO Exception occurred while trying to set the last modified date: " + file.getAbsolutePath(), e);
            }
        }
    }

    private void deleteEmptyParentDirs(File file) {
        File parent = file.getParentFile();
        try {
            while (FileUtils.directoryContains((File)this.fsPathDir, (File)parent)) {
                String[] entries = parent.list();
                if (entries == null) {
                    LOG.warn("Failed to list directory {}", (Object)parent.getAbsolutePath());
                } else if (entries.length <= 0) {
                    boolean deleted = parent.delete();
                    LOG.debug("Deleted parent [{}] of file [{}]: {}", new Object[]{parent, file.getAbsolutePath(), deleted});
                    parent = parent.getParentFile();
                    continue;
                }
                break;
            }
        }
        catch (IOException e) {
            LOG.warn("Error in parents deletion for " + String.valueOf(file.getAbsoluteFile()), (Throwable)e);
        }
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    class FSBackendDataRecord
    extends AbstractDataRecord {
        private long length;
        private long lastModified;
        private File file;

        public FSBackendDataRecord(@NotNull AbstractSharedBackend backend, @NotNull DataIdentifier identifier, File file) {
            super(backend, identifier);
            this.file = file;
            this.length = file.length();
            this.lastModified = file.lastModified();
        }

        @Override
        public long getLength() throws DataStoreException {
            return this.length;
        }

        @Override
        public InputStream getStream() throws DataStoreException {
            try {
                return new LazyFileInputStream(this.file);
            }
            catch (FileNotFoundException e) {
                LOG.error("Error in returning stream", (Throwable)e);
                throw new DataStoreException(e);
            }
        }

        @Override
        public long getLastModified() {
            return this.lastModified;
        }

        @Override
        public String toString() {
            return "S3DataRecord{identifier=" + String.valueOf(this.getIdentifier()) + ", length=" + this.length + ", lastModified=" + this.lastModified + "}";
        }
    }
}

