/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.junit.impl.servlet;

import java.io.IOException;
import java.util.Dictionary;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.sling.junit.RendererSelector;
import org.apache.sling.junit.TestsManager;
import org.apache.sling.junit.impl.servlet.ServletProcessor;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.http.HttpService;
import org.osgi.service.http.NamespaceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, property={"servlet.path=/system/sling/junit"})
public class JUnitServlet
extends HttpServlet {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    public static final String SERVLET_PATH_NAME = "servlet.path";
    private String servletPath;
    @Reference
    private TestsManager testsManager;
    @Reference
    private HttpService httpService;
    @Reference
    private RendererSelector rendererSelector;
    private volatile ServletProcessor processor;

    @Activate
    protected void activate(ComponentContext ctx) throws ServletException, NamespaceException {
        this.servletPath = this.getServletPath(ctx);
        if (this.servletPath == null) {
            this.log.info("Servlet path is null, not registering with HttpService");
        } else {
            this.httpService.registerServlet(this.servletPath, (Servlet)this, null, null);
            this.processor = new ServletProcessor(this.testsManager, this.rendererSelector);
            this.log.info("Servlet registered at {}", (Object)this.servletPath);
        }
    }

    private String getServletPath(ComponentContext ctx) {
        Dictionary config = ctx.getProperties();
        String result = (String)config.get(SERVLET_PATH_NAME);
        if (result != null && result.trim().length() == 0) {
            result = null;
        }
        return result;
    }

    @Deactivate
    protected void deactivate(ComponentContext ctx) {
        if (this.servletPath != null) {
            this.httpService.unregister(this.servletPath);
            this.log.info("Servlet unregistered from path {}", (Object)this.servletPath);
        }
        this.servletPath = null;
        this.processor = null;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.processor.doGet(req, resp, this.servletPath);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.processor.doPost(req, resp);
    }
}

