/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.crs;

import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlSeeAlso;
import jakarta.xml.bind.annotation.XmlType;
import java.util.EnumMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.measure.Unit;
import org.apache.sis.io.wkt.Convention;
import org.apache.sis.io.wkt.FormattableObject;
import org.apache.sis.io.wkt.Formatter;
import org.apache.sis.metadata.internal.shared.ImplementationHelper;
import org.apache.sis.pending.geoapi.referencing.MissingMethods;
import org.apache.sis.referencing.AbstractReferenceSystem;
import org.apache.sis.referencing.crs.AbstractSingleCRS;
import org.apache.sis.referencing.crs.DefaultCompoundCRS;
import org.apache.sis.referencing.crs.DynamicCRS;
import org.apache.sis.referencing.crs.SubTypes;
import org.apache.sis.referencing.cs.AbstractCS;
import org.apache.sis.referencing.cs.AxesConvention;
import org.apache.sis.referencing.cs.DefaultCoordinateSystemAxis;
import org.apache.sis.referencing.datum.AbstractDatum;
import org.apache.sis.referencing.datum.DefaultDatumEnsemble;
import org.apache.sis.referencing.internal.shared.NilReferencingObject;
import org.apache.sis.referencing.internal.shared.ReferencingUtilities;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.Utilities;
import org.apache.sis.util.resources.Errors;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.referencing.ReferenceSystem;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.GeneralDerivedCRS;
import org.opengis.referencing.crs.SingleCRS;
import org.opengis.referencing.cs.AffineCS;
import org.opengis.referencing.cs.CartesianCS;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.datum.Datum;

@XmlType(name="AbstractCRSType")
@XmlRootElement(name="AbstractCRS")
@XmlSeeAlso(value={AbstractSingleCRS.class, DefaultCompoundCRS.class})
public class AbstractCRS
extends AbstractReferenceSystem
implements CoordinateReferenceSystem {
    private static final long serialVersionUID = -4925108294894867598L;
    private CoordinateSystem coordinateSystem;
    private final EnumMap<AxesConvention, AbstractCRS> forConvention;

    private EnumMap<AxesConvention, AbstractCRS> forConvention() {
        EnumMap<AxesConvention, AbstractCRS> m = new EnumMap<AxesConvention, AbstractCRS>(AxesConvention.class);
        m.put(AxesConvention.ORIGINAL, this);
        return m;
    }

    public AbstractCRS(Map<String, ?> properties, CoordinateSystem cs) {
        super(properties);
        this.coordinateSystem = Objects.requireNonNull(cs);
        this.forConvention = this.forConvention();
    }

    static void checkDimension(int min, int max, CoordinateSystem cs) {
        int expected;
        int actual = cs.getDimension();
        if (actual < min) {
            expected = min;
        } else if (actual > max) {
            expected = max;
        } else {
            return;
        }
        throw new MismatchedDimensionException(Errors.format((short)101, (Object)"cs", (Object)expected, (Object)actual));
    }

    AbstractCRS(AbstractCRS original, ReferenceIdentifier id, AbstractCS cs) {
        super(ReferencingUtilities.getPropertiesWithoutIdentifiers(original, id == null ? null : Map.of("identifiers", id)));
        this.coordinateSystem = cs;
        this.forConvention = cs.hasSameAxes(original.coordinateSystem) ? original.forConvention : original.forConvention();
    }

    protected AbstractCRS(CoordinateReferenceSystem crs) {
        super((ReferenceSystem)crs);
        this.coordinateSystem = crs.getCoordinateSystem();
        if (this.coordinateSystem == null) {
            throw new IllegalArgumentException(Errors.format((short)111, (Object)"coordinateSystem"));
        }
        this.forConvention = this.forConvention();
    }

    public static AbstractCRS castOrCopy(CoordinateReferenceSystem object) {
        return SubTypes.castOrCopy(object);
    }

    public Class<? extends CoordinateReferenceSystem> getInterface() {
        return CoordinateReferenceSystem.class;
    }

    static DefaultDatumEnsemble<?> getDatumEnsemble(CoordinateReferenceSystem crs) {
        return crs instanceof AbstractCRS ? ((AbstractCRS)crs).getDatumEnsemble() : null;
    }

    DefaultDatumEnsemble<?> getDatumEnsemble() {
        return null;
    }

    public CoordinateSystem getCoordinateSystem() {
        return this.coordinateSystem;
    }

    final <T extends CoordinateSystem> T getCoordinateSystem(Class<T> type) {
        CoordinateSystem cs = this.coordinateSystem;
        if (type.isInstance(cs) && (type != AffineCS.class || !(cs instanceof CartesianCS))) {
            return (T)cs;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final AbstractCRS getCached(AxesConvention convention) {
        EnumMap<AxesConvention, AbstractCRS> enumMap = this.forConvention;
        synchronized (enumMap) {
            return this.forConvention.get(convention);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final AbstractCRS setCached(AxesConvention convention, AbstractCRS crs) {
        EnumMap<AxesConvention, AbstractCRS> enumMap = this.forConvention;
        synchronized (enumMap) {
            return this.forConvention.computeIfAbsent(convention, c -> {
                for (AbstractCRS existing : this.forConvention.values()) {
                    if (!crs.equals(existing, ComparisonMode.IGNORE_METADATA)) continue;
                    return existing;
                }
                return crs;
            });
        }
    }

    public AbstractCRS forConvention(AxesConvention convention) {
        AbstractCRS crs = this.getCached(Objects.requireNonNull(convention));
        if (crs == null) {
            AbstractCS cs = AbstractCS.castOrCopy(this.coordinateSystem);
            AbstractCS candidate = cs.forConvention(convention);
            if (candidate.equals(cs, ComparisonMode.IGNORE_METADATA)) {
                crs = this;
            } else {
                try {
                    crs = this.createSameType(candidate);
                    crs.getCoordinateSystem();
                }
                catch (ClassCastException e) {
                    throw new IllegalArgumentException(Errors.format((short)9, (Object)convention), e);
                }
            }
            crs = this.setCached(convention, crs);
        }
        return crs;
    }

    AbstractCRS createSameType(AbstractCS cs) {
        return new AbstractCRS(this, null, cs);
    }

    @Override
    public boolean equals(Object object, ComparisonMode mode) {
        if (super.equals(object, mode)) {
            switch (mode) {
                case STRICT: {
                    AbstractCRS that = (AbstractCRS)object;
                    return Objects.equals(this.coordinateSystem, that.coordinateSystem);
                }
            }
            CoordinateReferenceSystem that = (CoordinateReferenceSystem)object;
            return Utilities.deepEquals((Object)this.getCoordinateSystem(), (Object)that.getCoordinateSystem(), (ComparisonMode)mode);
        }
        return false;
    }

    @Override
    protected long computeHashCode() {
        return super.computeHashCode() + (long)this.coordinateSystem.hashCode();
    }

    @Override
    protected String formatTo(Formatter formatter) {
        boolean isWKT1;
        String keyword = super.formatTo(formatter);
        formatter.newLine();
        this.formatDatum(formatter);
        formatter.newLine();
        Convention convention = formatter.getConvention();
        boolean bl = isWKT1 = convention.majorVersion() == 1;
        if (isWKT1 || convention == Convention.INTERNAL || !AbstractCRS.isBaseCRS(formatter)) {
            CoordinateSystem cs = this.getCoordinateSystem();
            this.formatCS(formatter, cs, ReferencingUtilities.getUnit(cs), isWKT1);
        }
        return keyword;
    }

    void formatDatum(Formatter formatter) {
        if (this instanceof SingleCRS) {
            SingleCRS sc = (SingleCRS)this;
            AbstractCRS.formatDatum(formatter, sc, sc.getDatum(), AbstractDatum::castOrCopy, AbstractCRS::getDatumEnsemble);
        }
    }

    static <C extends SingleCRS, D extends Datum> void formatDatum(Formatter formatter, C crs, D datum, Function<D, FormattableObject> toFormattable, Function<C, D> asDatum) {
        boolean supportsDynamic = formatter.getConvention().supports(Convention.WKT2_2019);
        if (datum != null) {
            if (supportsDynamic) {
                formatter.append(DynamicCRS.createIfDynamic(datum));
                formatter.newLine();
            }
            formatter.appendFormattable(datum, toFormattable);
        } else if (supportsDynamic) {
            formatter.append(AbstractCRS.getDatumEnsemble(crs));
        } else {
            formatter.append(toFormattable.apply((Datum)asDatum.apply(crs)));
        }
    }

    static boolean isBaseCRS(Formatter formatter) {
        return formatter.getEnclosingElement(1) instanceof GeneralDerivedCRS;
    }

    final void formatCS(Formatter formatter, CoordinateSystem cs, Unit<?> unit, boolean isWKT1) {
        assert (unit == ReferencingUtilities.getUnit(cs)) : unit;
        assert (formatter.getConvention().majorVersion() == 1 == isWKT1) : isWKT1;
        assert (isWKT1 || !AbstractCRS.isBaseCRS(formatter) || formatter.getConvention() == Convention.INTERNAL);
        Unit<?> oldUnit = formatter.addContextualUnit(unit);
        if (isWKT1) {
            formatter.append(unit);
            if (unit == null) {
                formatter.setInvalidWKT(this, null);
            }
        } else {
            formatter.appendFormattable(cs, AbstractCS::castOrCopy);
            formatter.indent(1);
        }
        if (!(isWKT1 && formatter.getConvention() == Convention.WKT1_IGNORE_AXES || cs == null)) {
            int dimension = cs.getDimension();
            for (int i = 0; i < dimension; ++i) {
                formatter.newLine();
                formatter.appendFormattable(cs.getAxis(i), DefaultCoordinateSystemAxis::castOrCopy);
            }
        }
        if (!isWKT1) {
            formatter.newLine();
            formatter.append(unit);
            formatter.indent(-1);
        }
        formatter.restoreContextualUnit(unit, oldUnit);
        formatter.newLine();
    }

    AbstractCRS() {
        super(NilReferencingObject.INSTANCE);
        this.forConvention = this.forConvention();
    }

    final void setCoordinateSystem(String name, CoordinateSystem cs) {
        if (this.coordinateSystem == null) {
            this.coordinateSystem = cs;
        } else {
            if (name == null) {
                name = String.valueOf(ReferencingUtilities.toPropertyName(CoordinateSystem.class, cs.getClass()));
            }
            ImplementationHelper.propertyAlreadySet(AbstractCRS.class, (String)"setCoordinateSystem", (String)name);
        }
    }

    static {
        MissingMethods.datumEnsemble = AbstractCRS::getDatumEnsemble;
    }
}

