/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.foundation.common.utils;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.function.Supplier;
import org.apache.servicecomb.foundation.common.exceptions.ServiceCombException;

public final class AsyncUtils {
    private AsyncUtils() {
    }

    public static <T> CompletableFuture<T> tryCatchSupplier(Supplier<T> supplier) {
        try {
            T value = supplier.get();
            return CompletableFuture.completedFuture(value);
        }
        catch (Throwable e) {
            return AsyncUtils.completeExceptionally(e);
        }
    }

    public static <T> CompletableFuture<T> tryCatchSupplierFuture(Supplier<CompletableFuture<T>> supplier) {
        try {
            return supplier.get();
        }
        catch (Throwable e) {
            return AsyncUtils.completeExceptionally(e);
        }
    }

    public static <T> CompletableFuture<T> completeExceptionally(Throwable throwable) {
        CompletableFuture future = new CompletableFuture();
        future.completeExceptionally(throwable);
        return future;
    }

    public static RuntimeException rethrow(Throwable exception) {
        if (exception instanceof RuntimeException) {
            return (RuntimeException)exception;
        }
        return new ServiceCombException("Not declared exception", exception);
    }

    public static <T> T toSync(CompletableFuture<T> future) {
        try {
            return future.get();
        }
        catch (ExecutionException executionException) {
            throw AsyncUtils.rethrow(executionException.getCause());
        }
        catch (Throwable e) {
            throw AsyncUtils.rethrow(e);
        }
    }
}

