/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.foundation.vertx.executor;

import io.vertx.core.Context;
import io.vertx.core.Vertx;
import java.util.concurrent.Executor;

public class VertxContextExecutor
implements Executor {
    private final Context context;

    public static VertxContextExecutor create(Vertx vertx) {
        return new VertxContextExecutor(vertx.getOrCreateContext());
    }

    public static VertxContextExecutor create(Context context) {
        return new VertxContextExecutor(context);
    }

    private VertxContextExecutor(Context context) {
        this.context = context;
    }

    @Override
    public void execute(Runnable command) {
        if (this.context == Vertx.currentContext()) {
            command.run();
            return;
        }
        this.context.runOnContext(v -> command.run());
    }
}

