/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.client.java.impl.consumer;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import org.apache.rocketmq.client.apis.consumer.ConsumeResult;
import org.apache.rocketmq.client.apis.consumer.MessageListener;
import org.apache.rocketmq.client.apis.message.MessageView;
import org.apache.rocketmq.client.java.hook.Attribute;
import org.apache.rocketmq.client.java.hook.AttributeKey;
import org.apache.rocketmq.client.java.hook.MessageHookPoints;
import org.apache.rocketmq.client.java.hook.MessageHookPointsStatus;
import org.apache.rocketmq.client.java.hook.MessageInterceptor;
import org.apache.rocketmq.client.java.hook.MessageInterceptorContextImpl;
import org.apache.rocketmq.client.java.message.GeneralMessage;
import org.apache.rocketmq.client.java.message.GeneralMessageImpl;
import org.apache.rocketmq.client.java.message.MessageViewImpl;
import org.apache.rocketmq.client.java.misc.ClientId;
import org.apache.rocketmq.client.java.rpc.LoggingInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsumeTask
implements Callable<ConsumeResult> {
    static final AttributeKey<MessageViewImpl> MESSAGE_VIEW_CONTEXT_KEY = AttributeKey.create("messageView");
    static final AttributeKey<String> REMOTE_ADDR_CONTEXT_KEY = AttributeKey.create("remoteAddr");
    static final AttributeKey<Throwable> CONSUME_ERROR_CONTEXT_KEY = AttributeKey.create("consumeError");
    private static final Logger log = LoggerFactory.getLogger(ConsumeTask.class);
    private final ClientId clientId;
    private final MessageListener messageListener;
    private final MessageViewImpl messageView;
    private final MessageInterceptor messageInterceptor;

    public ConsumeTask(ClientId clientId, MessageListener messageListener, MessageViewImpl messageView, MessageInterceptor messageInterceptor) {
        this.clientId = clientId;
        this.messageListener = messageListener;
        this.messageView = messageView;
        this.messageInterceptor = messageInterceptor;
    }

    @Override
    public ConsumeResult call() {
        ConsumeResult consumeResult;
        List<GeneralMessage> generalMessages = Collections.singletonList(new GeneralMessageImpl(this.messageView));
        MessageInterceptorContextImpl context = new MessageInterceptorContextImpl(MessageHookPoints.CONSUME);
        String remoteAddr = LoggingInterceptor.getInstance().getRemoteAddr();
        context.putAttribute(REMOTE_ADDR_CONTEXT_KEY, Attribute.create(remoteAddr));
        context.putAttribute(MESSAGE_VIEW_CONTEXT_KEY, Attribute.create(this.messageView));
        this.messageInterceptor.doBefore(context, generalMessages);
        Throwable throwable = null;
        try {
            consumeResult = this.messageListener.consume((MessageView)this.messageView);
        }
        catch (Throwable t) {
            log.error("Message listener raised an exception while consuming messages, clientId={}, mq={}, messageId={}", new Object[]{this.clientId, this.messageView.getMessageQueue(), this.messageView.getMessageId(), t});
            consumeResult = ConsumeResult.FAILURE;
            throwable = t;
        }
        MessageHookPointsStatus status = ConsumeResult.SUCCESS.equals((Object)consumeResult) ? MessageHookPointsStatus.OK : MessageHookPointsStatus.ERROR;
        context = new MessageInterceptorContextImpl(context, status);
        if (!ConsumeResult.SUCCESS.equals((Object)consumeResult) && null != throwable) {
            context.putAttribute(CONSUME_ERROR_CONTEXT_KEY, Attribute.create(throwable));
        }
        this.messageInterceptor.doAfter(context, generalMessages);
        return consumeResult;
    }
}

