/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.client.java.impl.consumer;

import java.time.Duration;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.rocketmq.client.apis.ClientConfiguration;
import org.apache.rocketmq.client.apis.ClientException;
import org.apache.rocketmq.client.apis.consumer.FilterExpression;
import org.apache.rocketmq.client.apis.consumer.SimpleConsumer;
import org.apache.rocketmq.client.apis.consumer.SimpleConsumerBuilder;
import org.apache.rocketmq.client.java.impl.consumer.ConsumerImpl;
import org.apache.rocketmq.client.java.impl.consumer.SimpleConsumerImpl;
import org.apache.rocketmq.shaded.com.google.common.base.Preconditions;

public class SimpleConsumerBuilderImpl
implements SimpleConsumerBuilder {
    private ClientConfiguration clientConfiguration = null;
    private String consumerGroup = null;
    private Map<String, FilterExpression> subscriptionExpressions = new ConcurrentHashMap<String, FilterExpression>();
    private Duration awaitDuration = null;

    @Override
    public SimpleConsumerBuilder setClientConfiguration(ClientConfiguration clientConfiguration) {
        this.clientConfiguration = Preconditions.checkNotNull(clientConfiguration, "clientConfiguration should not be null");
        return this;
    }

    @Override
    public SimpleConsumerBuilder setConsumerGroup(String consumerGroup) {
        Preconditions.checkNotNull(consumerGroup, "consumerGroup should not be null");
        Preconditions.checkArgument(ConsumerImpl.CONSUMER_GROUP_PATTERN.matcher(consumerGroup).matches(), "consumerGroup does not match the regex [regex=%s]", (Object)ConsumerImpl.CONSUMER_GROUP_PATTERN.pattern());
        this.consumerGroup = consumerGroup;
        return this;
    }

    @Override
    public SimpleConsumerBuilder setSubscriptionExpressions(Map<String, FilterExpression> subscriptionExpressions) {
        Preconditions.checkNotNull(subscriptionExpressions, "subscriptionExpressions should not be null");
        Preconditions.checkArgument(!subscriptionExpressions.isEmpty(), "subscriptionExpressions should not be empty");
        this.subscriptionExpressions = subscriptionExpressions;
        return this;
    }

    @Override
    public SimpleConsumerBuilder setAwaitDuration(Duration awaitDuration) {
        this.awaitDuration = Preconditions.checkNotNull(awaitDuration, "awaitDuration should not be null");
        return this;
    }

    @Override
    public SimpleConsumer build() throws ClientException {
        Preconditions.checkNotNull(this.clientConfiguration, "clientConfiguration has not been set yet");
        Preconditions.checkNotNull(this.consumerGroup, "consumerGroup has not been set yet");
        Preconditions.checkArgument(!this.subscriptionExpressions.isEmpty(), "subscriptionExpressions have not been set yet");
        Preconditions.checkNotNull(this.awaitDuration, "awaitDuration has not been set yet");
        SimpleConsumerImpl consumer = new SimpleConsumerImpl(this.clientConfiguration, this.consumerGroup, this.awaitDuration, this.subscriptionExpressions);
        consumer.startAsync().awaitRunning();
        return consumer;
    }
}

