/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.opcua.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class SessionDiagnosticsDataType extends ExtensionObjectDefinition implements Message {

  // Accessors for discriminator values.
  public Integer getExtensionId() {
    return (int) 867;
  }

  // Properties.
  protected final NodeId sessionId;
  protected final PascalString sessionName;
  protected final ApplicationDescription clientDescription;
  protected final PascalString serverUri;
  protected final PascalString endpointUrl;
  protected final List<PascalString> localeIds;
  protected final double actualSessionTimeout;
  protected final long maxResponseMessageSize;
  protected final long clientConnectionTime;
  protected final long clientLastContactTime;
  protected final long currentSubscriptionsCount;
  protected final long currentMonitoredItemsCount;
  protected final long currentPublishRequestsInQueue;
  protected final ServiceCounterDataType totalRequestCount;
  protected final long unauthorizedRequestCount;
  protected final ServiceCounterDataType readCount;
  protected final ServiceCounterDataType historyReadCount;
  protected final ServiceCounterDataType writeCount;
  protected final ServiceCounterDataType historyUpdateCount;
  protected final ServiceCounterDataType callCount;
  protected final ServiceCounterDataType createMonitoredItemsCount;
  protected final ServiceCounterDataType modifyMonitoredItemsCount;
  protected final ServiceCounterDataType setMonitoringModeCount;
  protected final ServiceCounterDataType setTriggeringCount;
  protected final ServiceCounterDataType deleteMonitoredItemsCount;
  protected final ServiceCounterDataType createSubscriptionCount;
  protected final ServiceCounterDataType modifySubscriptionCount;
  protected final ServiceCounterDataType setPublishingModeCount;
  protected final ServiceCounterDataType publishCount;
  protected final ServiceCounterDataType republishCount;
  protected final ServiceCounterDataType transferSubscriptionsCount;
  protected final ServiceCounterDataType deleteSubscriptionsCount;
  protected final ServiceCounterDataType addNodesCount;
  protected final ServiceCounterDataType addReferencesCount;
  protected final ServiceCounterDataType deleteNodesCount;
  protected final ServiceCounterDataType deleteReferencesCount;
  protected final ServiceCounterDataType browseCount;
  protected final ServiceCounterDataType browseNextCount;
  protected final ServiceCounterDataType translateBrowsePathsToNodeIdsCount;
  protected final ServiceCounterDataType queryFirstCount;
  protected final ServiceCounterDataType queryNextCount;
  protected final ServiceCounterDataType registerNodesCount;
  protected final ServiceCounterDataType unregisterNodesCount;

  public SessionDiagnosticsDataType(
      NodeId sessionId,
      PascalString sessionName,
      ApplicationDescription clientDescription,
      PascalString serverUri,
      PascalString endpointUrl,
      List<PascalString> localeIds,
      double actualSessionTimeout,
      long maxResponseMessageSize,
      long clientConnectionTime,
      long clientLastContactTime,
      long currentSubscriptionsCount,
      long currentMonitoredItemsCount,
      long currentPublishRequestsInQueue,
      ServiceCounterDataType totalRequestCount,
      long unauthorizedRequestCount,
      ServiceCounterDataType readCount,
      ServiceCounterDataType historyReadCount,
      ServiceCounterDataType writeCount,
      ServiceCounterDataType historyUpdateCount,
      ServiceCounterDataType callCount,
      ServiceCounterDataType createMonitoredItemsCount,
      ServiceCounterDataType modifyMonitoredItemsCount,
      ServiceCounterDataType setMonitoringModeCount,
      ServiceCounterDataType setTriggeringCount,
      ServiceCounterDataType deleteMonitoredItemsCount,
      ServiceCounterDataType createSubscriptionCount,
      ServiceCounterDataType modifySubscriptionCount,
      ServiceCounterDataType setPublishingModeCount,
      ServiceCounterDataType publishCount,
      ServiceCounterDataType republishCount,
      ServiceCounterDataType transferSubscriptionsCount,
      ServiceCounterDataType deleteSubscriptionsCount,
      ServiceCounterDataType addNodesCount,
      ServiceCounterDataType addReferencesCount,
      ServiceCounterDataType deleteNodesCount,
      ServiceCounterDataType deleteReferencesCount,
      ServiceCounterDataType browseCount,
      ServiceCounterDataType browseNextCount,
      ServiceCounterDataType translateBrowsePathsToNodeIdsCount,
      ServiceCounterDataType queryFirstCount,
      ServiceCounterDataType queryNextCount,
      ServiceCounterDataType registerNodesCount,
      ServiceCounterDataType unregisterNodesCount) {
    super();
    this.sessionId = sessionId;
    this.sessionName = sessionName;
    this.clientDescription = clientDescription;
    this.serverUri = serverUri;
    this.endpointUrl = endpointUrl;
    this.localeIds = localeIds;
    this.actualSessionTimeout = actualSessionTimeout;
    this.maxResponseMessageSize = maxResponseMessageSize;
    this.clientConnectionTime = clientConnectionTime;
    this.clientLastContactTime = clientLastContactTime;
    this.currentSubscriptionsCount = currentSubscriptionsCount;
    this.currentMonitoredItemsCount = currentMonitoredItemsCount;
    this.currentPublishRequestsInQueue = currentPublishRequestsInQueue;
    this.totalRequestCount = totalRequestCount;
    this.unauthorizedRequestCount = unauthorizedRequestCount;
    this.readCount = readCount;
    this.historyReadCount = historyReadCount;
    this.writeCount = writeCount;
    this.historyUpdateCount = historyUpdateCount;
    this.callCount = callCount;
    this.createMonitoredItemsCount = createMonitoredItemsCount;
    this.modifyMonitoredItemsCount = modifyMonitoredItemsCount;
    this.setMonitoringModeCount = setMonitoringModeCount;
    this.setTriggeringCount = setTriggeringCount;
    this.deleteMonitoredItemsCount = deleteMonitoredItemsCount;
    this.createSubscriptionCount = createSubscriptionCount;
    this.modifySubscriptionCount = modifySubscriptionCount;
    this.setPublishingModeCount = setPublishingModeCount;
    this.publishCount = publishCount;
    this.republishCount = republishCount;
    this.transferSubscriptionsCount = transferSubscriptionsCount;
    this.deleteSubscriptionsCount = deleteSubscriptionsCount;
    this.addNodesCount = addNodesCount;
    this.addReferencesCount = addReferencesCount;
    this.deleteNodesCount = deleteNodesCount;
    this.deleteReferencesCount = deleteReferencesCount;
    this.browseCount = browseCount;
    this.browseNextCount = browseNextCount;
    this.translateBrowsePathsToNodeIdsCount = translateBrowsePathsToNodeIdsCount;
    this.queryFirstCount = queryFirstCount;
    this.queryNextCount = queryNextCount;
    this.registerNodesCount = registerNodesCount;
    this.unregisterNodesCount = unregisterNodesCount;
  }

  public NodeId getSessionId() {
    return sessionId;
  }

  public PascalString getSessionName() {
    return sessionName;
  }

  public ApplicationDescription getClientDescription() {
    return clientDescription;
  }

  public PascalString getServerUri() {
    return serverUri;
  }

  public PascalString getEndpointUrl() {
    return endpointUrl;
  }

  public List<PascalString> getLocaleIds() {
    return localeIds;
  }

  public double getActualSessionTimeout() {
    return actualSessionTimeout;
  }

  public long getMaxResponseMessageSize() {
    return maxResponseMessageSize;
  }

  public long getClientConnectionTime() {
    return clientConnectionTime;
  }

  public long getClientLastContactTime() {
    return clientLastContactTime;
  }

  public long getCurrentSubscriptionsCount() {
    return currentSubscriptionsCount;
  }

  public long getCurrentMonitoredItemsCount() {
    return currentMonitoredItemsCount;
  }

  public long getCurrentPublishRequestsInQueue() {
    return currentPublishRequestsInQueue;
  }

  public ServiceCounterDataType getTotalRequestCount() {
    return totalRequestCount;
  }

  public long getUnauthorizedRequestCount() {
    return unauthorizedRequestCount;
  }

  public ServiceCounterDataType getReadCount() {
    return readCount;
  }

  public ServiceCounterDataType getHistoryReadCount() {
    return historyReadCount;
  }

  public ServiceCounterDataType getWriteCount() {
    return writeCount;
  }

  public ServiceCounterDataType getHistoryUpdateCount() {
    return historyUpdateCount;
  }

  public ServiceCounterDataType getCallCount() {
    return callCount;
  }

  public ServiceCounterDataType getCreateMonitoredItemsCount() {
    return createMonitoredItemsCount;
  }

  public ServiceCounterDataType getModifyMonitoredItemsCount() {
    return modifyMonitoredItemsCount;
  }

  public ServiceCounterDataType getSetMonitoringModeCount() {
    return setMonitoringModeCount;
  }

  public ServiceCounterDataType getSetTriggeringCount() {
    return setTriggeringCount;
  }

  public ServiceCounterDataType getDeleteMonitoredItemsCount() {
    return deleteMonitoredItemsCount;
  }

  public ServiceCounterDataType getCreateSubscriptionCount() {
    return createSubscriptionCount;
  }

  public ServiceCounterDataType getModifySubscriptionCount() {
    return modifySubscriptionCount;
  }

  public ServiceCounterDataType getSetPublishingModeCount() {
    return setPublishingModeCount;
  }

  public ServiceCounterDataType getPublishCount() {
    return publishCount;
  }

  public ServiceCounterDataType getRepublishCount() {
    return republishCount;
  }

  public ServiceCounterDataType getTransferSubscriptionsCount() {
    return transferSubscriptionsCount;
  }

  public ServiceCounterDataType getDeleteSubscriptionsCount() {
    return deleteSubscriptionsCount;
  }

  public ServiceCounterDataType getAddNodesCount() {
    return addNodesCount;
  }

  public ServiceCounterDataType getAddReferencesCount() {
    return addReferencesCount;
  }

  public ServiceCounterDataType getDeleteNodesCount() {
    return deleteNodesCount;
  }

  public ServiceCounterDataType getDeleteReferencesCount() {
    return deleteReferencesCount;
  }

  public ServiceCounterDataType getBrowseCount() {
    return browseCount;
  }

  public ServiceCounterDataType getBrowseNextCount() {
    return browseNextCount;
  }

  public ServiceCounterDataType getTranslateBrowsePathsToNodeIdsCount() {
    return translateBrowsePathsToNodeIdsCount;
  }

  public ServiceCounterDataType getQueryFirstCount() {
    return queryFirstCount;
  }

  public ServiceCounterDataType getQueryNextCount() {
    return queryNextCount;
  }

  public ServiceCounterDataType getRegisterNodesCount() {
    return registerNodesCount;
  }

  public ServiceCounterDataType getUnregisterNodesCount() {
    return unregisterNodesCount;
  }

  @Override
  protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer)
      throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("SessionDiagnosticsDataType");

    // Simple Field (sessionId)
    writeSimpleField("sessionId", sessionId, writeComplex(writeBuffer));

    // Simple Field (sessionName)
    writeSimpleField("sessionName", sessionName, writeComplex(writeBuffer));

    // Simple Field (clientDescription)
    writeSimpleField("clientDescription", clientDescription, writeComplex(writeBuffer));

    // Simple Field (serverUri)
    writeSimpleField("serverUri", serverUri, writeComplex(writeBuffer));

    // Simple Field (endpointUrl)
    writeSimpleField("endpointUrl", endpointUrl, writeComplex(writeBuffer));

    // Implicit Field (noOfLocaleIds) (Used for parsing, but its value is not stored as it's
    // implicitly given by the objects content)
    int noOfLocaleIds = (int) ((((getLocaleIds()) == (null)) ? -(1) : COUNT(getLocaleIds())));
    writeImplicitField("noOfLocaleIds", noOfLocaleIds, writeSignedInt(writeBuffer, 32));

    // Array Field (localeIds)
    writeComplexTypeArrayField("localeIds", localeIds, writeBuffer);

    // Simple Field (actualSessionTimeout)
    writeSimpleField("actualSessionTimeout", actualSessionTimeout, writeDouble(writeBuffer, 64));

    // Simple Field (maxResponseMessageSize)
    writeSimpleField(
        "maxResponseMessageSize", maxResponseMessageSize, writeUnsignedLong(writeBuffer, 32));

    // Simple Field (clientConnectionTime)
    writeSimpleField(
        "clientConnectionTime", clientConnectionTime, writeSignedLong(writeBuffer, 64));

    // Simple Field (clientLastContactTime)
    writeSimpleField(
        "clientLastContactTime", clientLastContactTime, writeSignedLong(writeBuffer, 64));

    // Simple Field (currentSubscriptionsCount)
    writeSimpleField(
        "currentSubscriptionsCount", currentSubscriptionsCount, writeUnsignedLong(writeBuffer, 32));

    // Simple Field (currentMonitoredItemsCount)
    writeSimpleField(
        "currentMonitoredItemsCount",
        currentMonitoredItemsCount,
        writeUnsignedLong(writeBuffer, 32));

    // Simple Field (currentPublishRequestsInQueue)
    writeSimpleField(
        "currentPublishRequestsInQueue",
        currentPublishRequestsInQueue,
        writeUnsignedLong(writeBuffer, 32));

    // Simple Field (totalRequestCount)
    writeSimpleField("totalRequestCount", totalRequestCount, writeComplex(writeBuffer));

    // Simple Field (unauthorizedRequestCount)
    writeSimpleField(
        "unauthorizedRequestCount", unauthorizedRequestCount, writeUnsignedLong(writeBuffer, 32));

    // Simple Field (readCount)
    writeSimpleField("readCount", readCount, writeComplex(writeBuffer));

    // Simple Field (historyReadCount)
    writeSimpleField("historyReadCount", historyReadCount, writeComplex(writeBuffer));

    // Simple Field (writeCount)
    writeSimpleField("writeCount", writeCount, writeComplex(writeBuffer));

    // Simple Field (historyUpdateCount)
    writeSimpleField("historyUpdateCount", historyUpdateCount, writeComplex(writeBuffer));

    // Simple Field (callCount)
    writeSimpleField("callCount", callCount, writeComplex(writeBuffer));

    // Simple Field (createMonitoredItemsCount)
    writeSimpleField(
        "createMonitoredItemsCount", createMonitoredItemsCount, writeComplex(writeBuffer));

    // Simple Field (modifyMonitoredItemsCount)
    writeSimpleField(
        "modifyMonitoredItemsCount", modifyMonitoredItemsCount, writeComplex(writeBuffer));

    // Simple Field (setMonitoringModeCount)
    writeSimpleField("setMonitoringModeCount", setMonitoringModeCount, writeComplex(writeBuffer));

    // Simple Field (setTriggeringCount)
    writeSimpleField("setTriggeringCount", setTriggeringCount, writeComplex(writeBuffer));

    // Simple Field (deleteMonitoredItemsCount)
    writeSimpleField(
        "deleteMonitoredItemsCount", deleteMonitoredItemsCount, writeComplex(writeBuffer));

    // Simple Field (createSubscriptionCount)
    writeSimpleField("createSubscriptionCount", createSubscriptionCount, writeComplex(writeBuffer));

    // Simple Field (modifySubscriptionCount)
    writeSimpleField("modifySubscriptionCount", modifySubscriptionCount, writeComplex(writeBuffer));

    // Simple Field (setPublishingModeCount)
    writeSimpleField("setPublishingModeCount", setPublishingModeCount, writeComplex(writeBuffer));

    // Simple Field (publishCount)
    writeSimpleField("publishCount", publishCount, writeComplex(writeBuffer));

    // Simple Field (republishCount)
    writeSimpleField("republishCount", republishCount, writeComplex(writeBuffer));

    // Simple Field (transferSubscriptionsCount)
    writeSimpleField(
        "transferSubscriptionsCount", transferSubscriptionsCount, writeComplex(writeBuffer));

    // Simple Field (deleteSubscriptionsCount)
    writeSimpleField(
        "deleteSubscriptionsCount", deleteSubscriptionsCount, writeComplex(writeBuffer));

    // Simple Field (addNodesCount)
    writeSimpleField("addNodesCount", addNodesCount, writeComplex(writeBuffer));

    // Simple Field (addReferencesCount)
    writeSimpleField("addReferencesCount", addReferencesCount, writeComplex(writeBuffer));

    // Simple Field (deleteNodesCount)
    writeSimpleField("deleteNodesCount", deleteNodesCount, writeComplex(writeBuffer));

    // Simple Field (deleteReferencesCount)
    writeSimpleField("deleteReferencesCount", deleteReferencesCount, writeComplex(writeBuffer));

    // Simple Field (browseCount)
    writeSimpleField("browseCount", browseCount, writeComplex(writeBuffer));

    // Simple Field (browseNextCount)
    writeSimpleField("browseNextCount", browseNextCount, writeComplex(writeBuffer));

    // Simple Field (translateBrowsePathsToNodeIdsCount)
    writeSimpleField(
        "translateBrowsePathsToNodeIdsCount",
        translateBrowsePathsToNodeIdsCount,
        writeComplex(writeBuffer));

    // Simple Field (queryFirstCount)
    writeSimpleField("queryFirstCount", queryFirstCount, writeComplex(writeBuffer));

    // Simple Field (queryNextCount)
    writeSimpleField("queryNextCount", queryNextCount, writeComplex(writeBuffer));

    // Simple Field (registerNodesCount)
    writeSimpleField("registerNodesCount", registerNodesCount, writeComplex(writeBuffer));

    // Simple Field (unregisterNodesCount)
    writeSimpleField("unregisterNodesCount", unregisterNodesCount, writeComplex(writeBuffer));

    writeBuffer.popContext("SessionDiagnosticsDataType");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    SessionDiagnosticsDataType _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (sessionId)
    lengthInBits += sessionId.getLengthInBits();

    // Simple field (sessionName)
    lengthInBits += sessionName.getLengthInBits();

    // Simple field (clientDescription)
    lengthInBits += clientDescription.getLengthInBits();

    // Simple field (serverUri)
    lengthInBits += serverUri.getLengthInBits();

    // Simple field (endpointUrl)
    lengthInBits += endpointUrl.getLengthInBits();

    // Implicit Field (noOfLocaleIds)
    lengthInBits += 32;

    // Array field
    if (localeIds != null) {
      int i = 0;
      for (PascalString element : localeIds) {
        ThreadLocalHelper.lastItemThreadLocal.set(++i >= localeIds.size());
        lengthInBits += element.getLengthInBits();
      }
    }

    // Simple field (actualSessionTimeout)
    lengthInBits += 64;

    // Simple field (maxResponseMessageSize)
    lengthInBits += 32;

    // Simple field (clientConnectionTime)
    lengthInBits += 64;

    // Simple field (clientLastContactTime)
    lengthInBits += 64;

    // Simple field (currentSubscriptionsCount)
    lengthInBits += 32;

    // Simple field (currentMonitoredItemsCount)
    lengthInBits += 32;

    // Simple field (currentPublishRequestsInQueue)
    lengthInBits += 32;

    // Simple field (totalRequestCount)
    lengthInBits += totalRequestCount.getLengthInBits();

    // Simple field (unauthorizedRequestCount)
    lengthInBits += 32;

    // Simple field (readCount)
    lengthInBits += readCount.getLengthInBits();

    // Simple field (historyReadCount)
    lengthInBits += historyReadCount.getLengthInBits();

    // Simple field (writeCount)
    lengthInBits += writeCount.getLengthInBits();

    // Simple field (historyUpdateCount)
    lengthInBits += historyUpdateCount.getLengthInBits();

    // Simple field (callCount)
    lengthInBits += callCount.getLengthInBits();

    // Simple field (createMonitoredItemsCount)
    lengthInBits += createMonitoredItemsCount.getLengthInBits();

    // Simple field (modifyMonitoredItemsCount)
    lengthInBits += modifyMonitoredItemsCount.getLengthInBits();

    // Simple field (setMonitoringModeCount)
    lengthInBits += setMonitoringModeCount.getLengthInBits();

    // Simple field (setTriggeringCount)
    lengthInBits += setTriggeringCount.getLengthInBits();

    // Simple field (deleteMonitoredItemsCount)
    lengthInBits += deleteMonitoredItemsCount.getLengthInBits();

    // Simple field (createSubscriptionCount)
    lengthInBits += createSubscriptionCount.getLengthInBits();

    // Simple field (modifySubscriptionCount)
    lengthInBits += modifySubscriptionCount.getLengthInBits();

    // Simple field (setPublishingModeCount)
    lengthInBits += setPublishingModeCount.getLengthInBits();

    // Simple field (publishCount)
    lengthInBits += publishCount.getLengthInBits();

    // Simple field (republishCount)
    lengthInBits += republishCount.getLengthInBits();

    // Simple field (transferSubscriptionsCount)
    lengthInBits += transferSubscriptionsCount.getLengthInBits();

    // Simple field (deleteSubscriptionsCount)
    lengthInBits += deleteSubscriptionsCount.getLengthInBits();

    // Simple field (addNodesCount)
    lengthInBits += addNodesCount.getLengthInBits();

    // Simple field (addReferencesCount)
    lengthInBits += addReferencesCount.getLengthInBits();

    // Simple field (deleteNodesCount)
    lengthInBits += deleteNodesCount.getLengthInBits();

    // Simple field (deleteReferencesCount)
    lengthInBits += deleteReferencesCount.getLengthInBits();

    // Simple field (browseCount)
    lengthInBits += browseCount.getLengthInBits();

    // Simple field (browseNextCount)
    lengthInBits += browseNextCount.getLengthInBits();

    // Simple field (translateBrowsePathsToNodeIdsCount)
    lengthInBits += translateBrowsePathsToNodeIdsCount.getLengthInBits();

    // Simple field (queryFirstCount)
    lengthInBits += queryFirstCount.getLengthInBits();

    // Simple field (queryNextCount)
    lengthInBits += queryNextCount.getLengthInBits();

    // Simple field (registerNodesCount)
    lengthInBits += registerNodesCount.getLengthInBits();

    // Simple field (unregisterNodesCount)
    lengthInBits += unregisterNodesCount.getLengthInBits();

    return lengthInBits;
  }

  public static ExtensionObjectDefinitionBuilder staticParseExtensionObjectDefinitionBuilder(
      ReadBuffer readBuffer, Integer extensionId) throws ParseException {
    readBuffer.pullContext("SessionDiagnosticsDataType");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    NodeId sessionId =
        readSimpleField("sessionId", readComplex(() -> NodeId.staticParse(readBuffer), readBuffer));

    PascalString sessionName =
        readSimpleField(
            "sessionName", readComplex(() -> PascalString.staticParse(readBuffer), readBuffer));

    ApplicationDescription clientDescription =
        readSimpleField(
            "clientDescription",
            readComplex(
                () ->
                    (ApplicationDescription)
                        ExtensionObjectDefinition.staticParse(readBuffer, (int) (310)),
                readBuffer));

    PascalString serverUri =
        readSimpleField(
            "serverUri", readComplex(() -> PascalString.staticParse(readBuffer), readBuffer));

    PascalString endpointUrl =
        readSimpleField(
            "endpointUrl", readComplex(() -> PascalString.staticParse(readBuffer), readBuffer));

    int noOfLocaleIds = readImplicitField("noOfLocaleIds", readSignedInt(readBuffer, 32));

    List<PascalString> localeIds =
        readCountArrayField(
            "localeIds",
            readComplex(() -> PascalString.staticParse(readBuffer), readBuffer),
            noOfLocaleIds);

    double actualSessionTimeout =
        readSimpleField("actualSessionTimeout", readDouble(readBuffer, 64));

    long maxResponseMessageSize =
        readSimpleField("maxResponseMessageSize", readUnsignedLong(readBuffer, 32));

    long clientConnectionTime =
        readSimpleField("clientConnectionTime", readSignedLong(readBuffer, 64));

    long clientLastContactTime =
        readSimpleField("clientLastContactTime", readSignedLong(readBuffer, 64));

    long currentSubscriptionsCount =
        readSimpleField("currentSubscriptionsCount", readUnsignedLong(readBuffer, 32));

    long currentMonitoredItemsCount =
        readSimpleField("currentMonitoredItemsCount", readUnsignedLong(readBuffer, 32));

    long currentPublishRequestsInQueue =
        readSimpleField("currentPublishRequestsInQueue", readUnsignedLong(readBuffer, 32));

    ServiceCounterDataType totalRequestCount =
        readSimpleField(
            "totalRequestCount",
            readComplex(
                () ->
                    (ServiceCounterDataType)
                        ExtensionObjectDefinition.staticParse(readBuffer, (int) (873)),
                readBuffer));

    long unauthorizedRequestCount =
        readSimpleField("unauthorizedRequestCount", readUnsignedLong(readBuffer, 32));

    ServiceCounterDataType readCount =
        readSimpleField(
            "readCount",
            readComplex(
                () ->
                    (ServiceCounterDataType)
                        ExtensionObjectDefinition.staticParse(readBuffer, (int) (873)),
                readBuffer));

    ServiceCounterDataType historyReadCount =
        readSimpleField(
            "historyReadCount",
            readComplex(
                () ->
                    (ServiceCounterDataType)
                        ExtensionObjectDefinition.staticParse(readBuffer, (int) (873)),
                readBuffer));

    ServiceCounterDataType writeCount =
        readSimpleField(
            "writeCount",
            readComplex(
                () ->
                    (ServiceCounterDataType)
                        ExtensionObjectDefinition.staticParse(readBuffer, (int) (873)),
                readBuffer));

    ServiceCounterDataType historyUpdateCount =
        readSimpleField(
            "historyUpdateCount",
            readComplex(
                () ->
                    (ServiceCounterDataType)
                        ExtensionObjectDefinition.staticParse(readBuffer, (int) (873)),
                readBuffer));

    ServiceCounterDataType callCount =
        readSimpleField(
            "callCount",
            readComplex(
                () ->
                    (ServiceCounterDataType)
                        ExtensionObjectDefinition.staticParse(readBuffer, (int) (873)),
                readBuffer));

    ServiceCounterDataType createMonitoredItemsCount =
        readSimpleField(
            "createMonitoredItemsCount",
            readComplex(
                () ->
                    (ServiceCounterDataType)
                        ExtensionObjectDefinition.staticParse(readBuffer, (int) (873)),
                readBuffer));

    ServiceCounterDataType modifyMonitoredItemsCount =
        readSimpleField(
            "modifyMonitoredItemsCount",
            readComplex(
                () ->
                    (ServiceCounterDataType)
                        ExtensionObjectDefinition.staticParse(readBuffer, (int) (873)),
                readBuffer));

    ServiceCounterDataType setMonitoringModeCount =
        readSimpleField(
            "setMonitoringModeCount",
            readComplex(
                () ->
                    (ServiceCounterDataType)
                        ExtensionObjectDefinition.staticParse(readBuffer, (int) (873)),
                readBuffer));

    ServiceCounterDataType setTriggeringCount =
        readSimpleField(
            "setTriggeringCount",
            readComplex(
                () ->
                    (ServiceCounterDataType)
                        ExtensionObjectDefinition.staticParse(readBuffer, (int) (873)),
                readBuffer));

    ServiceCounterDataType deleteMonitoredItemsCount =
        readSimpleField(
            "deleteMonitoredItemsCount",
            readComplex(
                () ->
                    (ServiceCounterDataType)
                        ExtensionObjectDefinition.staticParse(readBuffer, (int) (873)),
                readBuffer));

    ServiceCounterDataType createSubscriptionCount =
        readSimpleField(
            "createSubscriptionCount",
            readComplex(
                () ->
                    (ServiceCounterDataType)
                        ExtensionObjectDefinition.staticParse(readBuffer, (int) (873)),
                readBuffer));

    ServiceCounterDataType modifySubscriptionCount =
        readSimpleField(
            "modifySubscriptionCount",
            readComplex(
                () ->
                    (ServiceCounterDataType)
                        ExtensionObjectDefinition.staticParse(readBuffer, (int) (873)),
                readBuffer));

    ServiceCounterDataType setPublishingModeCount =
        readSimpleField(
            "setPublishingModeCount",
            readComplex(
                () ->
                    (ServiceCounterDataType)
                        ExtensionObjectDefinition.staticParse(readBuffer, (int) (873)),
                readBuffer));

    ServiceCounterDataType publishCount =
        readSimpleField(
            "publishCount",
            readComplex(
                () ->
                    (ServiceCounterDataType)
                        ExtensionObjectDefinition.staticParse(readBuffer, (int) (873)),
                readBuffer));

    ServiceCounterDataType republishCount =
        readSimpleField(
            "republishCount",
            readComplex(
                () ->
                    (ServiceCounterDataType)
                        ExtensionObjectDefinition.staticParse(readBuffer, (int) (873)),
                readBuffer));

    ServiceCounterDataType transferSubscriptionsCount =
        readSimpleField(
            "transferSubscriptionsCount",
            readComplex(
                () ->
                    (ServiceCounterDataType)
                        ExtensionObjectDefinition.staticParse(readBuffer, (int) (873)),
                readBuffer));

    ServiceCounterDataType deleteSubscriptionsCount =
        readSimpleField(
            "deleteSubscriptionsCount",
            readComplex(
                () ->
                    (ServiceCounterDataType)
                        ExtensionObjectDefinition.staticParse(readBuffer, (int) (873)),
                readBuffer));

    ServiceCounterDataType addNodesCount =
        readSimpleField(
            "addNodesCount",
            readComplex(
                () ->
                    (ServiceCounterDataType)
                        ExtensionObjectDefinition.staticParse(readBuffer, (int) (873)),
                readBuffer));

    ServiceCounterDataType addReferencesCount =
        readSimpleField(
            "addReferencesCount",
            readComplex(
                () ->
                    (ServiceCounterDataType)
                        ExtensionObjectDefinition.staticParse(readBuffer, (int) (873)),
                readBuffer));

    ServiceCounterDataType deleteNodesCount =
        readSimpleField(
            "deleteNodesCount",
            readComplex(
                () ->
                    (ServiceCounterDataType)
                        ExtensionObjectDefinition.staticParse(readBuffer, (int) (873)),
                readBuffer));

    ServiceCounterDataType deleteReferencesCount =
        readSimpleField(
            "deleteReferencesCount",
            readComplex(
                () ->
                    (ServiceCounterDataType)
                        ExtensionObjectDefinition.staticParse(readBuffer, (int) (873)),
                readBuffer));

    ServiceCounterDataType browseCount =
        readSimpleField(
            "browseCount",
            readComplex(
                () ->
                    (ServiceCounterDataType)
                        ExtensionObjectDefinition.staticParse(readBuffer, (int) (873)),
                readBuffer));

    ServiceCounterDataType browseNextCount =
        readSimpleField(
            "browseNextCount",
            readComplex(
                () ->
                    (ServiceCounterDataType)
                        ExtensionObjectDefinition.staticParse(readBuffer, (int) (873)),
                readBuffer));

    ServiceCounterDataType translateBrowsePathsToNodeIdsCount =
        readSimpleField(
            "translateBrowsePathsToNodeIdsCount",
            readComplex(
                () ->
                    (ServiceCounterDataType)
                        ExtensionObjectDefinition.staticParse(readBuffer, (int) (873)),
                readBuffer));

    ServiceCounterDataType queryFirstCount =
        readSimpleField(
            "queryFirstCount",
            readComplex(
                () ->
                    (ServiceCounterDataType)
                        ExtensionObjectDefinition.staticParse(readBuffer, (int) (873)),
                readBuffer));

    ServiceCounterDataType queryNextCount =
        readSimpleField(
            "queryNextCount",
            readComplex(
                () ->
                    (ServiceCounterDataType)
                        ExtensionObjectDefinition.staticParse(readBuffer, (int) (873)),
                readBuffer));

    ServiceCounterDataType registerNodesCount =
        readSimpleField(
            "registerNodesCount",
            readComplex(
                () ->
                    (ServiceCounterDataType)
                        ExtensionObjectDefinition.staticParse(readBuffer, (int) (873)),
                readBuffer));

    ServiceCounterDataType unregisterNodesCount =
        readSimpleField(
            "unregisterNodesCount",
            readComplex(
                () ->
                    (ServiceCounterDataType)
                        ExtensionObjectDefinition.staticParse(readBuffer, (int) (873)),
                readBuffer));

    readBuffer.closeContext("SessionDiagnosticsDataType");
    // Create the instance
    return new SessionDiagnosticsDataTypeBuilderImpl(
        sessionId,
        sessionName,
        clientDescription,
        serverUri,
        endpointUrl,
        localeIds,
        actualSessionTimeout,
        maxResponseMessageSize,
        clientConnectionTime,
        clientLastContactTime,
        currentSubscriptionsCount,
        currentMonitoredItemsCount,
        currentPublishRequestsInQueue,
        totalRequestCount,
        unauthorizedRequestCount,
        readCount,
        historyReadCount,
        writeCount,
        historyUpdateCount,
        callCount,
        createMonitoredItemsCount,
        modifyMonitoredItemsCount,
        setMonitoringModeCount,
        setTriggeringCount,
        deleteMonitoredItemsCount,
        createSubscriptionCount,
        modifySubscriptionCount,
        setPublishingModeCount,
        publishCount,
        republishCount,
        transferSubscriptionsCount,
        deleteSubscriptionsCount,
        addNodesCount,
        addReferencesCount,
        deleteNodesCount,
        deleteReferencesCount,
        browseCount,
        browseNextCount,
        translateBrowsePathsToNodeIdsCount,
        queryFirstCount,
        queryNextCount,
        registerNodesCount,
        unregisterNodesCount);
  }

  public static class SessionDiagnosticsDataTypeBuilderImpl
      implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
    private final NodeId sessionId;
    private final PascalString sessionName;
    private final ApplicationDescription clientDescription;
    private final PascalString serverUri;
    private final PascalString endpointUrl;
    private final List<PascalString> localeIds;
    private final double actualSessionTimeout;
    private final long maxResponseMessageSize;
    private final long clientConnectionTime;
    private final long clientLastContactTime;
    private final long currentSubscriptionsCount;
    private final long currentMonitoredItemsCount;
    private final long currentPublishRequestsInQueue;
    private final ServiceCounterDataType totalRequestCount;
    private final long unauthorizedRequestCount;
    private final ServiceCounterDataType readCount;
    private final ServiceCounterDataType historyReadCount;
    private final ServiceCounterDataType writeCount;
    private final ServiceCounterDataType historyUpdateCount;
    private final ServiceCounterDataType callCount;
    private final ServiceCounterDataType createMonitoredItemsCount;
    private final ServiceCounterDataType modifyMonitoredItemsCount;
    private final ServiceCounterDataType setMonitoringModeCount;
    private final ServiceCounterDataType setTriggeringCount;
    private final ServiceCounterDataType deleteMonitoredItemsCount;
    private final ServiceCounterDataType createSubscriptionCount;
    private final ServiceCounterDataType modifySubscriptionCount;
    private final ServiceCounterDataType setPublishingModeCount;
    private final ServiceCounterDataType publishCount;
    private final ServiceCounterDataType republishCount;
    private final ServiceCounterDataType transferSubscriptionsCount;
    private final ServiceCounterDataType deleteSubscriptionsCount;
    private final ServiceCounterDataType addNodesCount;
    private final ServiceCounterDataType addReferencesCount;
    private final ServiceCounterDataType deleteNodesCount;
    private final ServiceCounterDataType deleteReferencesCount;
    private final ServiceCounterDataType browseCount;
    private final ServiceCounterDataType browseNextCount;
    private final ServiceCounterDataType translateBrowsePathsToNodeIdsCount;
    private final ServiceCounterDataType queryFirstCount;
    private final ServiceCounterDataType queryNextCount;
    private final ServiceCounterDataType registerNodesCount;
    private final ServiceCounterDataType unregisterNodesCount;

    public SessionDiagnosticsDataTypeBuilderImpl(
        NodeId sessionId,
        PascalString sessionName,
        ApplicationDescription clientDescription,
        PascalString serverUri,
        PascalString endpointUrl,
        List<PascalString> localeIds,
        double actualSessionTimeout,
        long maxResponseMessageSize,
        long clientConnectionTime,
        long clientLastContactTime,
        long currentSubscriptionsCount,
        long currentMonitoredItemsCount,
        long currentPublishRequestsInQueue,
        ServiceCounterDataType totalRequestCount,
        long unauthorizedRequestCount,
        ServiceCounterDataType readCount,
        ServiceCounterDataType historyReadCount,
        ServiceCounterDataType writeCount,
        ServiceCounterDataType historyUpdateCount,
        ServiceCounterDataType callCount,
        ServiceCounterDataType createMonitoredItemsCount,
        ServiceCounterDataType modifyMonitoredItemsCount,
        ServiceCounterDataType setMonitoringModeCount,
        ServiceCounterDataType setTriggeringCount,
        ServiceCounterDataType deleteMonitoredItemsCount,
        ServiceCounterDataType createSubscriptionCount,
        ServiceCounterDataType modifySubscriptionCount,
        ServiceCounterDataType setPublishingModeCount,
        ServiceCounterDataType publishCount,
        ServiceCounterDataType republishCount,
        ServiceCounterDataType transferSubscriptionsCount,
        ServiceCounterDataType deleteSubscriptionsCount,
        ServiceCounterDataType addNodesCount,
        ServiceCounterDataType addReferencesCount,
        ServiceCounterDataType deleteNodesCount,
        ServiceCounterDataType deleteReferencesCount,
        ServiceCounterDataType browseCount,
        ServiceCounterDataType browseNextCount,
        ServiceCounterDataType translateBrowsePathsToNodeIdsCount,
        ServiceCounterDataType queryFirstCount,
        ServiceCounterDataType queryNextCount,
        ServiceCounterDataType registerNodesCount,
        ServiceCounterDataType unregisterNodesCount) {
      this.sessionId = sessionId;
      this.sessionName = sessionName;
      this.clientDescription = clientDescription;
      this.serverUri = serverUri;
      this.endpointUrl = endpointUrl;
      this.localeIds = localeIds;
      this.actualSessionTimeout = actualSessionTimeout;
      this.maxResponseMessageSize = maxResponseMessageSize;
      this.clientConnectionTime = clientConnectionTime;
      this.clientLastContactTime = clientLastContactTime;
      this.currentSubscriptionsCount = currentSubscriptionsCount;
      this.currentMonitoredItemsCount = currentMonitoredItemsCount;
      this.currentPublishRequestsInQueue = currentPublishRequestsInQueue;
      this.totalRequestCount = totalRequestCount;
      this.unauthorizedRequestCount = unauthorizedRequestCount;
      this.readCount = readCount;
      this.historyReadCount = historyReadCount;
      this.writeCount = writeCount;
      this.historyUpdateCount = historyUpdateCount;
      this.callCount = callCount;
      this.createMonitoredItemsCount = createMonitoredItemsCount;
      this.modifyMonitoredItemsCount = modifyMonitoredItemsCount;
      this.setMonitoringModeCount = setMonitoringModeCount;
      this.setTriggeringCount = setTriggeringCount;
      this.deleteMonitoredItemsCount = deleteMonitoredItemsCount;
      this.createSubscriptionCount = createSubscriptionCount;
      this.modifySubscriptionCount = modifySubscriptionCount;
      this.setPublishingModeCount = setPublishingModeCount;
      this.publishCount = publishCount;
      this.republishCount = republishCount;
      this.transferSubscriptionsCount = transferSubscriptionsCount;
      this.deleteSubscriptionsCount = deleteSubscriptionsCount;
      this.addNodesCount = addNodesCount;
      this.addReferencesCount = addReferencesCount;
      this.deleteNodesCount = deleteNodesCount;
      this.deleteReferencesCount = deleteReferencesCount;
      this.browseCount = browseCount;
      this.browseNextCount = browseNextCount;
      this.translateBrowsePathsToNodeIdsCount = translateBrowsePathsToNodeIdsCount;
      this.queryFirstCount = queryFirstCount;
      this.queryNextCount = queryNextCount;
      this.registerNodesCount = registerNodesCount;
      this.unregisterNodesCount = unregisterNodesCount;
    }

    public SessionDiagnosticsDataType build() {
      SessionDiagnosticsDataType sessionDiagnosticsDataType =
          new SessionDiagnosticsDataType(
              sessionId,
              sessionName,
              clientDescription,
              serverUri,
              endpointUrl,
              localeIds,
              actualSessionTimeout,
              maxResponseMessageSize,
              clientConnectionTime,
              clientLastContactTime,
              currentSubscriptionsCount,
              currentMonitoredItemsCount,
              currentPublishRequestsInQueue,
              totalRequestCount,
              unauthorizedRequestCount,
              readCount,
              historyReadCount,
              writeCount,
              historyUpdateCount,
              callCount,
              createMonitoredItemsCount,
              modifyMonitoredItemsCount,
              setMonitoringModeCount,
              setTriggeringCount,
              deleteMonitoredItemsCount,
              createSubscriptionCount,
              modifySubscriptionCount,
              setPublishingModeCount,
              publishCount,
              republishCount,
              transferSubscriptionsCount,
              deleteSubscriptionsCount,
              addNodesCount,
              addReferencesCount,
              deleteNodesCount,
              deleteReferencesCount,
              browseCount,
              browseNextCount,
              translateBrowsePathsToNodeIdsCount,
              queryFirstCount,
              queryNextCount,
              registerNodesCount,
              unregisterNodesCount);
      return sessionDiagnosticsDataType;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof SessionDiagnosticsDataType)) {
      return false;
    }
    SessionDiagnosticsDataType that = (SessionDiagnosticsDataType) o;
    return (getSessionId() == that.getSessionId())
        && (getSessionName() == that.getSessionName())
        && (getClientDescription() == that.getClientDescription())
        && (getServerUri() == that.getServerUri())
        && (getEndpointUrl() == that.getEndpointUrl())
        && (getLocaleIds() == that.getLocaleIds())
        && (getActualSessionTimeout() == that.getActualSessionTimeout())
        && (getMaxResponseMessageSize() == that.getMaxResponseMessageSize())
        && (getClientConnectionTime() == that.getClientConnectionTime())
        && (getClientLastContactTime() == that.getClientLastContactTime())
        && (getCurrentSubscriptionsCount() == that.getCurrentSubscriptionsCount())
        && (getCurrentMonitoredItemsCount() == that.getCurrentMonitoredItemsCount())
        && (getCurrentPublishRequestsInQueue() == that.getCurrentPublishRequestsInQueue())
        && (getTotalRequestCount() == that.getTotalRequestCount())
        && (getUnauthorizedRequestCount() == that.getUnauthorizedRequestCount())
        && (getReadCount() == that.getReadCount())
        && (getHistoryReadCount() == that.getHistoryReadCount())
        && (getWriteCount() == that.getWriteCount())
        && (getHistoryUpdateCount() == that.getHistoryUpdateCount())
        && (getCallCount() == that.getCallCount())
        && (getCreateMonitoredItemsCount() == that.getCreateMonitoredItemsCount())
        && (getModifyMonitoredItemsCount() == that.getModifyMonitoredItemsCount())
        && (getSetMonitoringModeCount() == that.getSetMonitoringModeCount())
        && (getSetTriggeringCount() == that.getSetTriggeringCount())
        && (getDeleteMonitoredItemsCount() == that.getDeleteMonitoredItemsCount())
        && (getCreateSubscriptionCount() == that.getCreateSubscriptionCount())
        && (getModifySubscriptionCount() == that.getModifySubscriptionCount())
        && (getSetPublishingModeCount() == that.getSetPublishingModeCount())
        && (getPublishCount() == that.getPublishCount())
        && (getRepublishCount() == that.getRepublishCount())
        && (getTransferSubscriptionsCount() == that.getTransferSubscriptionsCount())
        && (getDeleteSubscriptionsCount() == that.getDeleteSubscriptionsCount())
        && (getAddNodesCount() == that.getAddNodesCount())
        && (getAddReferencesCount() == that.getAddReferencesCount())
        && (getDeleteNodesCount() == that.getDeleteNodesCount())
        && (getDeleteReferencesCount() == that.getDeleteReferencesCount())
        && (getBrowseCount() == that.getBrowseCount())
        && (getBrowseNextCount() == that.getBrowseNextCount())
        && (getTranslateBrowsePathsToNodeIdsCount() == that.getTranslateBrowsePathsToNodeIdsCount())
        && (getQueryFirstCount() == that.getQueryFirstCount())
        && (getQueryNextCount() == that.getQueryNextCount())
        && (getRegisterNodesCount() == that.getRegisterNodesCount())
        && (getUnregisterNodesCount() == that.getUnregisterNodesCount())
        && super.equals(that)
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        super.hashCode(),
        getSessionId(),
        getSessionName(),
        getClientDescription(),
        getServerUri(),
        getEndpointUrl(),
        getLocaleIds(),
        getActualSessionTimeout(),
        getMaxResponseMessageSize(),
        getClientConnectionTime(),
        getClientLastContactTime(),
        getCurrentSubscriptionsCount(),
        getCurrentMonitoredItemsCount(),
        getCurrentPublishRequestsInQueue(),
        getTotalRequestCount(),
        getUnauthorizedRequestCount(),
        getReadCount(),
        getHistoryReadCount(),
        getWriteCount(),
        getHistoryUpdateCount(),
        getCallCount(),
        getCreateMonitoredItemsCount(),
        getModifyMonitoredItemsCount(),
        getSetMonitoringModeCount(),
        getSetTriggeringCount(),
        getDeleteMonitoredItemsCount(),
        getCreateSubscriptionCount(),
        getModifySubscriptionCount(),
        getSetPublishingModeCount(),
        getPublishCount(),
        getRepublishCount(),
        getTransferSubscriptionsCount(),
        getDeleteSubscriptionsCount(),
        getAddNodesCount(),
        getAddReferencesCount(),
        getDeleteNodesCount(),
        getDeleteReferencesCount(),
        getBrowseCount(),
        getBrowseNextCount(),
        getTranslateBrowsePathsToNodeIdsCount(),
        getQueryFirstCount(),
        getQueryNextCount(),
        getRegisterNodesCount(),
        getUnregisterNodesCount());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
