/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.opcua.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class RootExtensionObject extends ExtensionObject implements Message {

  // Accessors for discriminator values.
  public Boolean getIncludeEncodingMask() {
    return (boolean) false;
  }

  // Properties.
  protected final ExtensionObjectDefinition body;

  public RootExtensionObject(ExpandedNodeId typeId, ExtensionObjectDefinition body) {
    super(typeId);
    this.body = body;
  }

  public ExtensionObjectDefinition getBody() {
    return body;
  }

  @Override
  protected void serializeExtensionObjectChild(WriteBuffer writeBuffer)
      throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("RootExtensionObject");

    // Simple Field (body)
    writeSimpleField("body", body, writeComplex(writeBuffer));

    writeBuffer.popContext("RootExtensionObject");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    RootExtensionObject _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (body)
    lengthInBits += body.getLengthInBits();

    return lengthInBits;
  }

  public static ExtensionObjectBuilder staticParseExtensionObjectBuilder(
      ReadBuffer readBuffer, Integer extensionId, Boolean includeEncodingMask)
      throws ParseException {
    readBuffer.pullContext("RootExtensionObject");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    ExtensionObjectDefinition body =
        readSimpleField(
            "body",
            readComplex(
                () -> ExtensionObjectDefinition.staticParse(readBuffer, (int) (extensionId)),
                readBuffer));

    readBuffer.closeContext("RootExtensionObject");
    // Create the instance
    return new RootExtensionObjectBuilderImpl(body);
  }

  public static class RootExtensionObjectBuilderImpl
      implements ExtensionObject.ExtensionObjectBuilder {
    private final ExtensionObjectDefinition body;

    public RootExtensionObjectBuilderImpl(ExtensionObjectDefinition body) {
      this.body = body;
    }

    public RootExtensionObject build(ExpandedNodeId typeId) {
      RootExtensionObject rootExtensionObject = new RootExtensionObject(typeId, body);
      return rootExtensionObject;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof RootExtensionObject)) {
      return false;
    }
    RootExtensionObject that = (RootExtensionObject) o;
    return (getBody() == that.getBody()) && super.equals(that) && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(super.hashCode(), getBody());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
