/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetTimeStampDateTime is the corresponding interface of BACnetTimeStampDateTime
type BACnetTimeStampDateTime interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	BACnetTimeStamp
	// GetDateTimeValue returns DateTimeValue (property field)
	GetDateTimeValue() BACnetDateTimeEnclosed
	// IsBACnetTimeStampDateTime is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetTimeStampDateTime()
	// CreateBuilder creates a BACnetTimeStampDateTimeBuilder
	CreateBACnetTimeStampDateTimeBuilder() BACnetTimeStampDateTimeBuilder
}

// _BACnetTimeStampDateTime is the data-structure of this message
type _BACnetTimeStampDateTime struct {
	BACnetTimeStampContract
	DateTimeValue BACnetDateTimeEnclosed
}

var _ BACnetTimeStampDateTime = (*_BACnetTimeStampDateTime)(nil)
var _ BACnetTimeStampRequirements = (*_BACnetTimeStampDateTime)(nil)

// NewBACnetTimeStampDateTime factory function for _BACnetTimeStampDateTime
func NewBACnetTimeStampDateTime(peekedTagHeader BACnetTagHeader, dateTimeValue BACnetDateTimeEnclosed) *_BACnetTimeStampDateTime {
	if dateTimeValue == nil {
		panic("dateTimeValue of type BACnetDateTimeEnclosed for BACnetTimeStampDateTime must not be nil")
	}
	_result := &_BACnetTimeStampDateTime{
		BACnetTimeStampContract: NewBACnetTimeStamp(peekedTagHeader),
		DateTimeValue:           dateTimeValue,
	}
	_result.BACnetTimeStampContract.(*_BACnetTimeStamp)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetTimeStampDateTimeBuilder is a builder for BACnetTimeStampDateTime
type BACnetTimeStampDateTimeBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(dateTimeValue BACnetDateTimeEnclosed) BACnetTimeStampDateTimeBuilder
	// WithDateTimeValue adds DateTimeValue (property field)
	WithDateTimeValue(BACnetDateTimeEnclosed) BACnetTimeStampDateTimeBuilder
	// WithDateTimeValueBuilder adds DateTimeValue (property field) which is build by the builder
	WithDateTimeValueBuilder(func(BACnetDateTimeEnclosedBuilder) BACnetDateTimeEnclosedBuilder) BACnetTimeStampDateTimeBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() BACnetTimeStampBuilder
	// Build builds the BACnetTimeStampDateTime or returns an error if something is wrong
	Build() (BACnetTimeStampDateTime, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetTimeStampDateTime
}

// NewBACnetTimeStampDateTimeBuilder() creates a BACnetTimeStampDateTimeBuilder
func NewBACnetTimeStampDateTimeBuilder() BACnetTimeStampDateTimeBuilder {
	return &_BACnetTimeStampDateTimeBuilder{_BACnetTimeStampDateTime: new(_BACnetTimeStampDateTime)}
}

type _BACnetTimeStampDateTimeBuilder struct {
	*_BACnetTimeStampDateTime

	parentBuilder *_BACnetTimeStampBuilder

	collectedErr []error
}

var _ (BACnetTimeStampDateTimeBuilder) = (*_BACnetTimeStampDateTimeBuilder)(nil)

func (b *_BACnetTimeStampDateTimeBuilder) setParent(contract BACnetTimeStampContract) {
	b.BACnetTimeStampContract = contract
	contract.(*_BACnetTimeStamp)._SubType = b._BACnetTimeStampDateTime
}

func (b *_BACnetTimeStampDateTimeBuilder) WithMandatoryFields(dateTimeValue BACnetDateTimeEnclosed) BACnetTimeStampDateTimeBuilder {
	return b.WithDateTimeValue(dateTimeValue)
}

func (b *_BACnetTimeStampDateTimeBuilder) WithDateTimeValue(dateTimeValue BACnetDateTimeEnclosed) BACnetTimeStampDateTimeBuilder {
	b.DateTimeValue = dateTimeValue
	return b
}

func (b *_BACnetTimeStampDateTimeBuilder) WithDateTimeValueBuilder(builderSupplier func(BACnetDateTimeEnclosedBuilder) BACnetDateTimeEnclosedBuilder) BACnetTimeStampDateTimeBuilder {
	builder := builderSupplier(b.DateTimeValue.CreateBACnetDateTimeEnclosedBuilder())
	var err error
	b.DateTimeValue, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "BACnetDateTimeEnclosedBuilder failed"))
	}
	return b
}

func (b *_BACnetTimeStampDateTimeBuilder) Build() (BACnetTimeStampDateTime, error) {
	if b.DateTimeValue == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'dateTimeValue' not set"))
	}
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._BACnetTimeStampDateTime.deepCopy(), nil
}

func (b *_BACnetTimeStampDateTimeBuilder) MustBuild() BACnetTimeStampDateTime {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetTimeStampDateTimeBuilder) Done() BACnetTimeStampBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewBACnetTimeStampBuilder().(*_BACnetTimeStampBuilder)
	}
	return b.parentBuilder
}

func (b *_BACnetTimeStampDateTimeBuilder) buildForBACnetTimeStamp() (BACnetTimeStamp, error) {
	return b.Build()
}

func (b *_BACnetTimeStampDateTimeBuilder) DeepCopy() any {
	_copy := b.CreateBACnetTimeStampDateTimeBuilder().(*_BACnetTimeStampDateTimeBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateBACnetTimeStampDateTimeBuilder creates a BACnetTimeStampDateTimeBuilder
func (b *_BACnetTimeStampDateTime) CreateBACnetTimeStampDateTimeBuilder() BACnetTimeStampDateTimeBuilder {
	if b == nil {
		return NewBACnetTimeStampDateTimeBuilder()
	}
	return &_BACnetTimeStampDateTimeBuilder{_BACnetTimeStampDateTime: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_BACnetTimeStampDateTime) GetParent() BACnetTimeStampContract {
	return m.BACnetTimeStampContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetTimeStampDateTime) GetDateTimeValue() BACnetDateTimeEnclosed {
	return m.DateTimeValue
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetTimeStampDateTime(structType any) BACnetTimeStampDateTime {
	if casted, ok := structType.(BACnetTimeStampDateTime); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetTimeStampDateTime); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetTimeStampDateTime) GetTypeName() string {
	return "BACnetTimeStampDateTime"
}

func (m *_BACnetTimeStampDateTime) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.BACnetTimeStampContract.(*_BACnetTimeStamp).getLengthInBits(ctx))

	// Simple field (dateTimeValue)
	lengthInBits += m.DateTimeValue.GetLengthInBits(ctx)

	return lengthInBits
}

func (m *_BACnetTimeStampDateTime) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_BACnetTimeStampDateTime) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_BACnetTimeStamp) (__bACnetTimeStampDateTime BACnetTimeStampDateTime, err error) {
	m.BACnetTimeStampContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetTimeStampDateTime"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetTimeStampDateTime")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	dateTimeValue, err := ReadSimpleField[BACnetDateTimeEnclosed](ctx, "dateTimeValue", ReadComplex[BACnetDateTimeEnclosed](BACnetDateTimeEnclosedParseWithBufferProducer((uint8)(uint8(2))), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'dateTimeValue' field"))
	}
	m.DateTimeValue = dateTimeValue

	if closeErr := readBuffer.CloseContext("BACnetTimeStampDateTime"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetTimeStampDateTime")
	}

	return m, nil
}

func (m *_BACnetTimeStampDateTime) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetTimeStampDateTime) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("BACnetTimeStampDateTime"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for BACnetTimeStampDateTime")
		}

		if err := WriteSimpleField[BACnetDateTimeEnclosed](ctx, "dateTimeValue", m.GetDateTimeValue(), WriteComplex[BACnetDateTimeEnclosed](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'dateTimeValue' field")
		}

		if popErr := writeBuffer.PopContext("BACnetTimeStampDateTime"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for BACnetTimeStampDateTime")
		}
		return nil
	}
	return m.BACnetTimeStampContract.(*_BACnetTimeStamp).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_BACnetTimeStampDateTime) IsBACnetTimeStampDateTime() {}

func (m *_BACnetTimeStampDateTime) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetTimeStampDateTime) deepCopy() *_BACnetTimeStampDateTime {
	if m == nil {
		return nil
	}
	_BACnetTimeStampDateTimeCopy := &_BACnetTimeStampDateTime{
		m.BACnetTimeStampContract.(*_BACnetTimeStamp).deepCopy(),
		utils.DeepCopy[BACnetDateTimeEnclosed](m.DateTimeValue),
	}
	_BACnetTimeStampDateTimeCopy.BACnetTimeStampContract.(*_BACnetTimeStamp)._SubType = m
	return _BACnetTimeStampDateTimeCopy
}

func (m *_BACnetTimeStampDateTime) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
