/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetConstructedDataNetworkNumberQuality is the corresponding interface of BACnetConstructedDataNetworkNumberQuality
type BACnetConstructedDataNetworkNumberQuality interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	BACnetConstructedData
	// GetNetworkNumberQuality returns NetworkNumberQuality (property field)
	GetNetworkNumberQuality() BACnetNetworkNumberQualityTagged
	// GetActualValue returns ActualValue (virtual field)
	GetActualValue() BACnetNetworkNumberQualityTagged
	// IsBACnetConstructedDataNetworkNumberQuality is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetConstructedDataNetworkNumberQuality()
	// CreateBuilder creates a BACnetConstructedDataNetworkNumberQualityBuilder
	CreateBACnetConstructedDataNetworkNumberQualityBuilder() BACnetConstructedDataNetworkNumberQualityBuilder
}

// _BACnetConstructedDataNetworkNumberQuality is the data-structure of this message
type _BACnetConstructedDataNetworkNumberQuality struct {
	BACnetConstructedDataContract
	NetworkNumberQuality BACnetNetworkNumberQualityTagged
}

var _ BACnetConstructedDataNetworkNumberQuality = (*_BACnetConstructedDataNetworkNumberQuality)(nil)
var _ BACnetConstructedDataRequirements = (*_BACnetConstructedDataNetworkNumberQuality)(nil)

// NewBACnetConstructedDataNetworkNumberQuality factory function for _BACnetConstructedDataNetworkNumberQuality
func NewBACnetConstructedDataNetworkNumberQuality(openingTag BACnetOpeningTag, peekedTagHeader BACnetTagHeader, closingTag BACnetClosingTag, networkNumberQuality BACnetNetworkNumberQualityTagged, tagNumber uint8, arrayIndexArgument BACnetTagPayloadUnsignedInteger) *_BACnetConstructedDataNetworkNumberQuality {
	if networkNumberQuality == nil {
		panic("networkNumberQuality of type BACnetNetworkNumberQualityTagged for BACnetConstructedDataNetworkNumberQuality must not be nil")
	}
	_result := &_BACnetConstructedDataNetworkNumberQuality{
		BACnetConstructedDataContract: NewBACnetConstructedData(openingTag, peekedTagHeader, closingTag, tagNumber, arrayIndexArgument),
		NetworkNumberQuality:          networkNumberQuality,
	}
	_result.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetConstructedDataNetworkNumberQualityBuilder is a builder for BACnetConstructedDataNetworkNumberQuality
type BACnetConstructedDataNetworkNumberQualityBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(networkNumberQuality BACnetNetworkNumberQualityTagged) BACnetConstructedDataNetworkNumberQualityBuilder
	// WithNetworkNumberQuality adds NetworkNumberQuality (property field)
	WithNetworkNumberQuality(BACnetNetworkNumberQualityTagged) BACnetConstructedDataNetworkNumberQualityBuilder
	// WithNetworkNumberQualityBuilder adds NetworkNumberQuality (property field) which is build by the builder
	WithNetworkNumberQualityBuilder(func(BACnetNetworkNumberQualityTaggedBuilder) BACnetNetworkNumberQualityTaggedBuilder) BACnetConstructedDataNetworkNumberQualityBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() BACnetConstructedDataBuilder
	// Build builds the BACnetConstructedDataNetworkNumberQuality or returns an error if something is wrong
	Build() (BACnetConstructedDataNetworkNumberQuality, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetConstructedDataNetworkNumberQuality
}

// NewBACnetConstructedDataNetworkNumberQualityBuilder() creates a BACnetConstructedDataNetworkNumberQualityBuilder
func NewBACnetConstructedDataNetworkNumberQualityBuilder() BACnetConstructedDataNetworkNumberQualityBuilder {
	return &_BACnetConstructedDataNetworkNumberQualityBuilder{_BACnetConstructedDataNetworkNumberQuality: new(_BACnetConstructedDataNetworkNumberQuality)}
}

type _BACnetConstructedDataNetworkNumberQualityBuilder struct {
	*_BACnetConstructedDataNetworkNumberQuality

	parentBuilder *_BACnetConstructedDataBuilder

	collectedErr []error
}

var _ (BACnetConstructedDataNetworkNumberQualityBuilder) = (*_BACnetConstructedDataNetworkNumberQualityBuilder)(nil)

func (b *_BACnetConstructedDataNetworkNumberQualityBuilder) setParent(contract BACnetConstructedDataContract) {
	b.BACnetConstructedDataContract = contract
	contract.(*_BACnetConstructedData)._SubType = b._BACnetConstructedDataNetworkNumberQuality
}

func (b *_BACnetConstructedDataNetworkNumberQualityBuilder) WithMandatoryFields(networkNumberQuality BACnetNetworkNumberQualityTagged) BACnetConstructedDataNetworkNumberQualityBuilder {
	return b.WithNetworkNumberQuality(networkNumberQuality)
}

func (b *_BACnetConstructedDataNetworkNumberQualityBuilder) WithNetworkNumberQuality(networkNumberQuality BACnetNetworkNumberQualityTagged) BACnetConstructedDataNetworkNumberQualityBuilder {
	b.NetworkNumberQuality = networkNumberQuality
	return b
}

func (b *_BACnetConstructedDataNetworkNumberQualityBuilder) WithNetworkNumberQualityBuilder(builderSupplier func(BACnetNetworkNumberQualityTaggedBuilder) BACnetNetworkNumberQualityTaggedBuilder) BACnetConstructedDataNetworkNumberQualityBuilder {
	builder := builderSupplier(b.NetworkNumberQuality.CreateBACnetNetworkNumberQualityTaggedBuilder())
	var err error
	b.NetworkNumberQuality, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "BACnetNetworkNumberQualityTaggedBuilder failed"))
	}
	return b
}

func (b *_BACnetConstructedDataNetworkNumberQualityBuilder) Build() (BACnetConstructedDataNetworkNumberQuality, error) {
	if b.NetworkNumberQuality == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'networkNumberQuality' not set"))
	}
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._BACnetConstructedDataNetworkNumberQuality.deepCopy(), nil
}

func (b *_BACnetConstructedDataNetworkNumberQualityBuilder) MustBuild() BACnetConstructedDataNetworkNumberQuality {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetConstructedDataNetworkNumberQualityBuilder) Done() BACnetConstructedDataBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewBACnetConstructedDataBuilder().(*_BACnetConstructedDataBuilder)
	}
	return b.parentBuilder
}

func (b *_BACnetConstructedDataNetworkNumberQualityBuilder) buildForBACnetConstructedData() (BACnetConstructedData, error) {
	return b.Build()
}

func (b *_BACnetConstructedDataNetworkNumberQualityBuilder) DeepCopy() any {
	_copy := b.CreateBACnetConstructedDataNetworkNumberQualityBuilder().(*_BACnetConstructedDataNetworkNumberQualityBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateBACnetConstructedDataNetworkNumberQualityBuilder creates a BACnetConstructedDataNetworkNumberQualityBuilder
func (b *_BACnetConstructedDataNetworkNumberQuality) CreateBACnetConstructedDataNetworkNumberQualityBuilder() BACnetConstructedDataNetworkNumberQualityBuilder {
	if b == nil {
		return NewBACnetConstructedDataNetworkNumberQualityBuilder()
	}
	return &_BACnetConstructedDataNetworkNumberQualityBuilder{_BACnetConstructedDataNetworkNumberQuality: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_BACnetConstructedDataNetworkNumberQuality) GetObjectTypeArgument() BACnetObjectType {
	return 0
}

func (m *_BACnetConstructedDataNetworkNumberQuality) GetPropertyIdentifierArgument() BACnetPropertyIdentifier {
	return BACnetPropertyIdentifier_NETWORK_NUMBER_QUALITY
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_BACnetConstructedDataNetworkNumberQuality) GetParent() BACnetConstructedDataContract {
	return m.BACnetConstructedDataContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetConstructedDataNetworkNumberQuality) GetNetworkNumberQuality() BACnetNetworkNumberQualityTagged {
	return m.NetworkNumberQuality
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for virtual fields.
///////////////////////

func (m *_BACnetConstructedDataNetworkNumberQuality) GetActualValue() BACnetNetworkNumberQualityTagged {
	ctx := context.Background()
	_ = ctx
	return CastBACnetNetworkNumberQualityTagged(m.GetNetworkNumberQuality())
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetConstructedDataNetworkNumberQuality(structType any) BACnetConstructedDataNetworkNumberQuality {
	if casted, ok := structType.(BACnetConstructedDataNetworkNumberQuality); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetConstructedDataNetworkNumberQuality); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetConstructedDataNetworkNumberQuality) GetTypeName() string {
	return "BACnetConstructedDataNetworkNumberQuality"
}

func (m *_BACnetConstructedDataNetworkNumberQuality) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.BACnetConstructedDataContract.(*_BACnetConstructedData).getLengthInBits(ctx))

	// Simple field (networkNumberQuality)
	lengthInBits += m.NetworkNumberQuality.GetLengthInBits(ctx)

	// A virtual field doesn't have any in- or output.

	return lengthInBits
}

func (m *_BACnetConstructedDataNetworkNumberQuality) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_BACnetConstructedDataNetworkNumberQuality) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_BACnetConstructedData, tagNumber uint8, objectTypeArgument BACnetObjectType, propertyIdentifierArgument BACnetPropertyIdentifier, arrayIndexArgument BACnetTagPayloadUnsignedInteger) (__bACnetConstructedDataNetworkNumberQuality BACnetConstructedDataNetworkNumberQuality, err error) {
	m.BACnetConstructedDataContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetConstructedDataNetworkNumberQuality"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetConstructedDataNetworkNumberQuality")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	networkNumberQuality, err := ReadSimpleField[BACnetNetworkNumberQualityTagged](ctx, "networkNumberQuality", ReadComplex[BACnetNetworkNumberQualityTagged](BACnetNetworkNumberQualityTaggedParseWithBufferProducer((uint8)(uint8(0)), (TagClass)(TagClass_APPLICATION_TAGS)), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'networkNumberQuality' field"))
	}
	m.NetworkNumberQuality = networkNumberQuality

	actualValue, err := ReadVirtualField[BACnetNetworkNumberQualityTagged](ctx, "actualValue", (*BACnetNetworkNumberQualityTagged)(nil), networkNumberQuality)
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'actualValue' field"))
	}
	_ = actualValue

	if closeErr := readBuffer.CloseContext("BACnetConstructedDataNetworkNumberQuality"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetConstructedDataNetworkNumberQuality")
	}

	return m, nil
}

func (m *_BACnetConstructedDataNetworkNumberQuality) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetConstructedDataNetworkNumberQuality) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("BACnetConstructedDataNetworkNumberQuality"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for BACnetConstructedDataNetworkNumberQuality")
		}

		if err := WriteSimpleField[BACnetNetworkNumberQualityTagged](ctx, "networkNumberQuality", m.GetNetworkNumberQuality(), WriteComplex[BACnetNetworkNumberQualityTagged](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'networkNumberQuality' field")
		}
		// Virtual field
		actualValue := m.GetActualValue()
		_ = actualValue
		if _actualValueErr := writeBuffer.WriteVirtual(ctx, "actualValue", m.GetActualValue()); _actualValueErr != nil {
			return errors.Wrap(_actualValueErr, "Error serializing 'actualValue' field")
		}

		if popErr := writeBuffer.PopContext("BACnetConstructedDataNetworkNumberQuality"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for BACnetConstructedDataNetworkNumberQuality")
		}
		return nil
	}
	return m.BACnetConstructedDataContract.(*_BACnetConstructedData).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_BACnetConstructedDataNetworkNumberQuality) IsBACnetConstructedDataNetworkNumberQuality() {}

func (m *_BACnetConstructedDataNetworkNumberQuality) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetConstructedDataNetworkNumberQuality) deepCopy() *_BACnetConstructedDataNetworkNumberQuality {
	if m == nil {
		return nil
	}
	_BACnetConstructedDataNetworkNumberQualityCopy := &_BACnetConstructedDataNetworkNumberQuality{
		m.BACnetConstructedDataContract.(*_BACnetConstructedData).deepCopy(),
		utils.DeepCopy[BACnetNetworkNumberQualityTagged](m.NetworkNumberQuality),
	}
	_BACnetConstructedDataNetworkNumberQualityCopy.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = m
	return _BACnetConstructedDataNetworkNumberQualityCopy
}

func (m *_BACnetConstructedDataNetworkNumberQuality) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
