/*
 * Decompiled with CFR 0.152.
 */
package org.kurento.client.internal.client.operation;

import java.lang.reflect.Type;
import org.kurento.client.KurentoObject;
import org.kurento.client.internal.client.RemoteObjectInvocationHandler;
import org.kurento.client.internal.client.operation.Operation;
import org.kurento.client.internal.transport.jsonrpc.RomClientJsonRpcClient;
import org.kurento.client.internal.transport.serialization.ParamsFlattener;
import org.kurento.jsonrpc.Props;

public class InvokeOperation
extends Operation {
    private static ParamsFlattener FLATTENER = ParamsFlattener.getInstance();
    private KurentoObject kurentoObject;
    private String method;
    private Props params;
    private Type returnType;

    public InvokeOperation(KurentoObject object, String method, Props params, Type returnType) {
        this.kurentoObject = object;
        this.method = method;
        this.params = params;
        this.returnType = returnType;
    }

    @Override
    public RomClientJsonRpcClient.RequestAndResponseType createRequest(RomClientJsonRpcClient romClientJsonRpcClient) {
        Type flattenType = FLATTENER.calculateFlattenType(this.returnType);
        return romClientJsonRpcClient.createInvokeRequest(RemoteObjectInvocationHandler.getFor(this.kurentoObject).getRemoteObject().getObjectRef(), this.method, this.params, flattenType, true);
    }

    @Override
    public void processResponse(Object result) {
        if (this.returnType != Void.class && this.returnType != Void.TYPE) {
            this.future.getFuture().set(FLATTENER.unflattenValue("return", this.returnType, result, this.manager));
        }
    }

    @Override
    public String getDescription() {
        return "Invoking method '" + this.method + "' in object " + this.getObjectRef(this.kurentoObject) + "' with params " + String.valueOf(this.params);
    }
}

