/*
 * Decompiled with CFR 0.152.
 */
package org.jodconverter.core.office;

import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.jodconverter.core.office.AbstractOfficeManagerPoolEntry;
import org.jodconverter.core.office.OfficeException;
import org.jodconverter.core.office.OfficeManager;
import org.jodconverter.core.office.OfficeUtils;
import org.jodconverter.core.office.TemporaryFileMaker;
import org.jodconverter.core.task.OfficeTask;
import org.jodconverter.core.util.AssertUtils;
import org.jodconverter.core.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractOfficeManagerPool<E extends AbstractOfficeManagerPoolEntry>
implements OfficeManager,
TemporaryFileMaker {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractOfficeManagerPool.class);
    private static final int POOL_STOPPED = 0;
    private static final int POOL_STARTED = 1;
    private static final int POOL_SHUTDOWN = 2;
    public static final long DEFAULT_TASK_QUEUE_TIMEOUT = 30000L;
    public static final long DEFAULT_TASK_EXECUTION_TIMEOUT = 120000L;
    private final AtomicInteger poolState = new AtomicInteger(0);
    private final File tempDir;
    private final AtomicLong tempFileCounter;
    private final long taskQueueTimeout;
    private final BlockingQueue<E> pool;
    private List<E> entries;

    protected AbstractOfficeManagerPool(int poolSize, @NonNull File workingDir, long taskQueueTimeout) {
        AssertUtils.notNull(workingDir, "workingDir must not be null");
        this.taskQueueTimeout = taskQueueTimeout;
        this.tempDir = new File(workingDir, ".jodconverter_" + UUID.randomUUID());
        this.tempFileCounter = new AtomicLong(0L);
        this.pool = new ArrayBlockingQueue(poolSize);
    }

    protected void setEntries(@NonNull List<@NonNull E> entries) {
        this.entries = Collections.unmodifiableList(entries);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void start() throws OfficeException {
        AbstractOfficeManagerPool abstractOfficeManagerPool = this;
        synchronized (abstractOfficeManagerPool) {
            if (this.poolState.get() == 2) {
                throw new IllegalStateException("This office manager has been shutdown.");
            }
            if (this.poolState.get() == 1) {
                throw new IllegalStateException("This office manager is already running.");
            }
            for (AbstractOfficeManagerPoolEntry manager : this.entries) {
                manager.start();
                this.releaseManager(manager);
            }
            this.prepareTempDir();
            this.poolState.set(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void stop() throws OfficeException {
        AbstractOfficeManagerPool abstractOfficeManagerPool = this;
        synchronized (abstractOfficeManagerPool) {
            if (this.poolState.get() == 2) {
                return;
            }
            this.poolState.set(2);
            try {
                LOGGER.info("Stopping the office manager pool...");
                this.pool.clear();
                for (AbstractOfficeManagerPoolEntry manager : this.entries) {
                    manager.stop();
                }
            }
            finally {
                this.deleteTempDir();
            }
        }
    }

    @Override
    public final boolean isRunning() {
        if (this.poolState.get() == 1) {
            for (AbstractOfficeManagerPoolEntry manager : this.entries) {
                if (!manager.isRunning()) continue;
                return true;
            }
        }
        return false;
    }

    private E acquireManager() throws OfficeException {
        AbstractOfficeManagerPoolEntry manager;
        LOGGER.debug("Acquiring an office manager from the pool...");
        try {
            manager = (AbstractOfficeManagerPoolEntry)this.pool.poll(this.taskQueueTimeout, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            throw new OfficeException("Interruption while acquiring manager", ex);
        }
        if (manager == null) {
            throw new OfficeException(String.format("No office manager available after %d millisec", this.taskQueueTimeout));
        }
        LOGGER.debug("Office manager acquired successfully from the pool.");
        return (E)manager;
    }

    private void releaseManager(E manager) throws OfficeException {
        LOGGER.debug("Returning office manager to the pool...");
        try {
            this.pool.put(manager);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            throw new OfficeException("Interruption while releasing manager", ex);
        }
    }

    @Override
    public final void execute(@NonNull OfficeTask task) throws OfficeException {
        if (this.poolState.get() != 1) {
            throw new IllegalStateException("This office manager is not running.");
        }
        AbstractOfficeManagerPoolEntry entry = null;
        try {
            entry = (AbstractOfficeManagerPoolEntry)this.acquireManager();
            entry.execute(task);
        }
        finally {
            if (entry != null) {
                this.releaseManager(entry);
            }
        }
    }

    private void prepareTempDir() throws OfficeException {
        if (this.tempDir.exists()) {
            LOGGER.warn("Temporary directory '{}' already exists; deleting", (Object)this.tempDir);
            this.deleteTempDir();
        }
        this.tempDir.mkdirs();
        if (!this.tempDir.isDirectory()) {
            throw new OfficeException(String.format("Cannot create temporary directory: %s", this.tempDir));
        }
    }

    private void deleteTempDir() {
        OfficeUtils.deleteOrRenameFile(this.tempDir, 0L, 0L);
    }

    @Override
    public @NonNull File makeTemporaryFile() {
        return this.makeTemporaryFile(null);
    }

    @Override
    public @NonNull File makeTemporaryFile(@Nullable String extension) {
        return new File(this.tempDir, "tempfile_" + this.tempFileCounter.getAndIncrement() + (StringUtils.isBlank(extension) ? "" : "." + extension));
    }

    public static abstract class AbstractOfficeManagerPoolBuilder<B extends AbstractOfficeManagerPoolBuilder<B>> {
        protected boolean install;
        protected File workingDir = OfficeUtils.getDefaultWorkingDir();
        protected long taskExecutionTimeout = 120000L;
        protected long taskQueueTimeout = 30000L;

        protected AbstractOfficeManagerPoolBuilder() {
        }

        protected abstract @NonNull AbstractOfficeManagerPool build();

        public @NonNull B install() {
            this.install = true;
            return (B)this;
        }

        public @NonNull B workingDir(@Nullable File workingDir) {
            if (workingDir != null) {
                this.workingDir = workingDir;
            }
            return (B)this;
        }

        public @NonNull B workingDir(@Nullable String workingDir) {
            return (B)(StringUtils.isBlank(workingDir) ? this : this.workingDir(new File(workingDir)));
        }

        public @NonNull B taskExecutionTimeout(@Nullable Long taskExecutionTimeout) {
            if (taskExecutionTimeout != null) {
                AssertUtils.isTrue(taskExecutionTimeout >= 0L, String.format("taskExecutionTimeout %s must greater than or equal to 0", taskExecutionTimeout));
                this.taskExecutionTimeout = taskExecutionTimeout;
            }
            return (B)this;
        }

        public @NonNull B taskQueueTimeout(@Nullable Long taskQueueTimeout) {
            if (taskQueueTimeout != null) {
                AssertUtils.isTrue(taskQueueTimeout >= 0L, String.format("taskQueueTimeout %s must greater than or equal to 0", taskQueueTimeout));
                this.taskQueueTimeout = taskQueueTimeout;
            }
            return (B)this;
        }
    }
}

