/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.json.internal;

import com.hazelcast.json.internal.JsonDataSerializerHook;
import com.hazelcast.json.internal.JsonSchemaNameValue;
import com.hazelcast.json.internal.JsonSchemaNode;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class JsonSchemaStructNode
extends JsonSchemaNode {
    private List<JsonSchemaNameValue> inners = new ArrayList<JsonSchemaNameValue>();

    public JsonSchemaStructNode() {
    }

    public JsonSchemaStructNode(JsonSchemaStructNode parent) {
        super(parent);
    }

    public void addChild(JsonSchemaNameValue description) {
        this.inners.add(description);
    }

    public JsonSchemaNameValue getChild(int i) {
        return this.inners.get(i);
    }

    public int getChildCount() {
        return this.inners.size();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JsonSchemaStructNode that = (JsonSchemaStructNode)o;
        return this.inners != null ? this.inners.equals(that.inners) : that.inners == null;
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.inners != null ? this.inners.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "JsonSchemaStructNode{inners=" + this.inners + "}";
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeInt(this.inners.size());
        for (int i = 0; i < this.inners.size(); ++i) {
            this.inners.get(i).writeData(out);
        }
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        int innersSize = in.readInt();
        this.inners = new ArrayList<JsonSchemaNameValue>(innersSize);
        for (int i = 0; i < innersSize; ++i) {
            JsonSchemaNameValue nameValue = new JsonSchemaNameValue();
            nameValue.readData(in);
            nameValue.getValue().setParent(this);
            this.inners.add(nameValue);
        }
    }

    @Override
    public int getFactoryId() {
        return JsonDataSerializerHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 2;
    }
}

