/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.processor;

import com.hazelcast.core.ManagedContext;
import com.hazelcast.function.BiFunctionEx;
import com.hazelcast.function.FunctionEx;
import com.hazelcast.jet.core.Processor;
import com.hazelcast.jet.core.ProcessorSupplier;
import com.hazelcast.jet.pipeline.ServiceFactory;
import com.hazelcast.security.PermissionsUtil;
import java.util.Collection;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;

public final class ProcessorSupplierWithService<C, S>
implements ProcessorSupplier {
    private static final long serialVersionUID = 1L;
    private final ServiceFactory<C, S> serviceFactory;
    private final BiFunction<? super ServiceFactory<C, S>, ? super C, ? extends Processor> createProcessorFn;
    private transient C serviceContext;

    private ProcessorSupplierWithService(@Nonnull ServiceFactory<C, S> serviceFactory, @Nonnull BiFunction<? super ServiceFactory<C, S>, ? super C, ? extends Processor> createProcessorFn) {
        this.serviceFactory = serviceFactory;
        this.createProcessorFn = createProcessorFn;
    }

    @Override
    public void init(@Nonnull ProcessorSupplier.Context context) {
        ManagedContext managedContext = context.managedContext();
        FunctionEx<ProcessorSupplier.Context, C> contextFn = this.serviceFactory.createContextFn();
        PermissionsUtil.checkPermission(contextFn, context);
        this.serviceContext = contextFn.apply(context);
        this.serviceContext = managedContext.initialize(this.serviceContext);
    }

    @Override
    @Nonnull
    public Collection<? extends Processor> get(int count) {
        return Stream.generate(() -> this.createProcessorFn.apply(this.serviceFactory, this.serviceContext)).limit(count).collect(Collectors.toList());
    }

    @Override
    public void close(Throwable error) {
        if (this.serviceContext != null) {
            this.serviceFactory.destroyContextFn().accept(this.serviceContext);
        }
    }

    @Nonnull
    public static <C, S> ProcessorSupplier supplierWithService(@Nonnull ServiceFactory<C, S> serviceFactory, @Nonnull BiFunctionEx<? super ServiceFactory<C, S>, ? super C, ? extends Processor> createProcessorFn) {
        return new ProcessorSupplierWithService<C, S>(serviceFactory, createProcessorFn);
    }
}

