/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.util.collection;

import com.hazelcast.internal.util.collection.UtilCollectionSerializerHook;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import java.io.IOException;
import java.util.AbstractSet;
import java.util.BitSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.PrimitiveIterator;

public class PartitionIdSet
extends AbstractSet<Integer>
implements IdentifiedDataSerializable {
    private static final int SIZE_UNKNOWN = -1;
    private int partitionCount;
    private BitSet bitSet;
    private int size = -1;

    PartitionIdSet() {
    }

    public PartitionIdSet(int partitionCount) {
        this(partitionCount, new BitSet(partitionCount));
    }

    public PartitionIdSet(int partitionCount, int solePartitionId) {
        this(partitionCount);
        this.bitSet.set(solePartitionId);
    }

    public PartitionIdSet(int partitionCount, Collection<Integer> initialPartitionIds) {
        this(partitionCount);
        for (int partitionId : initialPartitionIds) {
            this.bitSet.set(partitionId);
        }
    }

    public PartitionIdSet(int partitionCount, int[] initialPartitionIds) {
        this(partitionCount);
        for (int partitionId : initialPartitionIds) {
            this.bitSet.set(partitionId);
        }
    }

    public PartitionIdSet(PartitionIdSet initialPartitionIds) {
        this(initialPartitionIds.partitionCount, initialPartitionIds);
    }

    PartitionIdSet(int partitionCount, BitSet bitSet) {
        this.partitionCount = partitionCount;
        this.bitSet = bitSet;
    }

    @Override
    public Iterator<Integer> iterator() {
        return new PartitionIdSetIterator();
    }

    public PrimitiveIterator.OfInt intIterator() {
        return new PartitionIdSetIterator();
    }

    @Override
    public int size() {
        int s = this.size;
        if (s == -1) {
            this.size = s = this.bitSet.cardinality();
        }
        return s;
    }

    private void resetSize() {
        this.size = -1;
    }

    @Override
    public boolean isEmpty() {
        return this.bitSet.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        if (!(o instanceof Integer)) {
            throw new ClassCastException("PartitionIdSet can be only used with Integers");
        }
        return this.bitSet.get((Integer)o);
    }

    public boolean contains(int partitionId) {
        return this.bitSet.get(partitionId);
    }

    public boolean containsAll(PartitionIdSet other) {
        BitSet clone = (BitSet)this.bitSet.clone();
        clone.and(other.bitSet);
        return clone.cardinality() == other.bitSet.cardinality();
    }

    @Override
    public boolean add(Integer partitionId) {
        return this.add((int)partitionId);
    }

    @Override
    public boolean add(int partitionId) {
        if (!this.bitSet.get(partitionId)) {
            this.bitSet.set(partitionId);
            this.resetSize();
            return true;
        }
        return false;
    }

    public void addAll(PartitionIdSet other) {
        this.bitSet.or(other.bitSet);
        this.resetSize();
    }

    @Override
    public boolean remove(Object o) {
        if (!(o instanceof Integer)) {
            throw new ClassCastException("PartitionIdSet can be only used with Integers");
        }
        return this.remove((Integer)o);
    }

    public boolean remove(int partitionId) {
        if (this.bitSet.get(partitionId)) {
            this.bitSet.clear(partitionId);
            this.resetSize();
            return true;
        }
        return false;
    }

    public void removeAll(PartitionIdSet other) {
        other.bitSet.stream().forEach(this.bitSet::clear);
        this.resetSize();
    }

    @Override
    public void clear() {
        this.bitSet.clear();
        this.resetSize();
    }

    public int getPartitionCount() {
        return this.partitionCount;
    }

    public boolean intersects(PartitionIdSet other) {
        return this.bitSet.intersects(other.bitSet);
    }

    public PartitionIdSet intersectCopy(PartitionIdSet other) {
        BitSet newBitSet = this.bitSetCopy();
        newBitSet.and(other.bitSet);
        return new PartitionIdSet(this.partitionCount, newBitSet);
    }

    public void union(PartitionIdSet other) {
        this.bitSet.or(other.bitSet);
        this.resetSize();
    }

    public void complement() {
        this.bitSet.flip(0, this.partitionCount);
        this.resetSize();
    }

    public boolean isMissingPartitions() {
        return this.bitSet.nextClearBit(0) < this.partitionCount;
    }

    public PartitionIdSet copy() {
        return new PartitionIdSet(this.partitionCount, (BitSet)this.bitSet.clone());
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PartitionIdSet other = (PartitionIdSet)o;
        return this.partitionCount == other.partitionCount && this.bitSet.equals(other.bitSet);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.partitionCount;
        result = 31 * result + this.bitSet.hashCode();
        return result;
    }

    public int solePartition() {
        int candidateResult = this.bitSet.nextSetBit(0);
        if (this.bitSet.nextSetBit(candidateResult + 1) < 0) {
            return candidateResult;
        }
        return -1;
    }

    public int firstPartition() {
        return this.bitSet.nextSetBit(0);
    }

    public BitSet bitSetCopy() {
        return (BitSet)this.bitSet.clone();
    }

    @Override
    public int getFactoryId() {
        return UtilCollectionSerializerHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 1;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeInt(this.partitionCount);
        out.writeLongArray(this.bitSet.toLongArray());
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.partitionCount = in.readInt();
        this.bitSet = BitSet.valueOf(in.readLongArray());
    }

    private final class PartitionIdSetIterator
    implements PrimitiveIterator.OfInt {
        private int last = -1;
        private int next = -1;

        PartitionIdSetIterator() {
            this.moveNext();
        }

        private void moveNext() {
            this.last = this.next;
            this.next = PartitionIdSet.this.bitSet.nextSetBit(this.next + 1);
        }

        @Override
        public boolean hasNext() {
            return this.next >= 0;
        }

        @Override
        public Integer next() {
            return this.nextInt();
        }

        @Override
        public int nextInt() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("No more elements");
            }
            int res = this.next;
            this.moveNext();
            return res;
        }

        @Override
        public void remove() {
            PartitionIdSet.this.remove(this.last);
        }
    }
}

