/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.connection.tcp;

import com.hazelcast.client.UnsupportedClusterVersionException;
import com.hazelcast.client.UnsupportedRoutingModeException;
import com.hazelcast.client.config.ClusterRoutingConfig;
import com.hazelcast.client.config.RoutingStrategy;
import com.hazelcast.client.impl.connection.tcp.RoutingMode;
import com.hazelcast.internal.cluster.Versions;
import com.hazelcast.version.Version;
import java.util.Map;

public final class AuthenticationKeyValuePairConstants {
    public static final String CLUSTER_VERSION = "clusterVersion";
    public static final String ROUTING_MODE_NOT_SUPPORTED_MESSAGE = String.format("%s routing mode %s cannot be supported because the server has not sent the required information. %s routing is an Enterprise feature in Hazelcast 5.5. Make sure your cluster has Hazelcast Enterprise JARs on its classpath.", new Object[]{RoutingMode.MULTI_MEMBER, RoutingStrategy.PARTITION_GROUPS, RoutingMode.MULTI_MEMBER});
    public static final String MEMBER_GROUPS_INFO = "memberGroups";
    public static final String CP_LEADERS_INFO = "cp.leaders";
    private static final Version MULTI_MEMBER_ROUTING_MINIMUM_SUPPORTED_CLUSTER_VERSION = Versions.V5_5;

    private AuthenticationKeyValuePairConstants() {
    }

    public static boolean checkRequiredFieldsForMultiMemberRoutingExist(ClusterRoutingConfig clusterRoutingConfig, Map<String, String> keyValuePairs) {
        if (clusterRoutingConfig.getRoutingMode() != RoutingMode.MULTI_MEMBER) {
            return false;
        }
        if (clusterRoutingConfig.getRoutingStrategy() != RoutingStrategy.PARTITION_GROUPS) {
            return false;
        }
        if (!keyValuePairs.containsKey(MEMBER_GROUPS_INFO)) {
            throw new UnsupportedRoutingModeException(ROUTING_MODE_NOT_SUPPORTED_MESSAGE);
        }
        return true;
    }

    public static void checkMinimumClusterVersionForMultiMemberRouting(Map<String, String> keyValuePairs) {
        if (!keyValuePairs.containsKey(CLUSTER_VERSION) || Version.of(keyValuePairs.get(CLUSTER_VERSION)).isUnknown() || Version.of(keyValuePairs.get(CLUSTER_VERSION)).isLessThan(MULTI_MEMBER_ROUTING_MINIMUM_SUPPORTED_CLUSTER_VERSION)) {
            throw new UnsupportedClusterVersionException(ROUTING_MODE_NOT_SUPPORTED_MESSAGE);
        }
    }
}

