/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.db.entity.file;

import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.NamedQueries;
import jakarta.persistence.NamedQuery;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.apache.openjpa.enhance.PCRegistry;
import org.apache.openjpa.enhance.PersistenceCapable;
import org.apache.openjpa.enhance.StateManager;
import org.apache.openmeetings.db.bind.adapter.LongAdapter;
import org.apache.openmeetings.db.entity.file.BaseFileItem;

@Entity
@NamedQueries(value={@NamedQuery(name="getAllFiles", query="SELECT f FROM FileItem f ORDER BY f.id"), @NamedQuery(name="getFilesByRoom", query="SELECT f FROM FileItem f WHERE f.deleted = false AND f.roomId = :roomId AND f.ownerId IS NULL AND f.parentId IS NULL ORDER BY f.type ASC, f.name "), @NamedQuery(name="getFilesByOwner", query="SELECT f FROM FileItem f WHERE f.deleted = false AND f.ownerId = :ownerId AND f.parentId IS NULL ORDER BY f.type ASC, f.name "), @NamedQuery(name="getFilesByParent", query="SELECT f FROM FileItem f WHERE f.deleted = false AND f.parentId = :parentId ORDER BY f.type ASC, f.name "), @NamedQuery(name="getFilesFilteredByParent", query="SELECT f FROM FileItem f WHERE f.deleted = false AND f.parentId = :parentId AND f.type IN :filter ORDER BY f.type ASC, f.name "), @NamedQuery(name="getFileExternal", query="SELECT f FROM FileItem f WHERE f.deleted = false AND f.externalId = :externalId AND f.externalType = :externalType"), @NamedQuery(name="getFileAllExternal", query="SELECT f FROM FileItem f WHERE f.deleted = false AND f.externalType = :externalType"), @NamedQuery(name="getFileByGroup", query="SELECT f FROM FileItem f WHERE f.deleted = false AND f.ownerId IS NULL AND f.groupId = :groupId AND f.parentId IS NULL ORDER BY f.type ASC, f.name"), @NamedQuery(name="getFileFilteredByGroup", query="SELECT f FROM FileItem f WHERE f.deleted = false AND f.ownerId IS NULL AND f.groupId = :groupId AND f.parentId IS NULL AND f.type IN :filter ORDER BY f.type ASC, f.name")})
@XmlRootElement(name="fileItem")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class FileItem
extends BaseFileItem
implements PersistenceCapable {
    private static final long serialVersionUID = 1L;
    @Column(name="filesize")
    @XmlElement(name="size", required=false)
    @XmlJavaTypeAdapter(value=LongAdapter.class)
    private Long size;
    @Column(name="external_id")
    @XmlElement(name="externalId", required=false)
    private String externalId;
    private static int pcInheritedFieldCount = BaseFileItem.pcGetManagedFieldCount();
    private static String[] pcFieldNames;
    private static Class[] pcFieldTypes;
    private static byte[] pcFieldFlags;
    private static Class pcPCSuperclass;

    @Override
    public Long getId() {
        return super.getId();
    }

    @Override
    @XmlElement(name="fileExplorerItemId")
    @XmlJavaTypeAdapter(value=LongAdapter.class)
    public void setId(Long id) {
        super.setId(id);
    }

    public Long getSize() {
        return FileItem.pcGetsize(this);
    }

    public void setSize(Long fileSize) {
        FileItem.pcSetsize(this, fileSize);
    }

    public String getExternalId() {
        return FileItem.pcGetexternalId(this);
    }

    public void setExternalId(String externalId) {
        FileItem.pcSetexternalId(this, externalId);
    }

    @Override
    public int pcGetEnhancementContractVersion() {
        return 2;
    }

    static {
        pcPCSuperclass = BaseFileItem.class;
        pcFieldNames = new String[]{"externalId", "size"};
        pcFieldTypes = new Class[]{String.class, Long.class};
        pcFieldFlags = new byte[]{26, 26};
        PCRegistry.register(FileItem.class, (String[])pcFieldNames, (Class[])pcFieldTypes, (byte[])pcFieldFlags, (Class)pcPCSuperclass, (String)"FileItem", (PersistenceCapable)new FileItem());
    }

    @Override
    protected void pcClearFields() {
        super.pcClearFields();
        this.externalId = null;
        this.size = null;
    }

    @Override
    public PersistenceCapable pcNewInstance(StateManager stateManager, Object object, boolean bl) {
        FileItem fileItem = new FileItem();
        if (bl) {
            fileItem.pcClearFields();
        }
        fileItem.pcStateManager = stateManager;
        fileItem.pcCopyKeyFieldsFromObjectId(object);
        return fileItem;
    }

    @Override
    public PersistenceCapable pcNewInstance(StateManager stateManager, boolean bl) {
        FileItem fileItem = new FileItem();
        if (bl) {
            fileItem.pcClearFields();
        }
        fileItem.pcStateManager = stateManager;
        return fileItem;
    }

    protected static int pcGetManagedFieldCount() {
        return 2 + BaseFileItem.pcGetManagedFieldCount();
    }

    @Override
    public void pcReplaceField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcReplaceField(n);
            return;
        }
        switch (n2) {
            case 0: {
                this.externalId = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 1: {
                this.size = (Long)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void pcReplaceFields(int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            this.pcReplaceField(nArray[i]);
        }
    }

    @Override
    public void pcProvideField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcProvideField(n);
            return;
        }
        switch (n2) {
            case 0: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.externalId);
                return;
            }
            case 1: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.size);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void pcProvideFields(int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            this.pcProvideField(nArray[i]);
        }
    }

    protected void pcCopyField(FileItem fileItem, int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcCopyField(fileItem, n);
            return;
        }
        switch (n2) {
            case 0: {
                this.externalId = fileItem.externalId;
                return;
            }
            case 1: {
                this.size = fileItem.size;
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void pcCopyFields(Object object, int[] nArray) {
        FileItem fileItem = (FileItem)object;
        if (fileItem.pcStateManager != this.pcStateManager) {
            throw new IllegalArgumentException();
        }
        if (this.pcStateManager == null) {
            throw new IllegalStateException();
        }
        for (int i = 0; i < nArray.length; ++i) {
            this.pcCopyField(fileItem, nArray[i]);
        }
    }

    private static final String pcGetexternalId(FileItem fileItem) {
        if (fileItem.pcStateManager == null) {
            return fileItem.externalId;
        }
        int n = pcInheritedFieldCount + 0;
        fileItem.pcStateManager.accessingField(n);
        return fileItem.externalId;
    }

    private static final void pcSetexternalId(FileItem fileItem, String string) {
        if (fileItem.pcStateManager == null) {
            fileItem.externalId = string;
            return;
        }
        fileItem.pcStateManager.settingStringField((PersistenceCapable)fileItem, pcInheritedFieldCount + 0, fileItem.externalId, string, 0);
    }

    private static final Long pcGetsize(FileItem fileItem) {
        if (fileItem.pcStateManager == null) {
            return fileItem.size;
        }
        int n = pcInheritedFieldCount + 1;
        fileItem.pcStateManager.accessingField(n);
        return fileItem.size;
    }

    private static final void pcSetsize(FileItem fileItem, Long l) {
        if (fileItem.pcStateManager == null) {
            fileItem.size = l;
            return;
        }
        fileItem.pcStateManager.settingObjectField((PersistenceCapable)fileItem, pcInheritedFieldCount + 1, (Object)fileItem.size, (Object)l, 0);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        boolean bl = this.pcSerializing();
        objectOutputStream.defaultWriteObject();
        if (bl) {
            this.pcSetDetachedState(null);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.pcSetDetachedState(PersistenceCapable.DESERIALIZED);
        objectInputStream.defaultReadObject();
    }
}

