/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.db.dao.user;

import jakarta.inject.Inject;
import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import jakarta.persistence.TypedQuery;
import java.util.Date;
import java.util.List;
import org.apache.openmeetings.db.dao.user.UserDao;
import org.apache.openmeetings.db.entity.user.UserContact;
import org.apache.openmeetings.db.util.DaoHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
@Transactional
public class UserContactDao {
    private static final Logger log = LoggerFactory.getLogger(UserContactDao.class);
    private static final String PARAM_OWNERID = "ownerId";
    @PersistenceContext
    private EntityManager em;
    @Inject
    private UserDao userDao;

    public UserContact add(Long userId, Long ownerId, boolean pending) {
        try {
            UserContact userContact = new UserContact();
            userContact.setInserted(new Date());
            userContact.setOwner(this.userDao.get(ownerId));
            userContact.setContact(this.userDao.get(userId));
            userContact.setPending(pending);
            userContact = this.update(userContact);
            return userContact;
        }
        catch (Exception e) {
            log.error("[addUserContact]", (Throwable)e);
            return null;
        }
    }

    public void delete(Long id) {
        this.em.createNamedQuery("deleteUserContact").setParameter("id", (Object)id).executeUpdate();
    }

    public Integer deleteAllUserContacts(Long ownerId) {
        return this.em.createNamedQuery("deleteAllUserContacts").setParameter(PARAM_OWNERID, (Object)ownerId).executeUpdate();
    }

    public UserContact get(Long userId, Long ownerId) {
        return (UserContact)DaoHelper.only(this.em.createNamedQuery("getContactByUserOwner", UserContact.class).setParameter("userId", (Object)userId).setParameter(PARAM_OWNERID, (Object)ownerId).getResultList());
    }

    public boolean isContact(Long userId, Long ownerId) {
        UserContact c = this.get(userId, ownerId);
        return c != null && !c.isPending();
    }

    public List<UserContact> get(long ownerId, long first, long count) {
        return DaoHelper.setLimits(this.em.createNamedQuery("getContactsByUser", UserContact.class).setParameter("userId", (Object)ownerId), first, count).getResultList();
    }

    public long count(long ownerId) {
        TypedQuery q = this.em.createNamedQuery("countContactsByUser", Long.class);
        q.setParameter("userId", (Object)ownerId);
        return (Long)q.getSingleResult();
    }

    public List<UserContact> getContactsByUserAndStatus(Long ownerId, boolean pending) {
        return this.em.createNamedQuery("getContactsByUserAndStatus", UserContact.class).setParameter(PARAM_OWNERID, (Object)ownerId).setParameter("pending", (Object)pending).getResultList();
    }

    public List<UserContact> getContactRequestsByUserAndStatus(Long userId, boolean pending) {
        return this.em.createNamedQuery("getContactRequestsByUserAndStatus", UserContact.class).setParameter("userId", (Object)userId).setParameter("pending", (Object)pending).getResultList();
    }

    public UserContact get(Long id) {
        return (UserContact)DaoHelper.only(this.em.createNamedQuery("getUserContactsById", UserContact.class).setParameter("id", (Object)id).getResultList());
    }

    public List<UserContact> get() {
        return this.em.createNamedQuery("getUserContacts", UserContact.class).getResultList();
    }

    public Long updateContactStatus(Long id, boolean pending) {
        try {
            UserContact uc = this.get(id);
            uc.setPending(pending);
            this.update(uc);
            return id;
        }
        catch (Exception e) {
            log.error("[updateContactStatus]", (Throwable)e);
            return null;
        }
    }

    public UserContact update(UserContact c) {
        if (c.getId() == null) {
            c.setInserted(new Date());
            this.em.persist((Object)c);
        } else {
            c.setUpdated(new Date());
            c = (UserContact)this.em.merge((Object)c);
        }
        return c;
    }
}

