/*
 * Decompiled with CFR 0.152.
 */
package org.asteriskjava.pbx.internal.activity;

import java.util.HashSet;
import java.util.LinkedList;
import org.asteriskjava.pbx.ActivityCallback;
import org.asteriskjava.pbx.AsteriskSettings;
import org.asteriskjava.pbx.Call;
import org.asteriskjava.pbx.CallDirection;
import org.asteriskjava.pbx.CallImpl;
import org.asteriskjava.pbx.Channel;
import org.asteriskjava.pbx.EndPoint;
import org.asteriskjava.pbx.ListenerPriority;
import org.asteriskjava.pbx.PBXException;
import org.asteriskjava.pbx.PBXFactory;
import org.asteriskjava.pbx.activities.RedirectToActivity;
import org.asteriskjava.pbx.agi.AgiChannelActivityHold;
import org.asteriskjava.pbx.asterisk.wrap.actions.RedirectAction;
import org.asteriskjava.pbx.asterisk.wrap.events.ManagerEvent;
import org.asteriskjava.pbx.internal.activity.ActivityHelper;
import org.asteriskjava.pbx.internal.core.AsteriskPBX;
import org.asteriskjava.pbx.internal.core.ChannelProxy;
import org.asteriskjava.util.Log;
import org.asteriskjava.util.LogFactory;

public class RedirectToActivityImpl
extends ActivityHelper<RedirectToActivity>
implements RedirectToActivity {
    private static final Log logger = LogFactory.getLog(RedirectToActivityImpl.class);
    private Channel channel1;
    private Call _lhsCall;

    public RedirectToActivityImpl(Channel channel1, ActivityCallback<RedirectToActivity> listener) {
        super("SplitActivity", listener);
        this.channel1 = channel1;
        this.startActivity(true);
    }

    @Override
    public boolean doActivity() throws PBXException {
        logger.debug("***************************************************************************");
        logger.info("***********            begin redirect to activity           ****************");
        logger.info("***********            " + this.channel1 + "                 ****************");
        logger.debug("***************************************************************************");
        boolean success = false;
        if (this.channel1 != null && (success = this.splitTwo())) {
            this._lhsCall = new CallImpl(this.channel1, CallDirection.OUTBOUND);
        }
        return success;
    }

    @Override
    public HashSet<Class<? extends ManagerEvent>> requiredEvents() {
        HashSet<Class<? extends ManagerEvent>> required = new HashSet<Class<? extends ManagerEvent>>();
        return required;
    }

    @Override
    public synchronized void onManagerEvent(ManagerEvent event) {
    }

    @Override
    public ListenerPriority getPriority() {
        return ListenerPriority.NORMAL;
    }

    @Override
    public Call getCall() {
        return this._lhsCall;
    }

    private boolean splitTwo() throws PBXException {
        AsteriskSettings profile = PBXFactory.getActiveProfile();
        AsteriskPBX pbx = (AsteriskPBX)PBXFactory.getActivePBX();
        LinkedList<Channel> channels = new LinkedList<Channel>();
        channels.add(this.channel1);
        if (!pbx.waitForChannelsToQuiescent(channels, 3000L)) {
            logger.error(this.callSite, this.callSite);
            throw new PBXException("Channel: " + this.channel1 + " cannot be split as they are still in transition.");
        }
        AgiChannelActivityHold agi1 = new AgiChannelActivityHold();
        pbx.setVariable(this.channel1, "proxyId", "" + ((ChannelProxy)this.channel1).getIdentity());
        this.channel1.setCurrentActivityAction(agi1);
        String agiExten = profile.getAgiExtension();
        String agiContext = profile.getManagementContext();
        logger.debug("redirect channel lhs:" + this.channel1 + " to " + agiExten + " in context " + agiContext);
        EndPoint extensionAgi = pbx.getExtensionAgi();
        RedirectAction redirect = new RedirectAction(this.channel1, agiContext, extensionAgi, 1);
        boolean ret = false;
        try {
            pbx.sendAction(redirect, 1000);
            for (double ctr = 0.0; !agi1.hasCallReachedAgi() && ctr < 10.0; ctr += 0.1) {
                Thread.sleep(100L);
                if (agi1.hasCallReachedAgi()) continue;
                logger.warn("Waiting on (agi1) " + this.channel1);
            }
            ret = agi1.hasCallReachedAgi();
        }
        catch (Exception e) {
            logger.error(e, e);
        }
        return ret;
    }
}

