/*
 * Decompiled with CFR 0.152.
 */
package org.asteriskjava.live.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import org.asteriskjava.live.ManagerCommunicationException;
import org.asteriskjava.live.MeetMeRoom;
import org.asteriskjava.live.MeetMeUser;
import org.asteriskjava.live.internal.AbstractLiveObject;
import org.asteriskjava.live.internal.AsteriskServerImpl;
import org.asteriskjava.live.internal.MeetMeUserImpl;
import org.asteriskjava.lock.LockableMap;
import org.asteriskjava.lock.Locker;
import org.asteriskjava.manager.action.CommandAction;

class MeetMeRoomImpl
extends AbstractLiveObject
implements MeetMeRoom {
    private static final String COMMAND_PREFIX = "meetme";
    private static final String LOCK_COMMAND = "lock";
    private static final String UNLOCK_COMMAND = "unlock";
    private final String roomNumber;
    private final LockableMap<Integer, MeetMeUserImpl> users;

    MeetMeRoomImpl(AsteriskServerImpl server, String roomNumber) {
        super(server);
        this.roomNumber = roomNumber;
        this.users = new LockableMap(new HashMap(20));
    }

    @Override
    public String getRoomNumber() {
        return this.roomNumber;
    }

    @Override
    public Collection<MeetMeUser> getUsers() {
        try (Locker.LockCloser closer = this.users.withLock();){
            ArrayList<MeetMeUser> arrayList = new ArrayList<MeetMeUser>(this.users.values());
            return arrayList;
        }
    }

    @Override
    public boolean isEmpty() {
        try (Locker.LockCloser closer = this.users.withLock();){
            boolean bl = this.users.isEmpty();
            return bl;
        }
    }

    Collection<MeetMeUserImpl> getUserImpls() {
        try (Locker.LockCloser closer = this.users.withLock();){
            ArrayList<MeetMeUserImpl> arrayList = new ArrayList<MeetMeUserImpl>(this.users.values());
            return arrayList;
        }
    }

    void addUser(MeetMeUserImpl user) {
        try (Locker.LockCloser closer = this.users.withLock();){
            this.users.put(user.getUserNumber(), user);
        }
    }

    MeetMeUserImpl getUser(Integer userNumber) {
        try (Locker.LockCloser closer = this.users.withLock();){
            MeetMeUserImpl meetMeUserImpl = this.users.get(userNumber);
            return meetMeUserImpl;
        }
    }

    void removeUser(MeetMeUserImpl user) {
        try (Locker.LockCloser closer = this.users.withLock();){
            this.users.remove(user.getUserNumber());
        }
    }

    @Override
    public void lock() throws ManagerCommunicationException {
        this.sendMeetMeCommand(LOCK_COMMAND);
    }

    @Override
    public void unlock() throws ManagerCommunicationException {
        this.sendMeetMeCommand(UNLOCK_COMMAND);
    }

    private void sendMeetMeCommand(String command) throws ManagerCommunicationException {
        StringBuilder sb = new StringBuilder();
        sb.append(COMMAND_PREFIX);
        sb.append(" ");
        sb.append(command);
        sb.append(" ");
        sb.append(this.roomNumber);
        this.server.sendAction(new CommandAction(sb.toString()));
    }

    public String toString() {
        int systemHashcode;
        StringBuilder sb = new StringBuilder("MeetMeRoom[");
        try (Locker.LockCloser closer = this.withLock();){
            sb.append("roomNumber='").append(this.getRoomNumber()).append("',");
            systemHashcode = System.identityHashCode(this);
        }
        sb.append("systemHashcode=").append(systemHashcode);
        sb.append("]");
        return sb.toString();
    }
}

