/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.core.documents;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.XppDriver;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LibraryChartLoader {
    private static final Logger log = LoggerFactory.getLogger(LibraryChartLoader.class);
    private static final String CHART_EXT = ".xchart";

    private LibraryChartLoader() {
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static List<?> loadChart(File dir, String fileName) {
        try {
            File file = new File(dir, fileName + CHART_EXT);
            log.error("filepathComplete: {}", (Object)file);
            XStream xStream = new XStream((HierarchicalStreamDriver)new XppDriver());
            xStream.setMode(1001);
            try (FileInputStream is = new FileInputStream(file);){
                List list;
                try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)is, StandardCharsets.UTF_8));){
                    list = (List)xStream.fromXML((Reader)reader);
                }
                return list;
            }
        }
        catch (Exception err) {
            log.error("Unexpected error while loading chart", (Throwable)err);
            return List.of();
        }
    }
}

