/*
 * Decompiled with CFR 0.152.
 */
package com.github.caldav4j.model.request;

import com.github.caldav4j.CalDAVConstants;
import com.github.caldav4j.exceptions.DOMValidationException;
import com.github.caldav4j.model.request.Comp;
import com.github.caldav4j.model.request.PropProperty;
import com.github.caldav4j.xml.OutputsDOMBase;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import net.fortuna.ical4j.model.Date;
import org.apache.jackrabbit.webdav.xml.Namespace;
import org.apache.jackrabbit.webdav.xml.XmlSerializable;

public class CalendarData
extends OutputsDOMBase {
    public static final String ELEMENT_NAME = "calendar-data";
    public static final String ELEM_EXPAND_RECURRENCE_SET = "expand";
    public static final String ELEM_LIMIT_RECURRENCE_SET = "limit-recurrence-set";
    public static final String ATTR_START = "start";
    public static final String ATTR_END = "end";
    public static final Integer EXPAND = 0;
    public static final Integer LIMIT = 1;
    private Date recurrenceSetStart = null;
    private Date recurrenceSetEnd = null;
    private Integer expandOrLimitRecurrenceSet;
    private Comp comp = null;

    public CalendarData(Integer expandOrLimitRecurrenceSet, Date recurrenceSetStart, Date recurrenceSetEnd, Comp comp) {
        this.expandOrLimitRecurrenceSet = expandOrLimitRecurrenceSet;
        this.recurrenceSetStart = recurrenceSetStart;
        this.recurrenceSetEnd = recurrenceSetEnd;
        this.comp = comp;
    }

    public CalendarData() {
    }

    public Comp getComp() {
        return this.comp;
    }

    public void setComp(Comp comp) {
        this.comp = comp;
    }

    public Integer getExpandOrLimitRecurrenceSet() {
        return this.expandOrLimitRecurrenceSet;
    }

    public void setExpandOrLimitRecurrenceSet(Integer expandOrLimitRecurrenceSet) {
        this.expandOrLimitRecurrenceSet = expandOrLimitRecurrenceSet;
    }

    public Date getRecurrenceSetEnd() {
        return this.recurrenceSetEnd;
    }

    public void setRecurrenceSetEnd(Date recurrenceSetEnd) {
        this.recurrenceSetEnd = recurrenceSetEnd;
    }

    public Date getRecurrenceSetStart() {
        return this.recurrenceSetStart;
    }

    public void setRecurrenceSetStart(Date recurrenceSetStart) {
        this.recurrenceSetStart = recurrenceSetStart;
    }

    @Override
    protected String getElementName() {
        return ELEMENT_NAME;
    }

    @Override
    protected Namespace getNamespace() {
        return CalDAVConstants.NAMESPACE_CALDAV;
    }

    @Override
    protected Collection<? extends XmlSerializable> getChildren() {
        ArrayList<Object> children = new ArrayList<Object>();
        if (this.comp != null) {
            children.add(this.comp);
        }
        if (this.expandOrLimitRecurrenceSet != null) {
            String elemName = EXPAND.equals(this.expandOrLimitRecurrenceSet) ? ELEM_EXPAND_RECURRENCE_SET : ELEM_LIMIT_RECURRENCE_SET;
            PropProperty expandOrLimitElement = new PropProperty(elemName, CalDAVConstants.NAMESPACE_CALDAV);
            expandOrLimitElement.addAttribute(ATTR_START, this.recurrenceSetStart.toString());
            expandOrLimitElement.addAttribute(ATTR_END, this.recurrenceSetEnd.toString());
            children.add((Object)expandOrLimitElement);
        }
        return children;
    }

    @Override
    protected String getTextContent() {
        return null;
    }

    @Override
    protected Map<String, String> getAttributes() {
        return null;
    }

    @Override
    public void validate() throws DOMValidationException {
        if (this.expandOrLimitRecurrenceSet != null && (this.recurrenceSetStart == null || this.recurrenceSetEnd == null)) {
            this.throwValidationException("If you specify expand-recurrence-set or limit-recurrence-set you must specify a start and end date");
        }
        if (this.comp != null) {
            this.comp.validate();
        }
    }
}

