/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.client;

import com.rabbitmq.client.ConnectionFactory;
import com.rabbitmq.client.impl.AMQConnection;
import com.rabbitmq.client.impl.nio.NioParams;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URISyntaxException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class ConnectionFactoryConfigurator {
    public static final String DEFAULT_PREFIX = "rabbitmq.";
    public static final String USERNAME = "username";
    public static final String PASSWORD = "password";
    public static final String VIRTUAL_HOST = "virtual.host";
    public static final String HOST = "host";
    public static final String PORT = "port";
    public static final String CONNECTION_CHANNEL_MAX = "connection.channel.max";
    public static final String CONNECTION_FRAME_MAX = "connection.frame.max";
    public static final String CONNECTION_HEARTBEAT = "connection.heartbeat";
    public static final String CONNECTION_TIMEOUT = "connection.timeout";
    public static final String HANDSHAKE_TIMEOUT = "handshake.timeout";
    public static final String SHUTDOWN_TIMEOUT = "shutdown.timeout";
    public static final String USE_DEFAULT_CLIENT_PROPERTIES = "use.default.client.properties";
    public static final String CLIENT_PROPERTIES_PREFIX = "client.properties.";
    public static final String CONNECTION_RECOVERY_ENABLED = "connection.recovery.enabled";
    public static final String TOPOLOGY_RECOVERY_ENABLED = "topology.recovery.enabled";
    public static final String CONNECTION_RECOVERY_INTERVAL = "connection.recovery.interval";
    public static final String CHANNEL_RPC_TIMEOUT = "channel.rpc.timeout";
    public static final String CHANNEL_SHOULD_CHECK_RPC_RESPONSE_TYPE = "channel.should.check.rpc.response.type";
    public static final String USE_NIO = "use.nio";
    public static final String NIO_READ_BYTE_BUFFER_SIZE = "nio.read.byte.buffer.size";
    public static final String NIO_WRITE_BYTE_BUFFER_SIZE = "nio.write.byte.buffer.size";
    public static final String NIO_NB_IO_THREADS = "nio.nb.io.threads";
    public static final String NIO_WRITE_ENQUEUING_TIMEOUT_IN_MS = "nio.write.enqueuing.timeout.in.ms";
    public static final String NIO_WRITE_QUEUE_CAPACITY = "nio.write.queue.capacity";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void load(ConnectionFactory cf, String propertyFileLocation, String prefix) throws IOException {
        if (propertyFileLocation == null || propertyFileLocation.isEmpty()) {
            throw new IllegalArgumentException("Property file argument cannot be null or empty");
        }
        Properties properties = new Properties();
        if (propertyFileLocation.startsWith("classpath:")) {
            try (InputStream in = null;){
                in = ConnectionFactoryConfigurator.class.getResourceAsStream(propertyFileLocation.substring("classpath:".length()));
                properties.load(in);
            }
        }
        try (Reader reader = null;){
            reader = new BufferedReader(new FileReader(propertyFileLocation));
            properties.load(reader);
        }
        ConnectionFactoryConfigurator.load(cf, (Map<String, String>)properties, prefix);
    }

    public static void load(ConnectionFactory cf, Map<String, String> properties, String prefix) {
        String useNio;
        String channelShouldCheckRpcResponseType;
        String channelRpcTimeout;
        String networkRecoveryInterval;
        String topologyRecovery;
        String shutdownTimeout;
        String handshakeTimeout;
        String connectionTimeout;
        String requestedHeartbeat;
        String requestedFrameMax;
        String requestedChannelMax;
        String port;
        String host;
        String vhost;
        String password;
        String username;
        String uri = properties.get((prefix = prefix == null ? "" : prefix) + "uri");
        if (uri != null) {
            try {
                cf.setUri(uri);
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException("Error while setting AMQP URI: " + uri, e);
            }
            catch (NoSuchAlgorithmException e) {
                throw new IllegalArgumentException("Error while setting AMQP URI: " + uri, e);
            }
            catch (KeyManagementException e) {
                throw new IllegalArgumentException("Error while setting AMQP URI: " + uri, e);
            }
        }
        if ((username = properties.get(prefix + USERNAME)) != null) {
            cf.setUsername(username);
        }
        if ((password = properties.get(prefix + PASSWORD)) != null) {
            cf.setPassword(password);
        }
        if ((vhost = properties.get(prefix + VIRTUAL_HOST)) != null) {
            cf.setVirtualHost(vhost);
        }
        if ((host = properties.get(prefix + HOST)) != null) {
            cf.setHost(host);
        }
        if ((port = properties.get(prefix + PORT)) != null) {
            cf.setPort(Integer.valueOf(port));
        }
        if ((requestedChannelMax = properties.get(prefix + CONNECTION_CHANNEL_MAX)) != null) {
            cf.setRequestedChannelMax(Integer.valueOf(requestedChannelMax));
        }
        if ((requestedFrameMax = properties.get(prefix + CONNECTION_FRAME_MAX)) != null) {
            cf.setRequestedFrameMax(Integer.valueOf(requestedFrameMax));
        }
        if ((requestedHeartbeat = properties.get(prefix + CONNECTION_HEARTBEAT)) != null) {
            cf.setRequestedHeartbeat(Integer.valueOf(requestedHeartbeat));
        }
        if ((connectionTimeout = properties.get(prefix + CONNECTION_TIMEOUT)) != null) {
            cf.setConnectionTimeout(Integer.valueOf(connectionTimeout));
        }
        if ((handshakeTimeout = properties.get(prefix + HANDSHAKE_TIMEOUT)) != null) {
            cf.setHandshakeTimeout(Integer.valueOf(handshakeTimeout));
        }
        if ((shutdownTimeout = properties.get(prefix + SHUTDOWN_TIMEOUT)) != null) {
            cf.setShutdownTimeout(Integer.valueOf(shutdownTimeout));
        }
        HashMap<String, Object> clientProperties = new HashMap<String, Object>();
        String useDefaultClientProperties = properties.get(prefix + USE_DEFAULT_CLIENT_PROPERTIES);
        if (useDefaultClientProperties != null && Boolean.valueOf(useDefaultClientProperties).booleanValue()) {
            clientProperties.putAll(AMQConnection.defaultClientProperties());
        }
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            if (!entry.getKey().startsWith(prefix + CLIENT_PROPERTIES_PREFIX)) continue;
            clientProperties.put(entry.getKey().substring((prefix + CLIENT_PROPERTIES_PREFIX).length()), entry.getValue());
        }
        cf.setClientProperties(clientProperties);
        String automaticRecovery = properties.get(prefix + CONNECTION_RECOVERY_ENABLED);
        if (automaticRecovery != null) {
            cf.setAutomaticRecoveryEnabled(Boolean.valueOf(automaticRecovery));
        }
        if ((topologyRecovery = properties.get(prefix + TOPOLOGY_RECOVERY_ENABLED)) != null) {
            cf.setTopologyRecoveryEnabled(Boolean.getBoolean(topologyRecovery));
        }
        if ((networkRecoveryInterval = properties.get(prefix + CONNECTION_RECOVERY_INTERVAL)) != null) {
            cf.setNetworkRecoveryInterval(Long.valueOf(networkRecoveryInterval));
        }
        if ((channelRpcTimeout = properties.get(prefix + CHANNEL_RPC_TIMEOUT)) != null) {
            cf.setChannelRpcTimeout(Integer.valueOf(channelRpcTimeout));
        }
        if ((channelShouldCheckRpcResponseType = properties.get(prefix + CHANNEL_SHOULD_CHECK_RPC_RESPONSE_TYPE)) != null) {
            cf.setChannelShouldCheckRpcResponseType(Boolean.valueOf(channelShouldCheckRpcResponseType));
        }
        if ((useNio = properties.get(prefix + USE_NIO)) != null && Boolean.valueOf(useNio).booleanValue()) {
            String writeQueueCapacity;
            String writeEnqueuingTime;
            String nbIoThreads;
            String writeByteBufferSize;
            cf.useNio();
            NioParams nioParams = new NioParams();
            String readByteBufferSize = properties.get(prefix + NIO_READ_BYTE_BUFFER_SIZE);
            if (readByteBufferSize != null) {
                nioParams.setReadByteBufferSize(Integer.valueOf(readByteBufferSize));
            }
            if ((writeByteBufferSize = properties.get(prefix + NIO_WRITE_BYTE_BUFFER_SIZE)) != null) {
                nioParams.setWriteByteBufferSize(Integer.valueOf(writeByteBufferSize));
            }
            if ((nbIoThreads = properties.get(prefix + NIO_NB_IO_THREADS)) != null) {
                nioParams.setNbIoThreads(Integer.valueOf(nbIoThreads));
            }
            if ((writeEnqueuingTime = properties.get(prefix + NIO_WRITE_ENQUEUING_TIMEOUT_IN_MS)) != null) {
                nioParams.setWriteEnqueuingTimeoutInMs(Integer.valueOf(writeEnqueuingTime));
            }
            if ((writeQueueCapacity = properties.get(prefix + NIO_WRITE_QUEUE_CAPACITY)) != null) {
                nioParams.setWriteQueueCapacity(Integer.valueOf(writeQueueCapacity));
            }
            cf.setNioParams(nioParams);
        }
    }

    public static void load(ConnectionFactory connectionFactory, String propertyFileLocation) throws IOException {
        ConnectionFactoryConfigurator.load(connectionFactory, propertyFileLocation, DEFAULT_PREFIX);
    }

    public static void load(ConnectionFactory connectionFactory, Properties properties) {
        ConnectionFactoryConfigurator.load(connectionFactory, (Map<String, String>)properties, DEFAULT_PREFIX);
    }

    public static void load(ConnectionFactory connectionFactory, Properties properties, String prefix) {
        ConnectionFactoryConfigurator.load(connectionFactory, (Map<String, String>)properties, prefix);
    }

    public static void load(ConnectionFactory connectionFactory, Map<String, String> properties) {
        ConnectionFactoryConfigurator.load(connectionFactory, properties, DEFAULT_PREFIX);
    }
}

