/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.response;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Map;
import org.apache.solr.client.solrj.ResponseParser;
import org.apache.solr.client.solrj.response.SolrResponseBase;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.util.NamedList;
import org.noggit.JSONParser;
import org.noggit.ObjectBuilder;

public abstract class DelegationTokenResponse
extends SolrResponseBase {

    public static class JsonMapResponseParser
    extends ResponseParser {
        @Override
        public String getWriterType() {
            return "json";
        }

        @Override
        public NamedList<Object> processResponse(InputStream body, String encoding) {
            Map map = null;
            try {
                ObjectBuilder builder = new ObjectBuilder(new JSONParser(new InputStreamReader(body, encoding == null ? "UTF-8" : encoding)));
                map = (Map)builder.getObject();
            }
            catch (IOException | JSONParser.ParseException e) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "parsing error", (Throwable)e);
            }
            NamedList<Object> list = new NamedList<Object>();
            list.addAll(map);
            return list;
        }

        @Override
        public NamedList<Object> processResponse(Reader reader) {
            throw new RuntimeException("Cannot handle character stream");
        }

        @Override
        public String getContentType() {
            return "application/json";
        }

        @Override
        public String getVersion() {
            return "1";
        }
    }

    public static class Cancel
    extends DelegationTokenResponse {
    }

    public static class Renew
    extends DelegationTokenResponse {
        public Long getExpirationTime() {
            try {
                return (Long)this.getResponse().get("long");
            }
            catch (ClassCastException e) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "parsing error", (Throwable)e);
            }
        }
    }

    public static class Get
    extends DelegationTokenResponse {
        public String getDelegationToken() {
            try {
                Map map = (Map)this.getResponse().get("Token");
                if (map != null) {
                    return (String)map.get("urlString");
                }
            }
            catch (ClassCastException e) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "parsing error", (Throwable)e);
            }
            return null;
        }
    }
}

