/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.api.configuration;

import java.io.File;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import lombok.Generated;
import org.flywaydb.core.Flyway;
import org.flywaydb.core.ProgressLogger;
import org.flywaydb.core.api.ClassProvider;
import org.flywaydb.core.api.Location;
import org.flywaydb.core.api.MigrationPattern;
import org.flywaydb.core.api.MigrationVersion;
import org.flywaydb.core.api.ResourceProvider;
import org.flywaydb.core.api.callback.Callback;
import org.flywaydb.core.api.configuration.ClassicConfiguration;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.api.migration.JavaMigration;
import org.flywaydb.core.api.pattern.ValidatePattern;
import org.flywaydb.core.api.resolver.MigrationResolver;
import org.flywaydb.core.extensibility.ConfigurationExtension;
import org.flywaydb.core.internal.configuration.ConfigUtils;
import org.flywaydb.core.internal.configuration.models.ConfigurationModel;
import org.flywaydb.core.internal.configuration.models.DataSourceModel;
import org.flywaydb.core.internal.configuration.models.EnvironmentModel;
import org.flywaydb.core.internal.configuration.models.ResolvedEnvironment;
import org.flywaydb.core.internal.configuration.resolvers.ProvisionerMode;
import org.flywaydb.core.internal.database.DatabaseType;
import org.flywaydb.core.internal.plugin.PluginRegister;
import org.flywaydb.core.internal.util.ClassUtils;

public class FluentConfiguration
implements Configuration {
    private final ClassicConfiguration config;

    public FluentConfiguration() {
        this.config = new ClassicConfiguration();
    }

    public FluentConfiguration(ClassLoader classLoader) {
        this.config = new ClassicConfiguration(classLoader);
    }

    public Flyway load() {
        return new Flyway(this);
    }

    public FluentConfiguration configuration(Configuration configuration) {
        this.config.configure(configuration);
        return this;
    }

    public FluentConfiguration dryRunOutput(OutputStream dryRunOutput) {
        this.config.setDryRunOutput(dryRunOutput);
        return this;
    }

    public FluentConfiguration dryRunOutput(File dryRunOutput) {
        this.config.setDryRunOutputAsFile(dryRunOutput);
        return this;
    }

    public FluentConfiguration dryRunOutput(String dryRunOutputFileName) {
        this.config.setDryRunOutputAsFileName(dryRunOutputFileName);
        return this;
    }

    public FluentConfiguration reportFilename(String reportFilename) {
        this.config.setReportFilename(reportFilename);
        return this;
    }

    public FluentConfiguration environment(String environment) {
        this.config.setEnvironment(environment);
        return this;
    }

    public FluentConfiguration allEnvironments(Map<String, EnvironmentModel> environments) {
        this.config.setAllEnvironments(environments);
        return this;
    }

    public FluentConfiguration provisionMode(ProvisionerMode mode) {
        this.config.setProvisionMode(mode);
        return this;
    }

    public FluentConfiguration environmentProvisionMode(ProvisionerMode mode) {
        return this.provisionMode(mode);
    }

    public FluentConfiguration workingDirectory(String workingDirectory) {
        this.config.setWorkingDirectory(workingDirectory);
        return this;
    }

    public FluentConfiguration clearCachedResolvedEnvironment(String environmentName) {
        this.config.requestResolvedEnvironmentRefresh(environmentName);
        return this;
    }

    public FluentConfiguration errorOverrides(String ... errorOverrides) {
        this.config.setErrorOverrides(errorOverrides);
        return this;
    }

    public FluentConfiguration group(boolean group) {
        this.config.setGroup(group);
        return this;
    }

    public FluentConfiguration installedBy(String installedBy) {
        this.config.setInstalledBy(installedBy);
        return this;
    }

    public FluentConfiguration loggers(String ... loggers) {
        this.config.setLoggers(loggers);
        return this;
    }

    public FluentConfiguration mixed(boolean mixed) {
        this.config.setMixed(mixed);
        return this;
    }

    public FluentConfiguration ignoreMigrationPatterns(String ... ignoreMigrationPatterns) {
        this.config.setIgnoreMigrationPatterns(ignoreMigrationPatterns);
        return this;
    }

    public FluentConfiguration ignoreMigrationPatterns(ValidatePattern ... ignoreMigrationPatterns) {
        this.config.setIgnoreMigrationPatterns(ignoreMigrationPatterns);
        return this;
    }

    public FluentConfiguration validateMigrationNaming(boolean validateMigrationNaming) {
        this.config.setValidateMigrationNaming(validateMigrationNaming);
        return this;
    }

    public FluentConfiguration validateOnMigrate(boolean validateOnMigrate) {
        this.config.setValidateOnMigrate(validateOnMigrate);
        return this;
    }

    public FluentConfiguration cleanDisabled(boolean cleanDisabled) {
        this.config.setCleanDisabled(cleanDisabled);
        return this;
    }

    public FluentConfiguration communityDBSupportEnabled(boolean communityDBSupportEnabled) {
        this.config.setCommunityDBSupportEnabled(communityDBSupportEnabled);
        return this;
    }

    public FluentConfiguration locations(String ... locations) {
        this.config.setLocationsAsStrings(locations);
        return this;
    }

    public FluentConfiguration callbackLocations(String ... callbackLocations) {
        this.config.setCallbackLocationsAsStrings(callbackLocations);
        return this;
    }

    public FluentConfiguration locations(Location ... locations) {
        this.config.setLocations(locations);
        return this;
    }

    public FluentConfiguration callbackLocations(Location ... callbackLocations) {
        this.config.setCallbackLocations(callbackLocations);
        return this;
    }

    public FluentConfiguration encoding(String encoding) {
        this.config.setEncodingAsString(encoding);
        return this;
    }

    public FluentConfiguration encoding(Charset encoding) {
        this.config.setEncoding(encoding);
        return this;
    }

    public FluentConfiguration executeInTransaction(boolean executeInTransaction) {
        this.config.setExecuteInTransaction(executeInTransaction);
        return this;
    }

    public FluentConfiguration detectEncoding(boolean detectEncoding) {
        this.config.setDetectEncoding(detectEncoding);
        return this;
    }

    public FluentConfiguration defaultSchema(String schema) {
        this.config.setDefaultSchema(schema);
        return this;
    }

    public FluentConfiguration schemas(String ... schemas) {
        this.config.setSchemas(schemas);
        return this;
    }

    public FluentConfiguration table(String table) {
        this.config.setTable(table);
        return this;
    }

    public FluentConfiguration tablespace(String tablespace) {
        this.config.setTablespace(tablespace);
        return this;
    }

    public FluentConfiguration target(MigrationVersion target) {
        this.config.setTarget(target);
        return this;
    }

    public FluentConfiguration target(String target) {
        this.config.setTargetAsString(target);
        return this;
    }

    public FluentConfiguration placeholderReplacement(boolean placeholderReplacement) {
        this.config.setPlaceholderReplacement(placeholderReplacement);
        return this;
    }

    public FluentConfiguration placeholders(Map<String, String> placeholders) {
        this.config.setPlaceholders(placeholders);
        return this;
    }

    public FluentConfiguration placeholderPrefix(String placeholderPrefix) {
        this.config.setPlaceholderPrefix(placeholderPrefix);
        return this;
    }

    public FluentConfiguration placeholderSuffix(String placeholderSuffix) {
        this.config.setPlaceholderSuffix(placeholderSuffix);
        return this;
    }

    public FluentConfiguration placeholderSeparator(String placeholderSeparator) {
        this.config.setPlaceholderSeparator(placeholderSeparator);
        return this;
    }

    public FluentConfiguration scriptPlaceholderPrefix(String scriptPlaceholderPrefix) {
        this.config.setScriptPlaceholderPrefix(scriptPlaceholderPrefix);
        return this;
    }

    public FluentConfiguration scriptPlaceholderSuffix(String scriptPlaceholderSuffix) {
        this.config.setScriptPlaceholderSuffix(scriptPlaceholderSuffix);
        return this;
    }

    public FluentConfiguration powershellExecutable(String powershellExecutable) {
        this.config.setPowershellExecutable(powershellExecutable);
        return this;
    }

    public FluentConfiguration sqlMigrationPrefix(String sqlMigrationPrefix) {
        this.config.setSqlMigrationPrefix(sqlMigrationPrefix);
        return this;
    }

    public FluentConfiguration repeatableSqlMigrationPrefix(String repeatableSqlMigrationPrefix) {
        this.config.setRepeatableSqlMigrationPrefix(repeatableSqlMigrationPrefix);
        return this;
    }

    public FluentConfiguration sqlMigrationSeparator(String sqlMigrationSeparator) {
        this.config.setSqlMigrationSeparator(sqlMigrationSeparator);
        return this;
    }

    public FluentConfiguration sqlMigrationSuffixes(String ... sqlMigrationSuffixes) {
        this.config.setSqlMigrationSuffixes(sqlMigrationSuffixes);
        return this;
    }

    public FluentConfiguration javaMigrations(JavaMigration ... javaMigrations) {
        this.config.setJavaMigrations(javaMigrations);
        return this;
    }

    public FluentConfiguration dataSource(DataSource dataSource) {
        this.config.setDataSource(dataSource);
        return this;
    }

    public FluentConfiguration dataSource(String url, String user, String password) {
        this.config.setDataSource(url, user, password);
        return this;
    }

    public FluentConfiguration connectRetries(int connectRetries) {
        this.config.setConnectRetries(connectRetries);
        return this;
    }

    public FluentConfiguration connectRetriesInterval(int connectRetriesInterval) {
        this.config.setConnectRetriesInterval(connectRetriesInterval);
        return this;
    }

    public FluentConfiguration initSql(String initSql) {
        this.config.setInitSql(initSql);
        return this;
    }

    public FluentConfiguration baselineVersion(MigrationVersion baselineVersion) {
        this.config.setBaselineVersion(baselineVersion);
        return this;
    }

    public FluentConfiguration baselineVersion(String baselineVersion) {
        this.config.setBaselineVersion(baselineVersion);
        return this;
    }

    public FluentConfiguration baselineDescription(String baselineDescription) {
        this.config.setBaselineDescription(baselineDescription);
        return this;
    }

    public FluentConfiguration baselineOnMigrate(boolean baselineOnMigrate) {
        this.config.setBaselineOnMigrate(baselineOnMigrate);
        return this;
    }

    public FluentConfiguration outOfOrder(boolean outOfOrder) {
        this.config.setOutOfOrder(outOfOrder);
        return this;
    }

    public FluentConfiguration skipExecutingMigrations(boolean skipExecutingMigrations) {
        this.config.setSkipExecutingMigrations(skipExecutingMigrations);
        return this;
    }

    public FluentConfiguration callbacks(Callback ... callbacks) {
        this.config.setCallbacks(callbacks);
        return this;
    }

    public FluentConfiguration callbacks(String ... callbacks) {
        this.config.setCallbacksAsClassNames(callbacks);
        return this;
    }

    public FluentConfiguration skipDefaultCallbacks(boolean skipDefaultCallbacks) {
        this.config.setSkipDefaultCallbacks(skipDefaultCallbacks);
        return this;
    }

    public FluentConfiguration resolvers(MigrationResolver ... resolvers) {
        this.config.setResolvers(resolvers);
        return this;
    }

    public FluentConfiguration resolvers(String ... resolvers) {
        this.config.setResolversAsClassNames(resolvers);
        return this;
    }

    public FluentConfiguration skipDefaultResolvers(boolean skipDefaultResolvers) {
        this.config.setSkipDefaultResolvers(skipDefaultResolvers);
        return this;
    }

    public FluentConfiguration stream(boolean stream) {
        this.config.setStream(stream);
        return this;
    }

    public FluentConfiguration batch(boolean batch) {
        this.config.setBatch(batch);
        return this;
    }

    public FluentConfiguration lockRetryCount(int lockRetryCount) {
        this.config.setLockRetryCount(lockRetryCount);
        return this;
    }

    public FluentConfiguration jdbcProperties(Map<String, String> jdbcProperties) {
        this.config.setJdbcProperties(jdbcProperties);
        return this;
    }

    public FluentConfiguration kerberosConfigFile(String kerberosConfigFile) {
        this.config.setKerberosConfigFile(kerberosConfigFile);
        return this;
    }

    public FluentConfiguration resourceProvider(ResourceProvider resourceProvider) {
        this.config.setResourceProvider(resourceProvider);
        return this;
    }

    public FluentConfiguration javaMigrationClassProvider(ClassProvider<JavaMigration> javaMigrationClassProvider) {
        this.config.setJavaMigrationClassProvider(javaMigrationClassProvider);
        return this;
    }

    public FluentConfiguration outputQueryResults(boolean outputQueryResults) {
        this.config.setOutputQueryResults(outputQueryResults);
        return this;
    }

    public FluentConfiguration configuration(Properties properties) {
        this.config.configure(properties);
        return this;
    }

    public FluentConfiguration configuration(Map<String, String> props) {
        this.config.configure(props);
        return this;
    }

    public FluentConfiguration loadDefaultConfigurationFiles() {
        return this.loadDefaultConfigurationFiles("UTF-8");
    }

    public FluentConfiguration loadDefaultConfigurationFiles(String encoding) {
        String installationPath = ClassUtils.getLocationOnDisk(FluentConfiguration.class);
        File installationDir = new File(installationPath).getParentFile();
        String workingDirectory = this.getWorkingDirectory() != null ? this.getWorkingDirectory() : null;
        Map<String, String> configMap = ConfigUtils.loadDefaultConfigurationFiles(installationDir, workingDirectory, encoding);
        this.config.configure(configMap);
        return this;
    }

    public FluentConfiguration createSchemas(boolean createSchemas) {
        this.config.setShouldCreateSchemas(createSchemas);
        return this;
    }

    public FluentConfiguration envVars() {
        this.config.configureUsingEnvVars();
        return this;
    }

    public FluentConfiguration failOnMissingLocations(boolean failOnMissingLocations) {
        this.config.setFailOnMissingLocations(failOnMissingLocations);
        return this;
    }

    public FluentConfiguration driver(String driver) {
        this.config.setDriver(driver);
        return this;
    }

    @Override
    @Generated
    public ConfigurationModel getModernConfig() {
        return this.config.getModernConfig();
    }

    @Override
    @Generated
    public ClassLoader getClassLoader() {
        return this.config.getClassLoader();
    }

    @Override
    @Generated
    public PluginRegister getPluginRegister() {
        return this.config.getPluginRegister();
    }

    @Override
    @Generated
    public <T extends ConfigurationExtension> T getConfigurationExtension(Class<T> extensionClass) {
        return this.config.getConfigurationExtension(extensionClass);
    }

    @Override
    @Generated
    public String getReportFilename() {
        return this.config.getReportFilename();
    }

    @Override
    @Generated
    public boolean isReportEnabled() {
        return this.config.isReportEnabled();
    }

    @Override
    @Generated
    public String getUrl() {
        return this.config.getUrl();
    }

    @Override
    @Generated
    public String getWorkingDirectory() {
        return this.config.getWorkingDirectory();
    }

    @Override
    @Generated
    public String getUser() {
        return this.config.getUser();
    }

    @Override
    @Generated
    public String getPassword() {
        return this.config.getPassword();
    }

    @Override
    @Generated
    public DataSource getDataSource() {
        return this.config.getDataSource();
    }

    @Override
    @Generated
    public int getConnectRetries() {
        return this.config.getConnectRetries();
    }

    @Override
    @Generated
    public int getConnectRetriesInterval() {
        return this.config.getConnectRetriesInterval();
    }

    @Override
    @Generated
    public String getInitSql() {
        return this.config.getInitSql();
    }

    @Override
    @Generated
    public MigrationVersion getBaselineVersion() {
        return this.config.getBaselineVersion();
    }

    @Override
    @Generated
    public String getBaselineDescription() {
        return this.config.getBaselineDescription();
    }

    @Override
    @Generated
    public MigrationResolver[] getResolvers() {
        return this.config.getResolvers();
    }

    @Override
    @Generated
    public boolean isSkipDefaultResolvers() {
        return this.config.isSkipDefaultResolvers();
    }

    @Override
    @Generated
    public Callback[] getCallbacks() {
        return this.config.getCallbacks();
    }

    @Override
    @Generated
    public boolean isSkipDefaultCallbacks() {
        return this.config.isSkipDefaultCallbacks();
    }

    @Override
    @Generated
    public String getSqlMigrationPrefix() {
        return this.config.getSqlMigrationPrefix();
    }

    @Override
    @Generated
    public boolean isExecuteInTransaction() {
        return this.config.isExecuteInTransaction();
    }

    @Override
    @Generated
    public String getRepeatableSqlMigrationPrefix() {
        return this.config.getRepeatableSqlMigrationPrefix();
    }

    @Override
    @Generated
    public String getSqlMigrationSeparator() {
        return this.config.getSqlMigrationSeparator();
    }

    @Override
    @Generated
    public String[] getSqlMigrationSuffixes() {
        return this.config.getSqlMigrationSuffixes();
    }

    @Override
    @Generated
    public JavaMigration[] getJavaMigrations() {
        return this.config.getJavaMigrations();
    }

    @Override
    @Generated
    public boolean isPlaceholderReplacement() {
        return this.config.isPlaceholderReplacement();
    }

    @Override
    @Generated
    public String getPlaceholderSuffix() {
        return this.config.getPlaceholderSuffix();
    }

    @Override
    @Generated
    public String getPlaceholderPrefix() {
        return this.config.getPlaceholderPrefix();
    }

    @Override
    @Generated
    public String getPlaceholderSeparator() {
        return this.config.getPlaceholderSeparator();
    }

    @Override
    @Generated
    public String getScriptPlaceholderSuffix() {
        return this.config.getScriptPlaceholderSuffix();
    }

    @Override
    @Generated
    public String getScriptPlaceholderPrefix() {
        return this.config.getScriptPlaceholderPrefix();
    }

    @Override
    @Generated
    public String getPowershellExecutable() {
        return this.config.getPowershellExecutable();
    }

    @Override
    @Generated
    public Map<String, String> getPlaceholders() {
        return this.config.getPlaceholders();
    }

    @Override
    @Generated
    public MigrationVersion getTarget() {
        return this.config.getTarget();
    }

    @Override
    @Generated
    public boolean isFailOnMissingTarget() {
        return this.config.isFailOnMissingTarget();
    }

    @Override
    @Generated
    public MigrationPattern[] getCherryPick() {
        return this.config.getCherryPick();
    }

    @Override
    @Generated
    public String getTable() {
        return this.config.getTable();
    }

    @Override
    @Generated
    public String getTablespace() {
        return this.config.getTablespace();
    }

    @Override
    @Generated
    public String getDefaultSchema() {
        return this.config.getDefaultSchema();
    }

    @Override
    @Generated
    public String[] getSchemas() {
        return this.config.getSchemas();
    }

    @Override
    @Generated
    public Charset getEncoding() {
        return this.config.getEncoding();
    }

    @Override
    @Generated
    public boolean isDetectEncoding() {
        return this.config.isDetectEncoding();
    }

    @Override
    @Generated
    public Location[] getLocations() {
        return this.config.getLocations();
    }

    @Override
    @Generated
    public Location[] getCallbackLocations() {
        return this.config.getCallbackLocations();
    }

    @Override
    @Generated
    public boolean isBaselineOnMigrate() {
        return this.config.isBaselineOnMigrate();
    }

    @Override
    @Generated
    public boolean isSkipExecutingMigrations() {
        return this.config.isSkipExecutingMigrations();
    }

    @Override
    @Generated
    public boolean isOutOfOrder() {
        return this.config.isOutOfOrder();
    }

    @Override
    @Generated
    public ValidatePattern[] getIgnoreMigrationPatterns() {
        return this.config.getIgnoreMigrationPatterns();
    }

    @Override
    @Generated
    public boolean isValidateMigrationNaming() {
        return this.config.isValidateMigrationNaming();
    }

    @Override
    @Generated
    public boolean isValidateOnMigrate() {
        return this.config.isValidateOnMigrate();
    }

    @Override
    @Generated
    public boolean isCleanDisabled() {
        return this.config.isCleanDisabled();
    }

    @Override
    @Generated
    public boolean isCommunityDBSupportEnabled() {
        return this.config.isCommunityDBSupportEnabled();
    }

    @Override
    @Generated
    public boolean isMixed() {
        return this.config.isMixed();
    }

    @Override
    @Generated
    public boolean isGroup() {
        return this.config.isGroup();
    }

    @Override
    @Generated
    public String getInstalledBy() {
        return this.config.getInstalledBy();
    }

    @Override
    @Generated
    public String[] getErrorOverrides() {
        return this.config.getErrorOverrides();
    }

    @Override
    @Generated
    public OutputStream getDryRunOutput() {
        return this.config.getDryRunOutput();
    }

    @Override
    @Generated
    public boolean isStream() {
        return this.config.isStream();
    }

    @Override
    @Generated
    public boolean isBatch() {
        return this.config.isBatch();
    }

    @Override
    @Generated
    public String getKerberosConfigFile() {
        return this.config.getKerberosConfigFile();
    }

    @Override
    @Generated
    public boolean isOutputQueryResults() {
        return this.config.isOutputQueryResults();
    }

    @Override
    @Generated
    public ResourceProvider getResourceProvider() {
        return this.config.getResourceProvider();
    }

    @Override
    @Generated
    public ClassProvider<JavaMigration> getJavaMigrationClassProvider() {
        return this.config.getJavaMigrationClassProvider();
    }

    @Override
    @Generated
    public boolean isCreateSchemas() {
        return this.config.isCreateSchemas();
    }

    @Override
    @Generated
    public int getLockRetryCount() {
        return this.config.getLockRetryCount();
    }

    @Override
    @Generated
    public Map<String, String> getJdbcProperties() {
        return this.config.getJdbcProperties();
    }

    @Override
    @Generated
    public boolean isFailOnMissingLocations() {
        return this.config.isFailOnMissingLocations();
    }

    @Override
    @Generated
    public String[] getLoggers() {
        return this.config.getLoggers();
    }

    @Override
    @Generated
    public String getDriver() {
        return this.config.getDriver();
    }

    @Override
    @Generated
    public DatabaseType getDatabaseType() {
        return this.config.getDatabaseType();
    }

    @Override
    @Generated
    public Map<String, ResolvedEnvironment> getCachedResolvedEnvironments() {
        return this.config.getCachedResolvedEnvironments();
    }

    @Override
    @Generated
    public Map<String, DataSourceModel> getCachedDataSources() {
        return this.config.getCachedDataSources();
    }

    @Override
    @Generated
    public String getCurrentEnvironmentName() {
        return this.config.getCurrentEnvironmentName();
    }

    @Override
    @Generated
    public ProgressLogger createProgress(String operationName) {
        return this.config.createProgress(operationName);
    }

    @Override
    @Generated
    public ResolvedEnvironment getResolvedEnvironment(String envName, ProvisionerMode provisionerMode, ProgressLogger progress) {
        return this.config.getResolvedEnvironment(envName, provisionerMode, progress);
    }
}

