/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry.client.impl;

import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.extension.manifest.Extension;
import org.apache.nifi.registry.client.BundleVersionClient;
import org.apache.nifi.registry.client.NiFiRegistryException;
import org.apache.nifi.registry.client.RequestConfig;
import org.apache.nifi.registry.client.impl.AbstractJerseyClient;
import org.apache.nifi.registry.client.impl.ClientUtils;
import org.apache.nifi.registry.extension.bundle.BundleType;
import org.apache.nifi.registry.extension.bundle.BundleVersion;
import org.apache.nifi.registry.extension.bundle.BundleVersionFilterParams;
import org.apache.nifi.registry.extension.bundle.BundleVersionMetadata;
import org.apache.nifi.registry.extension.component.ExtensionMetadata;
import org.glassfish.jersey.media.multipart.BodyPart;
import org.glassfish.jersey.media.multipart.FormDataMultiPart;
import org.glassfish.jersey.media.multipart.file.FileDataBodyPart;
import org.glassfish.jersey.media.multipart.file.StreamDataBodyPart;

public class JerseyBundleVersionClient
extends AbstractJerseyClient
implements BundleVersionClient {
    private final WebTarget bucketExtensionBundlesTarget;
    private final WebTarget extensionBundlesTarget;

    public JerseyBundleVersionClient(WebTarget baseTarget) {
        this(baseTarget, null);
    }

    public JerseyBundleVersionClient(WebTarget baseTarget, RequestConfig requestConfig) {
        super(requestConfig);
        this.bucketExtensionBundlesTarget = baseTarget.path("buckets/{bucketId}/bundles");
        this.extensionBundlesTarget = baseTarget.path("bundles");
    }

    @Override
    public BundleVersion create(String bucketId, BundleType bundleType, InputStream bundleContentStream) throws IOException, NiFiRegistryException {
        return this.create(bucketId, bundleType, bundleContentStream, null);
    }

    @Override
    public BundleVersion create(String bucketId, BundleType bundleType, InputStream bundleContentStream, String sha256) throws IOException, NiFiRegistryException {
        if (StringUtils.isBlank((CharSequence)bucketId)) {
            throw new IllegalArgumentException("Bucket id cannot be null or blank");
        }
        if (bundleType == null) {
            throw new IllegalArgumentException("Bundle type cannot be null");
        }
        if (bundleContentStream == null) {
            throw new IllegalArgumentException("Bundle content cannot be null");
        }
        return this.executeAction("Error creating extension bundle version", () -> {
            WebTarget target = this.bucketExtensionBundlesTarget.path("{bundleType}").resolveTemplate("bucketId", (Object)bucketId).resolveTemplate("bundleType", (Object)bundleType.toString());
            StreamDataBodyPart streamBodyPart = new StreamDataBodyPart("file", bundleContentStream);
            FormDataMultiPart multipart = new FormDataMultiPart();
            multipart.bodyPart((BodyPart)streamBodyPart);
            if (!StringUtils.isBlank((CharSequence)sha256)) {
                multipart.field("sha256", sha256);
            }
            return (BundleVersion)this.getRequestBuilder(target).post(Entity.entity((Object)multipart, (MediaType)multipart.getMediaType()), BundleVersion.class);
        });
    }

    @Override
    public BundleVersion create(String bucketId, BundleType bundleType, File bundleFile) throws IOException, NiFiRegistryException {
        return this.create(bucketId, bundleType, bundleFile, null);
    }

    @Override
    public BundleVersion create(String bucketId, BundleType bundleType, File bundleFile, String sha256) throws IOException, NiFiRegistryException {
        if (StringUtils.isBlank((CharSequence)bucketId)) {
            throw new IllegalArgumentException("Bucket id cannot be null or blank");
        }
        if (bundleType == null) {
            throw new IllegalArgumentException("Bundle type cannot be null");
        }
        if (bundleFile == null) {
            throw new IllegalArgumentException("Bundle file cannot be null");
        }
        return this.executeAction("Error creating extension bundle version", () -> {
            WebTarget target = this.bucketExtensionBundlesTarget.path("{bundleType}").resolveTemplate("bucketId", (Object)bucketId).resolveTemplate("bundleType", (Object)bundleType.toString());
            FileDataBodyPart fileBodyPart = new FileDataBodyPart("file", bundleFile, MediaType.APPLICATION_OCTET_STREAM_TYPE);
            FormDataMultiPart multipart = new FormDataMultiPart();
            multipart.bodyPart((BodyPart)fileBodyPart);
            if (!StringUtils.isBlank((CharSequence)sha256)) {
                multipart.field("sha256", sha256);
            }
            return (BundleVersion)this.getRequestBuilder(target).post(Entity.entity((Object)multipart, (MediaType)multipart.getMediaType()), BundleVersion.class);
        });
    }

    @Override
    public List<BundleVersionMetadata> getBundleVersions(BundleVersionFilterParams filterParams) throws IOException, NiFiRegistryException {
        return this.executeAction("Error getting extension bundle versions", () -> {
            BundleVersionMetadata[] bundleVersions;
            WebTarget target = this.extensionBundlesTarget.path("/versions");
            if (filterParams != null) {
                if (!StringUtils.isBlank((CharSequence)filterParams.getGroupId())) {
                    target = target.queryParam("groupId", new Object[]{filterParams.getGroupId()});
                }
                if (!StringUtils.isBlank((CharSequence)filterParams.getArtifactId())) {
                    target = target.queryParam("artifactId", new Object[]{filterParams.getArtifactId()});
                }
                if (!StringUtils.isBlank((CharSequence)filterParams.getVersion())) {
                    target = target.queryParam("version", new Object[]{filterParams.getVersion()});
                }
            }
            return (bundleVersions = (BundleVersionMetadata[])this.getRequestBuilder(target).get(BundleVersionMetadata[].class)) == null ? Collections.emptyList() : Arrays.asList(bundleVersions);
        });
    }

    @Override
    public List<BundleVersionMetadata> getBundleVersions(String bundleId) throws IOException, NiFiRegistryException {
        if (StringUtils.isBlank((CharSequence)bundleId)) {
            throw new IllegalArgumentException("Bundle id cannot be null or blank");
        }
        return this.executeAction("Error getting extension bundle versions", () -> {
            WebTarget target = this.extensionBundlesTarget.path("{bundleId}/versions").resolveTemplate("bundleId", (Object)bundleId);
            BundleVersionMetadata[] bundleVersions = (BundleVersionMetadata[])this.getRequestBuilder(target).get(BundleVersionMetadata[].class);
            return bundleVersions == null ? Collections.emptyList() : Arrays.asList(bundleVersions);
        });
    }

    @Override
    public BundleVersion getBundleVersion(String bundleId, String version) throws IOException, NiFiRegistryException {
        if (StringUtils.isBlank((CharSequence)bundleId)) {
            throw new IllegalArgumentException("Bundle id cannot be null or blank");
        }
        if (StringUtils.isBlank((CharSequence)version)) {
            throw new IllegalArgumentException("Version cannot be null or blank");
        }
        return this.executeAction("Error getting extension bundle version", () -> {
            WebTarget target = this.extensionBundlesTarget.path("{bundleId}/versions/{version}").resolveTemplate("bundleId", (Object)bundleId).resolveTemplate("version", (Object)version);
            return (BundleVersion)this.getRequestBuilder(target).get(BundleVersion.class);
        });
    }

    @Override
    public List<ExtensionMetadata> getExtensions(String bundleId, String version) throws IOException, NiFiRegistryException {
        if (StringUtils.isBlank((CharSequence)bundleId)) {
            throw new IllegalArgumentException("Bundle id cannot be null or blank");
        }
        if (StringUtils.isBlank((CharSequence)version)) {
            throw new IllegalArgumentException("Version cannot be null or blank");
        }
        return this.executeAction("Error getting extension bundle metadata", () -> {
            WebTarget target = this.extensionBundlesTarget.path("{bundleId}/versions/{version}/extensions").resolveTemplate("bundleId", (Object)bundleId).resolveTemplate("version", (Object)version);
            ExtensionMetadata[] extensions = (ExtensionMetadata[])this.getRequestBuilder(target).get(ExtensionMetadata[].class);
            return extensions == null ? Collections.emptyList() : Arrays.asList(extensions);
        });
    }

    @Override
    public Extension getExtension(String bundleId, String version, String name) throws IOException, NiFiRegistryException {
        if (StringUtils.isBlank((CharSequence)bundleId)) {
            throw new IllegalArgumentException("Bundle id cannot be null or blank");
        }
        if (StringUtils.isBlank((CharSequence)version)) {
            throw new IllegalArgumentException("Version cannot be null or blank");
        }
        if (StringUtils.isBlank((CharSequence)name)) {
            throw new IllegalArgumentException("Extension name cannot be null or blank");
        }
        return this.executeAction("Error getting extension", () -> {
            WebTarget target = this.extensionBundlesTarget.path("{bundleId}/versions/{version}/extensions/{name}").resolveTemplate("bundleId", (Object)bundleId).resolveTemplate("version", (Object)version).resolveTemplate("name", (Object)name);
            Extension extension = (Extension)this.getRequestBuilder(target).get(Extension.class);
            return extension;
        });
    }

    @Override
    public InputStream getExtensionDocs(String bundleId, String version, String name) throws IOException, NiFiRegistryException {
        if (StringUtils.isBlank((CharSequence)bundleId)) {
            throw new IllegalArgumentException("Bundle id cannot be null or blank");
        }
        if (StringUtils.isBlank((CharSequence)version)) {
            throw new IllegalArgumentException("Version cannot be null or blank");
        }
        if (StringUtils.isBlank((CharSequence)name)) {
            throw new IllegalArgumentException("Extension name cannot be null or blank");
        }
        return this.executeAction("Error getting extension", () -> {
            WebTarget target = this.extensionBundlesTarget.path("{bundleId}/versions/{version}/extensions/{name}/docs").resolveTemplate("bundleId", (Object)bundleId).resolveTemplate("version", (Object)version).resolveTemplate("name", (Object)name);
            return (InputStream)this.getRequestBuilder(target).accept(new String[]{"text/html"}).get().readEntity(InputStream.class);
        });
    }

    @Override
    public InputStream getBundleVersionContent(String bundleId, String version) throws IOException, NiFiRegistryException {
        if (StringUtils.isBlank((CharSequence)bundleId)) {
            throw new IllegalArgumentException("Bundle id cannot be null or blank");
        }
        if (StringUtils.isBlank((CharSequence)version)) {
            throw new IllegalArgumentException("Version cannot be null or blank");
        }
        return this.executeAction("Error getting extension bundle version", () -> {
            WebTarget target = this.extensionBundlesTarget.path("{bundleId}/versions/{version}/content").resolveTemplate("bundleId", (Object)bundleId).resolveTemplate("version", (Object)version);
            return (InputStream)this.getRequestBuilder(target).accept(new MediaType[]{MediaType.APPLICATION_OCTET_STREAM_TYPE}).get().readEntity(InputStream.class);
        });
    }

    @Override
    public File writeBundleVersionContent(String bundleId, String version, File directory) throws IOException, NiFiRegistryException {
        if (StringUtils.isBlank((CharSequence)bundleId)) {
            throw new IllegalArgumentException("Bundle id cannot be null or blank");
        }
        if (StringUtils.isBlank((CharSequence)version)) {
            throw new IllegalArgumentException("Version cannot be null or blank");
        }
        if (directory == null || !directory.exists() || !directory.isDirectory()) {
            throw new IllegalArgumentException("Directory must exist and be a valid directory");
        }
        return this.executeAction("Error getting extension bundle version", () -> {
            WebTarget target = this.extensionBundlesTarget.path("{bundleId}/versions/{version}/content").resolveTemplate("bundleId", (Object)bundleId).resolveTemplate("version", (Object)version);
            Response response = this.getRequestBuilder(target).accept(new MediaType[]{MediaType.APPLICATION_OCTET_STREAM_TYPE}).get();
            return ClientUtils.getExtensionBundleVersionContent(response, directory);
        });
    }

    @Override
    public BundleVersion delete(String bundleId, String version) throws IOException, NiFiRegistryException {
        if (StringUtils.isBlank((CharSequence)bundleId)) {
            throw new IllegalArgumentException("Bundle id cannot be null or blank");
        }
        if (StringUtils.isBlank((CharSequence)version)) {
            throw new IllegalArgumentException("Version cannot be null or blank");
        }
        return this.executeAction("Error deleting extension bundle version", () -> {
            WebTarget target = this.extensionBundlesTarget.path("{bundleId}/versions/{version}").resolveTemplate("bundleId", (Object)bundleId).resolveTemplate("version", (Object)version);
            return (BundleVersion)this.getRequestBuilder(target).delete(BundleVersion.class);
        });
    }
}

