/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.jms.activemq;

import java.util.Collections;
import java.util.List;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.springframework.boot.autoconfigure.jms.activemq.ActiveMQConnectionFactoryCustomizer;
import org.springframework.boot.autoconfigure.jms.activemq.ActiveMQProperties;
import org.springframework.util.Assert;

class ActiveMQConnectionFactoryConfigurer {
    private final ActiveMQProperties properties;
    private final List<ActiveMQConnectionFactoryCustomizer> factoryCustomizers;

    ActiveMQConnectionFactoryConfigurer(ActiveMQProperties properties, List<ActiveMQConnectionFactoryCustomizer> factoryCustomizers) {
        Assert.notNull((Object)properties, (String)"'properties' must not be null");
        this.properties = properties;
        this.factoryCustomizers = factoryCustomizers != null ? factoryCustomizers : Collections.emptyList();
    }

    void configure(ActiveMQConnectionFactory factory) {
        ActiveMQProperties.Packages packages;
        if (this.properties.getCloseTimeout() != null) {
            factory.setCloseTimeout((int)this.properties.getCloseTimeout().toMillis());
        }
        factory.setNonBlockingRedelivery(this.properties.isNonBlockingRedelivery());
        if (this.properties.getSendTimeout() != null) {
            factory.setSendTimeout((int)this.properties.getSendTimeout().toMillis());
        }
        if ((packages = this.properties.getPackages()).getTrustAll() != null) {
            factory.setTrustAllPackages(packages.getTrustAll().booleanValue());
        }
        if (!packages.getTrusted().isEmpty()) {
            factory.setTrustedPackages(packages.getTrusted());
        }
        this.customize(factory);
    }

    private void customize(ActiveMQConnectionFactory connectionFactory) {
        for (ActiveMQConnectionFactoryCustomizer factoryCustomizer : this.factoryCustomizers) {
            factoryCustomizer.customize(connectionFactory);
        }
    }
}

