/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.webauthn.api;

import java.util.Arrays;
import java.util.List;
import org.springframework.security.web.webauthn.api.AuthenticatorResponse;
import org.springframework.security.web.webauthn.api.AuthenticatorTransport;
import org.springframework.security.web.webauthn.api.Bytes;

public final class AuthenticatorAttestationResponse
extends AuthenticatorResponse {
    private final Bytes attestationObject;
    private final List<AuthenticatorTransport> transports;

    private AuthenticatorAttestationResponse(Bytes clientDataJSON, Bytes attestationObject, List<AuthenticatorTransport> transports) {
        super(clientDataJSON);
        this.attestationObject = attestationObject;
        this.transports = transports;
    }

    public Bytes getAttestationObject() {
        return this.attestationObject;
    }

    public List<AuthenticatorTransport> getTransports() {
        return this.transports;
    }

    public static AuthenticatorAttestationResponseBuilder builder() {
        return new AuthenticatorAttestationResponseBuilder();
    }

    public static final class AuthenticatorAttestationResponseBuilder {
        private Bytes attestationObject;
        private List<AuthenticatorTransport> transports;
        private Bytes clientDataJSON;

        private AuthenticatorAttestationResponseBuilder() {
        }

        public AuthenticatorAttestationResponseBuilder attestationObject(Bytes attestationObject) {
            this.attestationObject = attestationObject;
            return this;
        }

        public AuthenticatorAttestationResponseBuilder transports(AuthenticatorTransport ... transports) {
            return this.transports(Arrays.asList(transports));
        }

        public AuthenticatorAttestationResponseBuilder transports(List<AuthenticatorTransport> transports) {
            this.transports = transports;
            return this;
        }

        public AuthenticatorAttestationResponseBuilder clientDataJSON(Bytes clientDataJSON) {
            this.clientDataJSON = clientDataJSON;
            return this;
        }

        public AuthenticatorAttestationResponse build() {
            return new AuthenticatorAttestationResponse(this.clientDataJSON, this.attestationObject, this.transports);
        }
    }
}

