/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.util.security.eddsa;

import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.KeySpec;
import net.i2p.crypto.eddsa.EdDSAPrivateKey;
import net.i2p.crypto.eddsa.spec.EdDSAPublicKeySpec;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.security.PublicKeyFactory;
import org.apache.sshd.common.util.security.SecurityUtils;

public final class EdDSAPublicKeyFactory
implements PublicKeyFactory {
    public static final PublicKeyFactory INSTANCE = new EdDSAPublicKeyFactory();

    private EdDSAPublicKeyFactory() {
    }

    @Override
    public PublicKey getPublicKey(PrivateKey key) {
        ValidateUtils.checkTrue(SecurityUtils.isEDDSACurveSupported(), "EdDSA not supported");
        if (!(key instanceof EdDSAPrivateKey)) {
            return null;
        }
        EdDSAPrivateKey prvKey = (EdDSAPrivateKey)key;
        EdDSAPublicKeySpec keySpec = new EdDSAPublicKeySpec(prvKey.getAbyte(), prvKey.getParams());
        try {
            KeyFactory factory = SecurityUtils.getKeyFactory("Ed25519");
            return factory.generatePublic((KeySpec)keySpec);
        }
        catch (GeneralSecurityException e) {
            return null;
        }
    }
}

