package org.apache.maven.coreit;

/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

import java.io.File;
import java.lang.reflect.Method;
import java.util.List;

import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MavenPluginManager;
import org.apache.maven.plugin.Mojo;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.reporting.exec.MavenPluginManagerHelper;

/**
 * @goal it
 */
public class ItMojo
    extends AbstractMojo
{

    /**
     * @component
     */
    private ComponentManager componentManager;

    /**
     * @component
     */
    private MavenPluginManager pluginManager;

    /**
     * @component
     */
    private MavenPluginManagerHelper pluginManagerHelper;

    /**
     * @parameter default-value="${session}"
     * @readonly
     */
    private MavenSession mvnSession;

    /**
     * @parameter default-value="${plugin.plugin}"
     * @readonly
     */
    private Plugin plugin;

    /**
     * @parameter default-value="${project.build.directory}/touch.txt"
     */
    private File touchFile;

    public void execute()
        throws MojoExecutionException
    {
        try
        {
            PluginDescriptor pluginDescriptor = pluginManagerHelper.getPluginDescriptor( plugin, mvnSession.getCurrentProject().getRemotePluginRepositories(), mvnSession );

            pluginManagerHelper.setupPluginRealm( pluginDescriptor, mvnSession, getClass().getClassLoader(), null, null );

            MojoExecution mojoExec = new MojoExecution( pluginDescriptor.getMojo( "it" ) );

            ClassLoader tccl = Thread.currentThread().getContextClassLoader();

            Mojo mojo = pluginManager.getConfiguredMojo( Mojo.class, mvnSession, mojoExec );
            try
            {
                Thread.currentThread().setContextClassLoader( mojo.getClass().getClassLoader() );
                getLog().info( "Set TCCL to " + Thread.currentThread().getContextClassLoader() );

                Method method = mojo.getClass().getMethod( "check" );
                method.invoke( mojo );
            }
            finally
            {
                pluginManager.releaseMojo( mojo, mojoExec );
                Thread.currentThread().setContextClassLoader( tccl );
            }

            touchFile.getParentFile().mkdirs();
            touchFile.createNewFile();
        }
        catch ( Exception e )
        {
            throw new MojoExecutionException( e.getMessage(), e );
        }
    }

    public void check()
        throws Exception
    {
        Component component = componentManager.get();
        getLog().info( "Got component from " + component.getClass().getClassLoader() );
    }

}
