/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.components.secdispatcher.internal.sources;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.inject.Named;
import javax.inject.Singleton;
import org.codehaus.plexus.components.secdispatcher.MasterSourceMeta;
import org.codehaus.plexus.components.secdispatcher.SecDispatcher;
import org.codehaus.plexus.components.secdispatcher.SecDispatcherException;
import org.codehaus.plexus.components.secdispatcher.internal.sources.PrefixMasterSourceSupport;

@Singleton
@Named(value="env")
public final class EnvMasterSource
extends PrefixMasterSourceSupport
implements MasterSourceMeta {
    public static final String NAME = "env";

    public EnvMasterSource() {
        super("env:");
    }

    @Override
    public String description() {
        return "Environment variable (variable name should be edited)";
    }

    @Override
    public Optional<String> configTemplate() {
        return Optional.of("env:$VARIABLE_NAME");
    }

    @Override
    protected String doHandle(String transformed) throws SecDispatcherException {
        String value = System.getenv(transformed);
        if (value == null) {
            throw new SecDispatcherException("Environment variable '" + transformed + "' not found");
        }
        return value;
    }

    @Override
    protected SecDispatcher.ValidationResponse doValidateConfiguration(String transformed) {
        String value = System.getenv(transformed);
        if (value == null) {
            return new SecDispatcher.ValidationResponse(this.getClass().getSimpleName(), true, Map.of(SecDispatcher.ValidationResponse.Level.WARNING, List.of("Configured environment variable not exist")), List.of());
        }
        return new SecDispatcher.ValidationResponse(this.getClass().getSimpleName(), true, Map.of(SecDispatcher.ValidationResponse.Level.INFO, List.of("Configured environment variable exist")), List.of());
    }
}

