/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.repository;

import java.io.File;
import java.nio.file.Path;
import java.util.Objects;
import org.eclipse.aether.repository.LocalArtifactRequest;
import org.eclipse.aether.repository.RemoteRepository;

public final class LocalArtifactResult {
    private final LocalArtifactRequest request;
    private Path path;
    private boolean available;
    private RemoteRepository repository;

    public LocalArtifactResult(LocalArtifactRequest request) {
        this.request = Objects.requireNonNull(request, "local artifact request cannot be null");
    }

    public LocalArtifactRequest getRequest() {
        return this.request;
    }

    @Deprecated
    public File getFile() {
        return this.path != null ? this.path.toFile() : null;
    }

    public Path getPath() {
        return this.path;
    }

    @Deprecated
    public LocalArtifactResult setFile(File file) {
        return this.setPath(file != null ? file.toPath() : null);
    }

    public LocalArtifactResult setPath(Path path) {
        this.path = path;
        return this;
    }

    public boolean isAvailable() {
        return this.available;
    }

    public LocalArtifactResult setAvailable(boolean available) {
        this.available = available;
        return this;
    }

    public RemoteRepository getRepository() {
        return this.repository;
    }

    public LocalArtifactResult setRepository(RemoteRepository repository) {
        this.repository = repository;
        return this;
    }

    public String toString() {
        return this.getPath() + " (" + (this.isAvailable() ? "available" : "unavailable") + ")";
    }
}

