/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.function.UnaryOperator;
import org.apache.maven.api.di.Named;
import org.apache.maven.api.di.Singleton;
import org.apache.maven.api.model.Build;
import org.apache.maven.api.model.Model;
import org.apache.maven.api.model.Plugin;
import org.apache.maven.api.model.PluginManagement;
import org.apache.maven.api.model.ReportPlugin;
import org.apache.maven.api.model.Reporting;
import org.apache.maven.api.services.ModelBuilderRequest;
import org.apache.maven.api.services.ModelProblemCollector;
import org.apache.maven.api.services.model.PluginConfigurationExpander;
import org.apache.maven.api.xml.XmlNode;
import org.apache.maven.api.xml.XmlService;

@Named
@Singleton
public class DefaultPluginConfigurationExpander
implements PluginConfigurationExpander {
    @Override
    public Model expandPluginConfiguration(Model model, ModelBuilderRequest request, ModelProblemCollector problems) {
        Reporting reporting;
        Build build = model.getBuild();
        if (build != null) {
            PluginManagement pluginManagement = (build = build.withPlugins(this.expandPlugin(build.getPlugins()))).getPluginManagement();
            if (pluginManagement != null) {
                build = build.withPluginManagement(pluginManagement.withPlugins(this.expandPlugin(pluginManagement.getPlugins())));
            }
            model = model.withBuild(build);
        }
        if ((reporting = model.getReporting()) != null) {
            this.expandReport(reporting.getPlugins());
        }
        return model.withBuild(build);
    }

    private List<Plugin> expandPlugin(List<Plugin> oldPlugins) {
        return DefaultPluginConfigurationExpander.map(oldPlugins, plugin -> {
            XmlNode pluginConfiguration = plugin.getConfiguration();
            if (pluginConfiguration != null) {
                return plugin.withExecutions(DefaultPluginConfigurationExpander.map(plugin.getExecutions(), execution -> execution.withConfiguration(XmlService.merge((XmlNode)execution.getConfiguration(), (XmlNode)pluginConfiguration))));
            }
            return plugin;
        });
    }

    private List<ReportPlugin> expandReport(List<ReportPlugin> oldPlugins) {
        return DefaultPluginConfigurationExpander.map(oldPlugins, plugin -> {
            XmlNode pluginConfiguration = plugin.getConfiguration();
            if (pluginConfiguration != null) {
                return plugin.withReportSets(DefaultPluginConfigurationExpander.map(plugin.getReportSets(), report -> report.withConfiguration(XmlService.merge((XmlNode)report.getConfiguration(), (XmlNode)pluginConfiguration))));
            }
            return plugin;
        });
    }

    static <T> List<T> map(List<T> list, UnaryOperator<T> mapper) {
        List<T> newList = list;
        for (int i = 0; i < newList.size(); ++i) {
            T oldT = newList.get(i);
            Object newT = mapper.apply(oldT);
            if (newT == oldT) continue;
            if (newList == list) {
                newList = new ArrayList<T>(list);
            }
            newList.set(i, newT);
        }
        return newList;
    }
}

