/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.ops;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.UUID;
import org.apache.solr.client.solrj.io.Tuple;
import org.apache.solr.client.solrj.io.comp.FieldComparator;
import org.apache.solr.client.solrj.io.comp.StreamComparator;
import org.apache.solr.client.solrj.io.ops.ReduceOperation;
import org.apache.solr.client.solrj.io.stream.expr.Explanation;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionNamedParameter;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionParameter;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionValue;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;

public class GroupOperation
implements ReduceOperation {
    private static final long serialVersionUID = 1L;
    private UUID operationNodeId = UUID.randomUUID();
    private PriorityQueue<Tuple> priorityQueue;
    private Comparator<Tuple> comp;
    private StreamComparator streamComparator;
    private int size;

    public GroupOperation(StreamExpression expression, StreamFactory factory) throws IOException {
        StreamExpressionNamedParameter nParam = factory.getNamedOperand(expression, "n");
        StreamExpressionNamedParameter sortExpression = factory.getNamedOperand(expression, "sort");
        StreamComparator streamComparator = factory.constructComparator(((StreamExpressionValue)sortExpression.getParameter()).getValue(), FieldComparator.class);
        String nStr = ((StreamExpressionValue)nParam.getParameter()).getValue();
        int nInt = 0;
        try {
            nInt = Integer.parseInt(nStr);
            if (nInt <= 0) {
                throw new IOException(String.format(Locale.ROOT, "invalid expression %s - topN '%s' must be greater than 0.", expression, nStr));
            }
        }
        catch (NumberFormatException e) {
            throw new IOException(String.format(Locale.ROOT, "invalid expression %s - topN '%s' is not a valid integer.", expression, nStr));
        }
        this.init(streamComparator, nInt);
    }

    public GroupOperation(StreamComparator streamComparator, int size) {
        this.init(streamComparator, size);
    }

    private void init(StreamComparator streamComparator, int size) {
        this.size = size;
        this.streamComparator = streamComparator;
        this.comp = new ReverseComp(streamComparator);
        this.priorityQueue = new PriorityQueue<Tuple>(size, this.comp);
    }

    @Override
    public StreamExpressionParameter toExpression(StreamFactory factory) throws IOException {
        StreamExpression expression = new StreamExpression(factory.getFunctionName(this.getClass()));
        expression.addParameter(new StreamExpressionNamedParameter("n", Integer.toString(this.size)));
        expression.addParameter(new StreamExpressionNamedParameter("sort", this.streamComparator.toExpression(factory)));
        return expression;
    }

    @Override
    public Explanation toExplanation(StreamFactory factory) throws IOException {
        return new Explanation(this.operationNodeId.toString()).withExpressionType("operation").withFunctionName(factory.getFunctionName(this.getClass())).withImplementingClass(this.getClass().getName()).withExpression(this.toExpression(factory).toString()).withHelpers(new Explanation[]{this.streamComparator.toExplanation(factory)});
    }

    @Override
    public Tuple reduce() {
        LinkedList<Map<String, Object>> ll = new LinkedList<Map<String, Object>>();
        while (this.priorityQueue.size() > 0) {
            ll.addFirst(this.priorityQueue.poll().getFields());
        }
        ArrayList list = new ArrayList(ll);
        Map groupHead = (Map)list.get(0);
        Tuple tuple = new Tuple(groupHead);
        tuple.put("group", list);
        return tuple;
    }

    @Override
    public void operate(Tuple tuple) {
        if (this.priorityQueue.size() >= this.size) {
            Tuple peek = this.priorityQueue.peek();
            if (this.streamComparator.compare(tuple, peek) < 0) {
                this.priorityQueue.poll();
                this.priorityQueue.add(tuple);
            }
        } else {
            this.priorityQueue.add(tuple);
        }
    }

    static class ReverseComp
    implements Comparator<Tuple>,
    Serializable {
        private StreamComparator comp;

        public ReverseComp(StreamComparator comp) {
            this.comp = comp;
        }

        @Override
        public int compare(Tuple t1, Tuple t2) {
            return this.comp.compare(t1, t2) * -1;
        }
    }
}

